/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.annotation;

import io.simpleframework.crud.BaseModelMapper;
import io.simpleframework.crud.Models;
import io.simpleframework.crud.annotation.ModelScan;
import io.simpleframework.crud.annotation.ModelScans;
import io.simpleframework.crud.core.DatasourceType;
import io.simpleframework.crud.core.ModelConfiguration;
import io.simpleframework.crud.core.NameType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ModelScannerRegistrar
implements ImportBeanDefinitionRegistrar {
    private static String getDefaultBasePackage(AnnotationMetadata importingClassMetadata) {
        return ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(ModelScan.class.getName()));
        if (mapperScanAttrs != null) {
            String defaultBasePackage = ModelScannerRegistrar.getDefaultBasePackage(importingClassMetadata);
            this.registerBeanDefinitions(registry, mapperScanAttrs, defaultBasePackage);
        }
    }

    void registerBeanDefinitions(BeanDefinitionRegistry registry, AnnotationAttributes attrs, String defaultBasePackage) {
        Class superClass = attrs.getClass("superClass");
        Class[] annotationClass = attrs.getClassArray("annotationClass");
        String[] basePackages = ModelScannerRegistrar.basePackages(attrs, defaultBasePackage);
        Set<String> classNames = ClassPathModelScanner.scan(superClass, annotationClass, basePackages);
        ModelConfiguration modelConfig = ModelScannerRegistrar.modelConfig(attrs);
        ClassLoader classLoader = ModelScannerRegistrar.class.getClassLoader();
        for (String className : classNames) {
            Class registerClass;
            Class modelClass = ClassUtils.forName((String)className, (ClassLoader)classLoader);
            if (modelClass != (registerClass = Models.register(modelClass, superClass, modelConfig))) continue;
            ModelScannerRegistrar.registerBeanDefinition(registry, modelClass, Models.mapper(modelClass, false));
        }
    }

    private static synchronized void registerBeanDefinition(BeanDefinitionRegistry registry, Class clazz, BaseModelMapper<?> mapper) {
        String beanName = "simpleCrudBaseModelMapper#" + clazz.getName();
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(BaseModelMapper.class, () -> mapper);
        beanDefinition.setTargetType(ResolvableType.forClassWithGenerics(BaseModelMapper.class, (Class[])new Class[]{clazz}));
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private static String[] basePackages(AnnotationAttributes attrs, String defaultPackage) {
        List<String> result = new ArrayList<String>();
        for (String p : attrs.getStringArray("value")) {
            result.add(p);
        }
        for (String p : attrs.getStringArray("basePackages")) {
            result.add(p);
        }
        if (result.isEmpty()) {
            result.add(defaultPackage);
        }
        result = result.stream().filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        return StringUtils.tokenizeToStringArray((String)StringUtils.collectionToCommaDelimitedString(result), (String)",; \t\n");
    }

    private static ModelConfiguration modelConfig(AnnotationAttributes attrs) {
        return new ModelConfiguration((DatasourceType)attrs.getEnum("datasourceType"), attrs.getString("datasourceName"), (NameType)attrs.getEnum("tableNameType"), (NameType)attrs.getEnum("columnNameType"));
    }

    static class ClassPathModelScanner
    extends ClassPathScanningCandidateComponentProvider {
        ClassPathModelScanner(Class<?> superClass, Class<? extends Annotation>[] annotationClass) {
            super(false);
            super.addIncludeFilter((TypeFilter)new AssignableTypeFilter(superClass));
            for (Class<? extends Annotation> clazz : annotationClass) {
                super.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(clazz));
            }
        }

        static Set<String> scan(Class<?> superClass, Class[] annotationClass, String[] packages) {
            HashSet beanNames = new HashSet();
            ClassPathModelScanner scanner = new ClassPathModelScanner(superClass, annotationClass);
            for (String p : packages) {
                beanNames.addAll(scanner.findCandidateComponents(p));
            }
            return beanNames.stream().map(BeanDefinition::getBeanClassName).collect(Collectors.toSet());
        }
    }

    static class RepeatingRegistrar
    extends ModelScannerRegistrar {
        RepeatingRegistrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes mapperScansAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(ModelScans.class.getName()));
            String defaultBasePackage = ModelScannerRegistrar.getDefaultBasePackage(importingClassMetadata);
            if (mapperScansAttrs != null) {
                AnnotationAttributes[] annotations;
                for (AnnotationAttributes annotation : annotations = mapperScansAttrs.getAnnotationArray("value")) {
                    super.registerBeanDefinitions(registry, annotation, defaultBasePackage);
                }
            }
        }
    }
}

