/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.core;

import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.annotation.Condition;
import io.simpleframework.crud.core.ConditionType;
import io.simpleframework.crud.core.SerializedFunction;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Conditions
implements Serializable {
    private final Map<String, List<ConditionInfo>> conditions = new LinkedHashMap<String, List<ConditionInfo>>();
    private static final Map<Class<?>, List<Field>> CONDITION_CACHES = new ConcurrentHashMap();

    public static Conditions of() {
        return new Conditions();
    }

    public Map<String, Object> getConditionData() {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        for (Map.Entry<String, List<ConditionInfo>> entry : this.conditions.entrySet()) {
            ConditionInfo.append(result, entry.getKey(), entry.getValue());
        }
        return result;
    }

    public List<ModelField> getFields(List<ModelField> fields) {
        ArrayList<ModelField> result = new ArrayList<ModelField>();
        for (ModelField field : fields) {
            if (!this.conditions.containsKey(field.fieldName())) continue;
            result.add(field);
        }
        return result;
    }

    public List<ConditionInfo> getConditionInfos(String fieldName, boolean needNullValue) {
        List result = this.conditions.getOrDefault(fieldName, new ArrayList());
        if (needNullValue) {
            if (result.isEmpty()) {
                result.add(ConditionInfo.of(ConditionType.equal, null));
            }
            return result;
        }
        return result.stream().filter(c -> {
            boolean isNullType = c.getType() == ConditionType.is_null || c.getType() == ConditionType.not_null;
            return isNullType || c.getValue() != null;
        }).collect(Collectors.toList());
    }

    public Conditions addCondition(String fieldName, Object value) {
        if (value instanceof ConditionType) {
            return this.addCondition(fieldName, (ConditionType)((Object)value), new Object[]{null});
        }
        if (value instanceof Collection) {
            return this.addCondition(fieldName, ConditionType.in, value);
        }
        return this.addCondition(fieldName, ConditionType.equal, value);
    }

    public <T, R> Conditions addCondition(SerializedFunction<T, R> fieldNameFunc, Object value) {
        if (value instanceof ConditionType) {
            return this.addCondition(fieldNameFunc, (ConditionType)((Object)value), new Object[]{null});
        }
        if (value instanceof Collection) {
            return this.addCondition(fieldNameFunc, ConditionType.in, value);
        }
        return this.addCondition(fieldNameFunc, ConditionType.equal, value);
    }

    public <T, R> Conditions addCondition(SerializedFunction<T, R> fieldNameFunc, ConditionType conditionType, Object ... values) {
        String fieldName = SimpleCrudUtils.getLambdaFieldName(fieldNameFunc);
        return this.addCondition(fieldName, conditionType, values);
    }

    public Conditions addConditionByAnnotation(Object annotation) {
        Conditions.annotationFieldConditions(annotation).forEach((fieldName, fieldConditions) -> fieldConditions.forEach(fieldCondition -> this.addCondition((String)fieldName, fieldCondition.getType(), fieldCondition.getValue())));
        return this;
    }

    public Conditions addCondition(Conditions conditions) {
        conditions.getConditions().forEach((fieldName, fieldConditions) -> fieldConditions.forEach(fieldCondition -> this.addCondition((String)fieldName, fieldCondition.getType(), fieldCondition.getValue())));
        return this;
    }

    public synchronized Conditions addCondition(String fieldName, ConditionType conditionType, Object ... values) {
        if (conditionType == null) {
            conditionType = ConditionType.equal;
        }
        List infos = this.conditions.computeIfAbsent(fieldName, k -> new ArrayList());
        Object value = Conditions.transToValue(conditionType, values);
        ConditionInfo info = ConditionInfo.of(infos.size(), conditionType, value);
        infos.add(info);
        return this;
    }

    private static Object transToValue(ConditionType type, Object ... values) {
        if (values == null) {
            return null;
        }
        int valuesLength = (values = Arrays.stream(values).filter(Objects::nonNull).toArray()).length;
        if (valuesLength == 0) {
            return null;
        }
        if (type == ConditionType.in || type == ConditionType.not_in) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object temp : values) {
                if (temp instanceof Collection) {
                    result.addAll((Collection)temp);
                    continue;
                }
                result.add(temp);
            }
            return result.isEmpty() ? null : result;
        }
        return valuesLength == 1 ? values[0] : Arrays.asList(values);
    }

    private static Map<String, List<ConditionInfo>> annotationFieldConditions(Object annotation) {
        if (annotation == null) {
            return Collections.emptyMap();
        }
        Class<?> annotationClass = annotation.getClass();
        List fields = CONDITION_CACHES.computeIfAbsent(annotationClass, c -> SimpleCrudUtils.getFields(annotationClass, f -> f.isAnnotationPresent(Condition.class)));
        if (fields.isEmpty()) {
            throw new IllegalArgumentException(annotationClass.getName() + " can not found any field declared by @Condition");
        }
        LinkedHashMap<String, List<ConditionInfo>> result = new LinkedHashMap<String, List<ConditionInfo>>();
        for (Field field : fields) {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Condition conditionData = field.getAnnotation(Condition.class);
            String fieldName = conditionData.field();
            if (SimpleCrudUtils.isBlank(fieldName)) {
                fieldName = field.getName();
            }
            ConditionInfo condition = ConditionInfo.of(conditionData.type(), field.get(annotation));
            result.computeIfAbsent(fieldName, f -> new ArrayList()).add(condition);
            if (accessible) continue;
            field.setAccessible(false);
        }
        return result;
    }

    public Map<String, List<ConditionInfo>> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Conditions)) {
            return false;
        }
        Conditions other = (Conditions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<ConditionInfo>> this$conditions = this.getConditions();
        Map<String, List<ConditionInfo>> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Conditions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<ConditionInfo>> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    public String toString() {
        return "Conditions(conditions=" + this.getConditions() + ")";
    }

    public static class ConditionInfo
    implements Serializable {
        private int index;
        private ConditionType type;
        private Object value;

        public static ConditionInfo of(ConditionType type, Object value) {
            return ConditionInfo.of(0, type, value);
        }

        public static ConditionInfo of(int index, ConditionType type, Object value) {
            ConditionInfo result = new ConditionInfo();
            result.setIndex(index);
            result.setType(type);
            result.setValue(value);
            return result;
        }

        static void append(Map<String, Object> result, String fieldName, List<ConditionInfo> conditions) {
            for (ConditionInfo condition : conditions) {
                result.put(condition.getKey(fieldName), condition.getValue());
            }
        }

        public String getKey(String fieldName) {
            return fieldName + this.getIndex();
        }

        public int getIndex() {
            return this.index;
        }

        public ConditionType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setType(ConditionType type) {
            this.type = type;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionInfo)) {
                return false;
            }
            ConditionInfo other = (ConditionInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            ConditionType this$type = this.getType();
            ConditionType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConditionInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            ConditionType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Conditions.ConditionInfo(index=" + this.getIndex() + ", type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ")";
        }
    }
}

