/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.core;

import io.simpleframework.crud.annotation.ModelConfig;
import io.simpleframework.crud.core.DatasourceType;
import io.simpleframework.crud.core.NameType;
import io.simpleframework.crud.util.SimpleCrudUtils;

public class ModelConfiguration {
    public static final ModelConfiguration DEFAULT_CONFIG = new ModelConfiguration();
    public static final ModelConfiguration DEFAULT_CONFIG_FOR_CLASS = new ModelConfiguration(DatasourceType.Mybatis, "", NameType.UNDERLINE_LOWER_CASE);
    private final DatasourceType datasourceType;
    private final String datasourceName;
    private final NameType tableNameType;
    private final NameType columnNameType;

    public ModelConfiguration() {
        this(DatasourceType.CLASS_DEFINED, "");
    }

    public ModelConfiguration(DatasourceType datasourceType, String datasourceName) {
        this(datasourceType, datasourceName, NameType.CLASS_DEFINED);
    }

    public ModelConfiguration(DatasourceType datasourceType, String datasourceName, NameType nameType) {
        this(datasourceType, datasourceName, nameType, nameType);
    }

    public ModelConfiguration(DatasourceType datasourceType, String datasourceName, NameType tableNameType, NameType columnNameType) {
        this.datasourceType = datasourceType != null ? datasourceType : DatasourceType.CLASS_DEFINED;
        this.datasourceName = datasourceName != null ? datasourceName : "";
        this.tableNameType = tableNameType != null ? tableNameType : NameType.CLASS_DEFINED;
        this.columnNameType = columnNameType != null ? columnNameType : NameType.CLASS_DEFINED;
    }

    public static ModelConfiguration fromClass(Class<?> clazz, ModelConfiguration defaultConfig) {
        ModelConfiguration result;
        if (defaultConfig == null) {
            defaultConfig = DEFAULT_CONFIG;
        }
        if (!defaultConfig.hasClassDefined()) {
            return defaultConfig;
        }
        ModelConfiguration modelConfig = ModelConfiguration.fromClass(clazz);
        DatasourceType datasourceType = defaultConfig.datasourceType();
        String datasourceName = defaultConfig.datasourceName();
        NameType tableNameType = defaultConfig.tableNameType();
        NameType columnNameType = defaultConfig.columnNameType();
        if (datasourceType == DatasourceType.CLASS_DEFINED) {
            if (modelConfig.datasourceType() == DatasourceType.CLASS_DEFINED) {
                datasourceType = DEFAULT_CONFIG_FOR_CLASS.datasourceType();
                datasourceName = DEFAULT_CONFIG_FOR_CLASS.datasourceName();
            } else {
                datasourceType = modelConfig.datasourceType();
                datasourceName = modelConfig.datasourceName();
            }
        }
        if (tableNameType == NameType.CLASS_DEFINED) {
            tableNameType = modelConfig.tableNameType() == NameType.CLASS_DEFINED ? DEFAULT_CONFIG_FOR_CLASS.tableNameType() : modelConfig.tableNameType();
        }
        if (columnNameType == NameType.CLASS_DEFINED) {
            columnNameType = modelConfig.columnNameType() == NameType.CLASS_DEFINED ? DEFAULT_CONFIG_FOR_CLASS.columnNameType() : modelConfig.columnNameType();
        }
        if ((result = new ModelConfiguration(datasourceType, datasourceName, tableNameType, columnNameType)).equals(DEFAULT_CONFIG)) {
            return DEFAULT_CONFIG;
        }
        if (result.equals(DEFAULT_CONFIG_FOR_CLASS)) {
            return DEFAULT_CONFIG_FOR_CLASS;
        }
        return result;
    }

    public static ModelConfiguration fromConfig(ModelConfig config) {
        if (config == null) {
            return DEFAULT_CONFIG;
        }
        return new ModelConfiguration(config.datasourceType(), config.datasourceName(), config.tableNameType(), config.columnNameType());
    }

    private static ModelConfiguration fromClass(Class<?> clazz) {
        ModelConfig config = clazz.getAnnotation(ModelConfig.class);
        if (config == null) {
            config = SimpleCrudUtils.getFromSuperclass(clazz, c -> c.getAnnotation(ModelConfig.class));
        }
        return ModelConfiguration.fromConfig(config);
    }

    private boolean hasClassDefined() {
        return this.datasourceType() == DatasourceType.CLASS_DEFINED || this.tableNameType() == NameType.CLASS_DEFINED || this.columnNameType() == NameType.CLASS_DEFINED;
    }

    public DatasourceType datasourceType() {
        return this.datasourceType;
    }

    public String datasourceName() {
        return this.datasourceName;
    }

    public NameType tableNameType() {
        return this.tableNameType;
    }

    public NameType columnNameType() {
        return this.columnNameType;
    }

    public String toString() {
        return "ModelConfiguration(datasourceType=" + (Object)((Object)this.datasourceType()) + ", datasourceName=" + this.datasourceName() + ", tableNameType=" + (Object)((Object)this.tableNameType()) + ", columnNameType=" + (Object)((Object)this.columnNameType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelConfiguration)) {
            return false;
        }
        ModelConfiguration other = (ModelConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DatasourceType this$datasourceType = this.datasourceType();
        DatasourceType other$datasourceType = other.datasourceType();
        if (this$datasourceType == null ? other$datasourceType != null : !((Object)((Object)this$datasourceType)).equals((Object)other$datasourceType)) {
            return false;
        }
        String this$datasourceName = this.datasourceName();
        String other$datasourceName = other.datasourceName();
        if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
            return false;
        }
        NameType this$tableNameType = this.tableNameType();
        NameType other$tableNameType = other.tableNameType();
        if (this$tableNameType == null ? other$tableNameType != null : !((Object)((Object)this$tableNameType)).equals((Object)other$tableNameType)) {
            return false;
        }
        NameType this$columnNameType = this.columnNameType();
        NameType other$columnNameType = other.columnNameType();
        return !(this$columnNameType == null ? other$columnNameType != null : !((Object)((Object)this$columnNameType)).equals((Object)other$columnNameType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DatasourceType $datasourceType = this.datasourceType();
        result = result * 59 + ($datasourceType == null ? 43 : ((Object)((Object)$datasourceType)).hashCode());
        String $datasourceName = this.datasourceName();
        result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
        NameType $tableNameType = this.tableNameType();
        result = result * 59 + ($tableNameType == null ? 43 : ((Object)((Object)$tableNameType)).hashCode());
        NameType $columnNameType = this.columnNameType();
        result = result * 59 + ($columnNameType == null ? 43 : ((Object)((Object)$columnNameType)).hashCode());
        return result;
    }
}

