/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.core;

import io.simpleframework.crud.mapper.mybatis.Pages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = -1L;
    private List<T> items;
    private int pageNum;
    private int pageSize;
    private long total;
    private int pages;
    private long offset;

    private Page(Page<?> other) {
        this.items = new ArrayList<T>();
        this.pageNum = other.getPageNum();
        this.pageSize = other.getPageSize();
        this.total = other.getTotal();
        this.pages = other.getPages();
        this.offset = other.getOffset();
    }

    public static <R> Page<R> of(int pageNum, int pageSize, long total) {
        Page result = new Page();
        result.setItems(new ArrayList());
        result.setPageNum(pageNum);
        result.setPageSize(pageSize);
        result.setTotal(total);
        result.setPages(Pages.calcPages((int)total, pageSize));
        result.setOffset(Pages.calcStartRow(pageNum, pageSize));
        return result;
    }

    public <R> Page<R> convert(Function<? super T, ? extends R> mapper) {
        Page result = new Page(this);
        List collect = this.getItems().stream().map(mapper).collect(Collectors.toList());
        result.setItems(collect);
        return result;
    }

    public List<T> getItems() {
        return this.items;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public int getPages() {
        return this.pages;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        List<T> this$items = this.getItems();
        List<T> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + this.getPages();
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        List<T> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "Page(items=" + this.getItems() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", pages=" + this.getPages() + ", offset=" + this.getOffset() + ")";
    }

    public Page() {
    }
}

