/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.core;

import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.core.ConditionType;
import io.simpleframework.crud.core.Conditions;
import io.simpleframework.crud.core.QuerySorter;
import io.simpleframework.crud.core.SerializedFunction;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryConfig
implements Serializable {
    public static final String SELECT_ALL_FIELD = "*";
    private final Set<String> selectFieldNames = new HashSet<String>();
    private Conditions conditions = Conditions.of();
    private final QuerySorter sorter = QuerySorter.of();

    public static QueryConfig of() {
        return new QueryConfig();
    }

    public List<ModelField> getSelectFields(List<ModelField> fields) {
        if (this.selectFieldNames.isEmpty() || this.selectFieldNames.contains(SELECT_ALL_FIELD)) {
            return fields;
        }
        ArrayList<ModelField> selectFields = new ArrayList<ModelField>();
        for (ModelField field : fields) {
            if (!this.selectFieldNames.contains(field.fieldName())) continue;
            selectFields.add(field);
        }
        return selectFields;
    }

    public QueryConfig addSelect(String ... fieldNames) {
        return this.addSelect(Arrays.asList(fieldNames));
    }

    public <T, R> QueryConfig addSelect(SerializedFunction<T, R> fieldNameFunc) {
        String fieldName = SimpleCrudUtils.getLambdaFieldName(fieldNameFunc);
        return this.addSelect(fieldName);
    }

    public QueryConfig addSelect(Collection<String> fieldNames) {
        this.selectFieldNames.addAll(fieldNames);
        return this;
    }

    public QueryConfig addCondition(String fieldName, Object value) {
        this.conditions.addCondition(fieldName, value);
        return this;
    }

    public <T, R> QueryConfig addCondition(SerializedFunction<T, R> fieldNameFunc, Object value) {
        this.conditions.addCondition(fieldNameFunc, value);
        return this;
    }

    public synchronized QueryConfig addCondition(String fieldName, ConditionType conditionType, Object ... values) {
        this.conditions.addCondition(fieldName, conditionType, values);
        return this;
    }

    public <T, R> QueryConfig addCondition(SerializedFunction<T, R> fieldNameFunc, ConditionType conditionType, Object ... values) {
        this.conditions.addCondition(fieldNameFunc, conditionType, values);
        return this;
    }

    public QueryConfig addCondition(Conditions conditions) {
        this.conditions.addCondition(conditions);
        return this;
    }

    public QueryConfig addConditionByAnnotation(Object annotation) {
        this.conditions.addConditionByAnnotation(annotation);
        return this;
    }

    public QueryConfig addSorter(QuerySorter sorter) {
        this.sorter.getItems().putAll(sorter.getItems());
        return this;
    }

    private void merge(QueryConfig config) {
    }

    public Set<String> getSelectFieldNames() {
        return this.selectFieldNames;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public QuerySorter getSorter() {
        return this.sorter;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryConfig)) {
            return false;
        }
        QueryConfig other = (QueryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$selectFieldNames = this.getSelectFieldNames();
        Set<String> other$selectFieldNames = other.getSelectFieldNames();
        if (this$selectFieldNames == null ? other$selectFieldNames != null : !((Object)this$selectFieldNames).equals(other$selectFieldNames)) {
            return false;
        }
        Conditions this$conditions = this.getConditions();
        Conditions other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        QuerySorter this$sorter = this.getSorter();
        QuerySorter other$sorter = other.getSorter();
        return !(this$sorter == null ? other$sorter != null : !this$sorter.equals(other$sorter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $selectFieldNames = this.getSelectFieldNames();
        result = result * 59 + ($selectFieldNames == null ? 43 : ((Object)$selectFieldNames).hashCode());
        Conditions $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        QuerySorter $sorter = this.getSorter();
        result = result * 59 + ($sorter == null ? 43 : $sorter.hashCode());
        return result;
    }

    public String toString() {
        return "QueryConfig(selectFieldNames=" + this.getSelectFieldNames() + ", conditions=" + this.getConditions() + ", sorter=" + this.getSorter() + ")";
    }
}

