/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.domain;

import io.simpleframework.crud.core.QueryConfig;
import io.simpleframework.crud.domain.DomainRepository;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DomainRepoFindImpl {
    public static <T> T findById(DomainRepository repo, T domainModel, Serializable id) {
        Object aggr = repo.getAggrInfo().mapper().findById(id);
        if (aggr == null) {
            return null;
        }
        repo.getAggrField().set(domainModel, aggr);
        Map<Field, List> valueObjects = DomainRepoFindImpl.findValueObjects(repo, id);
        DomainRepoFindImpl.setValueObjects(repo, domainModel, valueObjects);
        return domainModel;
    }

    private static Map<Field, List> findValueObjects(DomainRepository repo, Serializable id) {
        HashMap<Field, List> valueObjects = new HashMap<Field, List>();
        for (Field field : repo.getValueInfos().keySet()) {
            String fieldName = repo.getValueRelationFieldName(field);
            QueryConfig queryConfig = QueryConfig.of().addCondition(fieldName, (Object)id);
            List value = repo.getValueMapper(field).listByConfig(queryConfig);
            valueObjects.put(field, value);
        }
        return valueObjects;
    }

    private static void setValueObjects(DomainRepository repo, Object domainModel, Map<Field, List> valueObjects) {
        for (Map.Entry<Field, List> entry : valueObjects.entrySet()) {
            AbstractCollection fieldValue;
            Field field = entry.getKey();
            List fieldObjs = entry.getValue();
            if (List.class.isAssignableFrom(field.getType())) {
                fieldValue = new ArrayList();
                ((List)((Object)fieldValue)).addAll(fieldObjs);
            } else if (Set.class.isAssignableFrom(field.getType())) {
                fieldValue = new LinkedHashSet();
                ((Set)((Object)fieldValue)).addAll(fieldObjs);
            } else {
                fieldValue = fieldObjs.isEmpty() ? null : fieldObjs.get(0);
            }
            field.set(domainModel, fieldValue);
        }
    }
}

