/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.domain;

import io.simpleframework.crud.BaseModelMapper;
import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.ModelInfo;
import io.simpleframework.crud.core.ConditionType;
import io.simpleframework.crud.core.Conditions;
import io.simpleframework.crud.domain.DomainRepository;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DomainRepoSaveImpl {
    public static <R extends Serializable> R save(DomainRepository repo, Object domainModel) {
        if (domainModel == null) {
            return null;
        }
        Result result = new Result(repo, domainModel);
        DomainRepoSaveImpl.saveAggrEntity(result);
        DomainRepoSaveImpl.valueObjectsSetModelId(result);
        DomainRepoSaveImpl.saveValueObjects(result);
        return (R)((Serializable)result.modelId);
    }

    private static void saveAggrEntity(Result result) {
        ModelInfo modelInfo = result.repo.getAggrInfo();
        BaseModelMapper<Object> modelMapper = modelInfo.mapper();
        ModelField modelField = modelInfo.id();
        Object entity = result.repo.getAggrField().get(result.domainModel);
        result.modelId = modelField.getValue(entity);
        boolean bl = result.isNew = result.modelId == null;
        if (result.isNew) {
            modelMapper.insert(entity);
            result.modelId = modelField.getValue(entity);
        } else {
            modelMapper.updateById(entity);
        }
    }

    private static void valueObjectsSetModelId(Result result) {
        LinkedHashMap<Field, Object> valueObjects = new LinkedHashMap<Field, Object>();
        for (Map.Entry<Field, ModelInfo> entry : result.repo.getValueInfos().entrySet()) {
            Field field = entry.getKey();
            Object fieldValue = field.get(result.domainModel);
            if (fieldValue == null) {
                valueObjects.put(field, null);
                continue;
            }
            String relationFieldName = result.repo.getValueRelationFieldName(field);
            ModelField relationField = entry.getValue().getField(relationFieldName);
            Object modelId = result.modelId;
            if (fieldValue instanceof Collection) {
                for (Object v : (Collection)fieldValue) {
                    relationField.setValue(v, modelId);
                }
            } else {
                relationField.setValue(fieldValue, modelId);
            }
            valueObjects.put(field, fieldValue);
        }
        result.valueObjects = valueObjects;
    }

    private static void saveValueObjects(Result result) {
        for (Map.Entry<Field, Object> entry : result.valueObjects.entrySet()) {
            Field field = entry.getKey();
            Object fieldValue = entry.getValue();
            if (result.isNew) {
                DomainRepoSaveImpl.insertValueObject(result.repo, field, fieldValue);
                continue;
            }
            DomainRepoSaveImpl.insertAndUpdateValueObject(result.repo, field, fieldValue, result.modelId);
        }
    }

    private static void insertValueObject(DomainRepository repo, Field field, Object fieldValue) {
        if (fieldValue == null) {
            return;
        }
        ArrayList<Object> newValueObjects = new ArrayList<Object>();
        if (fieldValue instanceof Collection) {
            for (Object v : (Collection)fieldValue) {
                newValueObjects.add(v);
            }
        } else {
            newValueObjects.add(fieldValue);
        }
        repo.getValueMapper(field).batchInsert(newValueObjects);
    }

    private static void insertAndUpdateValueObject(DomainRepository repo, Field field, Object fieldValue, Object modelId) {
        BaseModelMapper modelMapper = repo.getValueMapper(field);
        Conditions deleteConditions = Conditions.of().addCondition(repo.getValueRelationFieldName(field), ConditionType.equal, modelId);
        if (fieldValue == null) {
            modelMapper.deleteByConditions(deleteConditions);
            return;
        }
        ModelField idField = repo.getValueIdField(field);
        if (idField == null) {
            modelMapper.deleteByConditions(deleteConditions);
            DomainRepoSaveImpl.insertValueObject(repo, field, fieldValue);
            return;
        }
        ArrayList<Object> newValueObjects = new ArrayList<Object>();
        ArrayList<Object> updateValueObjects = new ArrayList<Object>();
        ArrayList<Object> updateValueObjectIds = new ArrayList<Object>();
        if (fieldValue instanceof Collection) {
            for (Object e : (Collection)fieldValue) {
                Object valueObjectId = idField.getValue(e);
                if (valueObjectId == null) {
                    newValueObjects.add(e);
                    continue;
                }
                updateValueObjects.add(e);
                updateValueObjectIds.add(valueObjectId);
            }
        } else {
            Object valueObjectId = idField.getValue(fieldValue);
            if (valueObjectId == null) {
                newValueObjects.add(fieldValue);
            } else {
                updateValueObjects.add(fieldValue);
                updateValueObjectIds.add(valueObjectId);
            }
        }
        if (updateValueObjects.isEmpty()) {
            modelMapper.deleteByConditions(deleteConditions);
        } else {
            deleteConditions = Conditions.of().addCondition(repo.getValueRelationFieldName(field), ConditionType.equal, modelId).addCondition(idField.fieldName(), ConditionType.not_in, updateValueObjectIds);
            modelMapper.deleteByConditions(deleteConditions);
            for (Object e : updateValueObjects) {
                modelMapper.updateById(e);
            }
        }
        if (!newValueObjects.isEmpty()) {
            modelMapper.batchInsert(newValueObjects);
        }
    }

    private static class Result {
        DomainRepository repo;
        Object domainModel;
        Object modelId;
        boolean isNew;
        Map<Field, Object> valueObjects;

        Result(DomainRepository repo, Object domainModel) {
            this.repo = repo;
            this.domainModel = domainModel;
        }
    }
}

