/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.domain;

import io.simpleframework.crud.BaseModelMapper;
import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.ModelInfo;
import io.simpleframework.crud.Models;
import io.simpleframework.crud.annotation.DomainEntity;
import io.simpleframework.crud.annotation.DomainValueObject;
import io.simpleframework.crud.annotation.ModelConfig;
import io.simpleframework.crud.core.ModelConfiguration;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DomainRepository {
    private Field aggrField;
    private ModelInfo aggrInfo;
    private final Map<Field, ModelInfo> valueInfos = new LinkedHashMap<Field, ModelInfo>(8);
    private final Map<Field, Class> valueModelClasses = new HashMap<Field, Class>(8);
    private final Map<Field, String> valueRelationFieldNames = new HashMap<Field, String>(8);

    String getValueRelationFieldName(Field field) {
        return this.valueRelationFieldNames.get(field);
    }

    BaseModelMapper getValueMapper(Field field) {
        Class modelClass = this.valueModelClasses.get(field);
        return this.valueInfos.get(field).mapper(modelClass);
    }

    ModelField getValueIdField(Field field) {
        return this.valueInfos.get(field).id();
    }

    public static DomainRepository of(Class<?> domainClass) {
        DomainRepository result = new DomainRepository();
        List<Field> fields = SimpleCrudUtils.getFields(domainClass, f -> f.isAnnotationPresent(DomainEntity.class) || f.isAnnotationPresent(DomainValueObject.class));
        for (Field field : fields) {
            field.setAccessible(true);
            DomainEntity entity = field.getAnnotation(DomainEntity.class);
            DomainValueObject valueObject = field.getAnnotation(DomainValueObject.class);
            if (entity != null) {
                result.setAggr(domainClass, field);
                continue;
            }
            if (valueObject == null) continue;
            result.addValueObject(domainClass, field, valueObject.field());
        }
        if (result.getAggrField() == null) {
            throw new IllegalArgumentException(domainClass + " can not found a field to be AGGREGATE_ROOT");
        }
        return result;
    }

    private void setAggr(Class<?> domainClass, Field field) {
        if (this.aggrField != null) {
            throw new IllegalArgumentException(domainClass + " found more than one field declared by @DomainEntity");
        }
        this.aggrField = field;
        this.aggrInfo = DomainRepository.buildInfo(field, field.getType());
        if (this.aggrInfo.id() == null) {
            throw new IllegalArgumentException("Can not found id field from " + field.getType());
        }
    }

    private void addValueObject(Class<?> domainClass, Field field, String relationFieldName) {
        ModelInfo<?> info;
        Class<?> clazz = field.getType();
        if (List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz)) {
            clazz = SimpleCrudUtils.getGenericClass(field, clazz);
        }
        if ((info = DomainRepository.buildInfo(field, clazz)).getField(relationFieldName) == null) {
            throw new IllegalArgumentException(domainClass + " can not found a field named " + relationFieldName + " from " + clazz);
        }
        this.valueInfos.put(field, info);
        this.valueModelClasses.put(field, clazz);
        this.valueRelationFieldNames.put(field, relationFieldName);
    }

    private static ModelInfo<?> buildInfo(Field field, Class clazz) {
        ModelInfo<Object> result;
        ModelConfig modelConfig = field.getAnnotation(ModelConfig.class);
        if (modelConfig != null) {
            result = Models.createInfo(clazz, ModelConfiguration.fromConfig(modelConfig));
        } else {
            result = Models.info(clazz, false);
            if (result == null) {
                result = Models.createInfo(clazz, null);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("@ModelEntity is not support " + clazz);
        }
        return result;
    }

    public Field getAggrField() {
        return this.aggrField;
    }

    public ModelInfo getAggrInfo() {
        return this.aggrInfo;
    }

    public Map<Field, ModelInfo> getValueInfos() {
        return this.valueInfos;
    }

    public Map<Field, Class> getValueModelClasses() {
        return this.valueModelClasses;
    }

    public Map<Field, String> getValueRelationFieldNames() {
        return this.valueRelationFieldNames;
    }
}

