/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.info;

import io.simpleframework.crud.util.Snowflake;
import java.util.UUID;

@FunctionalInterface
public interface IdGenerator {
    public static final IdGenerator UUID32_ID_GENERATOR = () -> UUID.randomUUID().toString().replace("-", "");
    public static final IdGenerator UUID36_ID_GENERATOR = () -> UUID.randomUUID().toString();
    public static final IdGenerator DEFAULT_SNOWFLAKE_ID_GENERATOR = new SnowflakeIdGenerator(1609430400000L);

    public Object generate();

    public static class SnowflakeIdGenerator
    implements IdGenerator {
        private final Snowflake snowflake;

        public SnowflakeIdGenerator(long beginTime) {
            this.snowflake = new Snowflake(beginTime);
        }

        @Override
        public Object generate() {
            return this.snowflake.nextId();
        }
    }
}

