/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.info.clazz;

import com.baomidou.mybatisplus.annotation.TableField;
import io.simpleframework.crud.core.NameType;
import io.simpleframework.crud.info.AbstractModelField;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.lang.reflect.Field;
import javax.persistence.Column;

public class ClassModelField
extends AbstractModelField {
    private final Field field;

    ClassModelField(Field field, NameType nameType) {
        TableField mpColumn;
        this.field = field;
        field.setAccessible(true);
        String fieldName = field.getName();
        boolean insertable = true;
        boolean updatable = true;
        String columnName = null;
        io.simpleframework.crud.annotation.Column crudColumn = this.field.getAnnotation(io.simpleframework.crud.annotation.Column.class);
        if (crudColumn != null) {
            columnName = crudColumn.name();
            insertable = crudColumn.insertable();
            updatable = crudColumn.updatable();
        } else if (SimpleCrudUtils.jpaPresent) {
            Column jpaColumn = this.field.getAnnotation(Column.class);
            if (jpaColumn != null) {
                columnName = jpaColumn.name();
                insertable = jpaColumn.insertable();
                updatable = jpaColumn.updatable();
            }
        } else if (SimpleCrudUtils.mybatisPlusPresent && (mpColumn = this.field.getAnnotation(TableField.class)) != null) {
            columnName = mpColumn.value();
        }
        if (SimpleCrudUtils.isBlank(columnName)) {
            columnName = nameType.trans(fieldName);
        }
        super.setColumn(columnName, fieldName, field.getType());
        super.setInsertable(insertable);
        super.setUpdatable(updatable);
    }

    @Override
    public <T> Object getValue(T model) {
        return this.field.get(model);
    }

    @Override
    public <T> void setValue(T model, Object value) {
        this.field.set(model, value);
    }

    Field getField() {
        return this.field;
    }
}

