/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.info.clazz;

import com.baomidou.mybatisplus.annotation.TableName;
import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.annotation.Id;
import io.simpleframework.crud.annotation.IdStrategy;
import io.simpleframework.crud.core.ModelConfiguration;
import io.simpleframework.crud.core.NameType;
import io.simpleframework.crud.info.AbstractModelInfo;
import io.simpleframework.crud.info.ModelId;
import io.simpleframework.crud.info.clazz.ClassModelField;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.Table;
import javax.persistence.Transient;

public class ClassModelInfo<T>
extends AbstractModelInfo<T> {
    private static final String DEFAULT_ID_FIELD = "id";

    public ClassModelInfo(Class<T> modelClass, ModelConfiguration modelConfig) {
        super(modelClass, modelConfig, ClassModelInfo.obtainModelName(modelClass, modelConfig.tableNameType()));
        List<ModelField> modelFields = ClassModelInfo.obtainFields(modelClass, modelConfig.columnNameType());
        super.setId(ClassModelInfo.obtainModelId(modelFields));
        super.addField(modelFields);
    }

    private static String obtainModelName(Class<?> clazz, NameType nameType) {
        TableName mpTable;
        BiFunction<String, String, String> nameTrans = (modelName, definedName) -> {
            if (SimpleCrudUtils.hasText(definedName)) {
                modelName = definedName;
            }
            return modelName;
        };
        BiFunction<String, String, String> schemaTrans = (modelName, definedSchema) -> {
            if (SimpleCrudUtils.hasText(definedSchema)) {
                modelName = definedSchema + "." + modelName;
            }
            return modelName;
        };
        String modelName2 = nameType.trans(clazz.getSimpleName());
        io.simpleframework.crud.annotation.Table crudTable = clazz.getAnnotation(io.simpleframework.crud.annotation.Table.class);
        if (crudTable != null) {
            modelName2 = nameTrans.apply(modelName2, crudTable.name());
            modelName2 = schemaTrans.apply(modelName2, crudTable.schema());
        } else if (SimpleCrudUtils.jpaPresent) {
            Table jpaTable = clazz.getAnnotation(Table.class);
            if (jpaTable != null) {
                modelName2 = nameTrans.apply(modelName2, jpaTable.name());
                modelName2 = schemaTrans.apply(modelName2, jpaTable.schema());
            }
        } else if (SimpleCrudUtils.mybatisPlusPresent && (mpTable = clazz.getAnnotation(TableName.class)) != null) {
            modelName2 = nameTrans.apply(modelName2, mpTable.value());
            modelName2 = schemaTrans.apply(modelName2, mpTable.schema());
        }
        return modelName2;
    }

    private static List<ModelField> obtainFields(Class<?> clazz, NameType nameType) {
        Predicate<Field> fieldFilter = field -> {
            int modifiers = field.getModifiers();
            boolean isStatic = Modifier.isStatic(modifiers);
            boolean isTransient = Modifier.isTransient(modifiers);
            if (!isTransient) {
                isTransient = SimpleCrudUtils.jpaPresent && field.isAnnotationPresent(Transient.class);
            }
            return !isStatic && !isTransient;
        };
        return SimpleCrudUtils.getFields(clazz, fieldFilter).stream().map(f -> new ClassModelField((Field)f, nameType)).collect(Collectors.toList());
    }

    private static ModelId obtainModelId(List<ModelField> modelFields) {
        ClassModelField field;
        ClassModelField idField = null;
        for (ModelField modelField : modelFields) {
            field = (ClassModelField)modelField;
            if (!field.getField().isAnnotationPresent(Id.class)) continue;
            idField = field;
            break;
        }
        if (idField == null) {
            for (ModelField modelField : modelFields) {
                field = (ClassModelField)modelField;
                if (SimpleCrudUtils.jpaPresent && field.getField().isAnnotationPresent(javax.persistence.Id.class)) {
                    idField = field;
                    break;
                }
                if (!DEFAULT_ID_FIELD.equals(modelField.fieldName())) continue;
                idField = field;
            }
        }
        if (idField == null) {
            return null;
        }
        IdStrategy strategy = idField.getField().getAnnotation(IdStrategy.class);
        return strategy == null ? new ModelId(idField) : new ModelId(idField, strategy.type(), strategy.beginTime());
    }
}

