/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.mapper;

import io.simpleframework.crud.BaseModelMapper;
import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.ModelInfo;
import io.simpleframework.crud.core.QueryConfig;
import java.util.Collection;

public abstract class AbstractModelMapper<T>
implements BaseModelMapper<T> {
    private final ModelInfo<T> modelInfo;

    protected AbstractModelMapper(ModelInfo<T> modelInfo) {
        this.modelInfo = modelInfo;
    }

    protected void setIdValueIfAbsent(Object model) {
        ModelField id = this.modelInfo.id();
        if (id == null) {
            return;
        }
        if (model instanceof Collection) {
            for (Object m : (Collection)model) {
                id.setValue(m, null);
            }
        } else {
            id.setValue(model, null);
        }
    }

    protected QueryConfig combineQueryConfigs(QueryConfig ... configs) {
        int configLength;
        int n = configLength = configs == null ? 0 : configs.length;
        if (configLength == 0) {
            return QueryConfig.of();
        }
        QueryConfig result = configs[0];
        for (int i = 1; i < configLength; ++i) {
            QueryConfig config = configs[i];
            result.addSelect(config.getSelectFieldNames());
            result.addCondition(config.getConditions());
            result.addSorter(config.getSorter());
        }
        return result;
    }

    protected ModelInfo<T> getModelInfo() {
        return this.modelInfo;
    }
}

