/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.mapper.mybatis;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.ModelInfo;
import io.simpleframework.crud.Models;
import io.simpleframework.crud.core.Conditions;
import io.simpleframework.crud.core.QueryConfig;
import io.simpleframework.crud.mapper.AbstractModelMapper;
import io.simpleframework.crud.mapper.mybatis.Pages;
import io.simpleframework.crud.mapper.mybatis.SqlSourceProvider;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class MybatisModelMapper<T>
extends AbstractModelMapper<T> {
    private final String namespace;
    private final Class<? extends T> modelClass;
    private final SqlSourceProvider sqlSourceProvider;

    public MybatisModelMapper(Class<? extends T> modelClass, ModelInfo<T> modelInfo) {
        super(modelInfo);
        boolean dynamicModel = Map.class.isAssignableFrom(modelClass);
        this.namespace = dynamicModel ? modelInfo.name() + System.nanoTime() : modelClass.getName();
        this.modelClass = modelClass;
        this.sqlSourceProvider = new SqlSourceProvider(modelInfo, dynamicModel);
    }

    @Override
    public boolean insert(T model) {
        if (model == null) {
            return false;
        }
        super.setIdValueIfAbsent(model);
        String msId = this.mappedStatement("insert", SqlCommandType.INSERT, Integer.class, this.sqlSourceProvider::insert);
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                boolean bl = session.insert(msId, model) == 1;
                return bl;
            }
        }
        return this.sqlSession().insert(msId, model) == 1;
    }

    @Override
    public boolean batchInsert(List<? extends T> models) {
        if (models == null || models.isEmpty()) {
            return false;
        }
        super.setIdValueIfAbsent(models);
        String msId = this.mappedStatement("batchInsert", SqlCommandType.INSERT, Integer.class, this.sqlSourceProvider::batchInsert);
        HashMap<String, List<T>> param = new HashMap<String, List<T>>(3);
        param.put("list", models);
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                boolean bl = session.insert(msId, param) > 0;
                return bl;
            }
        }
        return this.sqlSession().insert(msId, param) > 0;
    }

    @Override
    public boolean deleteById(Serializable id) {
        if (id == null) {
            return false;
        }
        String msId = this.mappedStatement("deleteById", SqlCommandType.DELETE, Integer.class, this.sqlSourceProvider::deleteById);
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                boolean bl = session.delete(msId, (Object)id) == 1;
                return bl;
            }
        }
        return this.sqlSession().delete(msId, (Object)id) == 1;
    }

    @Override
    public boolean deleteByIds(Collection<? extends Serializable> ids) {
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        String msId = this.mappedStatement("deleteByIds", SqlCommandType.DELETE, Integer.class, this.sqlSourceProvider::deleteByIds);
        HashMap<String, Collection<? extends Serializable>> param = new HashMap<String, Collection<? extends Serializable>>(3);
        param.put("ids", ids);
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                boolean bl = session.delete(msId, param) > 0;
                return bl;
            }
        }
        return this.sqlSession().delete(msId, param) > 0;
    }

    @Override
    public int deleteByConditions(Conditions conditions) {
        if (conditions == null || conditions.getConditions().isEmpty()) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u6761\u4ef6\u5220\u9664");
        }
        String msId = this.mappedStatement("deleteByConditions", SqlCommandType.DELETE, Integer.class, this.sqlSourceProvider::deleteByConditions);
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("config", conditions);
        param.put("data", conditions.getConditionData());
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                int n = session.delete(msId, param);
                return n;
            }
        }
        return this.sqlSession().delete(msId, param);
    }

    @Override
    public boolean updateById(T model) {
        if (model == null) {
            return false;
        }
        String msId = this.mappedStatement("updateById", SqlCommandType.UPDATE, Integer.class, c -> this.sqlSourceProvider.updateById((Configuration)c, false));
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                boolean bl = session.update(msId, model) == 1;
                return bl;
            }
        }
        return this.sqlSession().update(msId, model) == 1;
    }

    @Override
    public boolean updateByIdWithNull(T model) {
        if (model == null) {
            return false;
        }
        String msId = this.mappedStatement("updateByIdWithNull", SqlCommandType.UPDATE, Integer.class, c -> this.sqlSourceProvider.updateById((Configuration)c, true));
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                boolean bl = session.update(msId, model) == 1;
                return bl;
            }
        }
        return this.sqlSession().update(msId, model) == 1;
    }

    @Override
    public int updateByConditions(T model, Conditions conditions) {
        if (model == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u8981\u4fee\u6539\u7684\u6a21\u578b");
        }
        if (conditions == null || conditions.getConditions().isEmpty()) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u6761\u4ef6\u4fee\u6539");
        }
        String msId = this.mappedStatement("updateByConditions", SqlCommandType.UPDATE, Integer.class, this.sqlSourceProvider::updateByConditions);
        HashMap<String, Object> param = new HashMap<String, Object>(6);
        param.put("model", model);
        param.put("config", conditions);
        param.put("data", conditions.getConditionData());
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                int n = session.update(msId, param);
                return n;
            }
        }
        return this.sqlSession().update(msId, param);
    }

    @Override
    public <R extends T> R findById(Serializable id) {
        if (id == null) {
            return null;
        }
        String msId = this.mappedStatement("findById", SqlCommandType.SELECT, this.modelClass, this.sqlSourceProvider::findById);
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                Object object = session.selectOne(msId, (Object)id);
                return (R)object;
            }
        }
        return (R)this.sqlSession().selectOne(msId, (Object)id);
    }

    @Override
    public <R extends T> List<R> listByIds(Collection<? extends Serializable> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        String msId = this.mappedStatement("listByIds", SqlCommandType.SELECT, this.modelClass, this.sqlSourceProvider::listByIds);
        HashMap<String, Collection<? extends Serializable>> param = new HashMap<String, Collection<? extends Serializable>>(3);
        param.put("ids", ids);
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                List list = session.selectList(msId, param);
                return list;
            }
        }
        return this.sqlSession().selectList(msId, param);
    }

    @Override
    public <R extends T> List<R> listByCondition(R model, QueryConfig ... configs) {
        return this.listByCondition(new HashMap<String, Object>(6), model, configs);
    }

    private <R extends T> List<R> listByCondition(Map<String, Object> param, R model, QueryConfig ... configs) {
        QueryConfig queryConfig = super.combineQueryConfigs(configs);
        boolean dynamicQuery = model == null || configs.length > 0;
        String msId = this.mappedStatement(dynamicQuery ? "listByConfig" : "listByCondition", SqlCommandType.SELECT, this.modelClass, c -> this.sqlSourceProvider.listByCondition((Configuration)c, dynamicQuery));
        param.put("model", model);
        param.put("config", queryConfig);
        param.put("data", queryConfig.getConditions().getConditionData());
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                List list = session.selectList(msId, param);
                return list;
            }
        }
        return this.sqlSession().selectList(msId, param);
    }

    @Override
    public <R extends T> io.simpleframework.crud.core.Page<R> pageByCondition(R model, int pageNum, int pageSize, QueryConfig ... configs) {
        long total = this.countByCondition(model, configs);
        if (total == 0L) {
            return io.simpleframework.crud.core.Page.of(pageNum, pageSize, total);
        }
        if (SimpleCrudUtils.pageHelperPresent) {
            return Pages.doSelectPage(pageNum, pageSize, () -> this.listByCondition(model, configs), total);
        }
        if (SimpleCrudUtils.mybatisPlusPresent) {
            Page mybatisPlusPage = new Page((long)pageNum, (long)pageSize, total, false);
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("_page", mybatisPlusPage);
            List<R> items = this.listByCondition(param, model, configs);
            io.simpleframework.crud.core.Page result = io.simpleframework.crud.core.Page.of(pageNum, pageSize, total);
            result.setItems(items);
            return result;
        }
        throw new IllegalArgumentException("\u67e5\u65e0 mybatis \u5206\u9875\u63d2\u4ef6\uff0c\u53ea\u652f\u6301 PageHelper \u6216 MyBatis-Plus");
    }

    @Override
    public long countByCondition(T model, QueryConfig ... configs) {
        Long result;
        boolean dynamicQuery = model == null || configs.length > 0;
        String msId = this.mappedStatement(dynamicQuery ? "countByConfig" : "countByCondition", SqlCommandType.SELECT, Long.class, c -> this.sqlSourceProvider.countByCondition((Configuration)c, dynamicQuery));
        QueryConfig queryConfig = super.combineQueryConfigs(configs);
        HashMap<String, Object> param = new HashMap<String, Object>(6);
        param.put("model", model);
        param.put("config", queryConfig);
        param.put("data", queryConfig.getConditions().getConditionData());
        if (this.needCloseSqlSession()) {
            try (SqlSession session = this.sqlSession();){
                result = (Long)session.selectOne(msId, param);
            }
        } else {
            result = (Long)this.sqlSession().selectOne(msId, param);
        }
        return result == null ? 0L : result;
    }

    private String mappedStatement(String methodName, SqlCommandType commandType, Class<?> resultType, Function<Configuration, SqlSource> sqlSourceFunction) {
        String msId = String.format("%s.%s.%s", this.namespace, commandType, methodName);
        Configuration configuration = this.sqlSession().getConfiguration();
        if (configuration.hasStatement(msId, false)) {
            return msId;
        }
        String keyColumn = null;
        String keyFieldName = null;
        NoKeyGenerator keyGenerator = NoKeyGenerator.INSTANCE;
        ModelField modelId = super.getModelInfo().id();
        if (commandType == SqlCommandType.INSERT && modelId != null && !modelId.insertable()) {
            keyColumn = modelId.column();
            keyFieldName = modelId.fieldName();
            keyGenerator = Jdbc3KeyGenerator.INSTANCE;
        }
        SqlSource sqlSource = sqlSourceFunction.apply(configuration);
        MappedStatement ms = new MappedStatement.Builder(configuration, msId, sqlSource, commandType).resultMaps(Collections.singletonList(new ResultMap.Builder(configuration, msId, resultType, new ArrayList()).build())).keyGenerator((KeyGenerator)keyGenerator).keyColumn(keyColumn).keyProperty(keyFieldName).build();
        configuration.addMappedStatement(ms);
        return msId;
    }

    private SqlSession sqlSession() {
        String datasourceName = super.getModelInfo().config().datasourceName();
        return Models.datasourceProvider().mybatisSqlSession(datasourceName);
    }

    private boolean needCloseSqlSession() {
        String datasourceName = super.getModelInfo().config().datasourceName();
        return Models.datasourceProvider().mybatisSqlSessionCloseable(datasourceName);
    }
}

