/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.mapper.mybatis;

import io.simpleframework.crud.ModelField;
import io.simpleframework.crud.ModelInfo;
import io.simpleframework.crud.core.Conditions;
import io.simpleframework.crud.core.QueryConfig;
import io.simpleframework.crud.mapper.mybatis.MybatisScripts;
import io.simpleframework.crud.util.SimpleCrudUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;

public class SqlSourceProvider {
    private final boolean dynamic;
    private final ModelInfo<?> modelInfo;

    public SqlSourceProvider(ModelInfo<?> modelInfo, boolean dynamic) {
        this.dynamic = dynamic;
        this.modelInfo = modelInfo;
    }

    public SqlSource insert(Configuration config) {
        return this.buildSqlSource(config, () -> {
            List<ModelField> fields = this.modelInfo.getInsertFields();
            String columnScript = MybatisScripts.insertColumnScript(fields, true);
            String fieldScript = MybatisScripts.insertFieldScript(fields, true, "");
            return String.format("<script>INSERT INTO %s %s VALUES \n %s</script>", this.modelInfo.name(), columnScript, fieldScript);
        });
    }

    public SqlSource batchInsert(Configuration config) {
        return this.buildSqlSource(config, () -> {
            List<ModelField> fields = this.modelInfo.getInsertFields();
            String itemPrefix = "et";
            String columnScript = MybatisScripts.insertColumnScript(fields, false);
            String fieldScript = MybatisScripts.insertFieldScript(fields, false, itemPrefix);
            fieldScript = String.format("<foreach collection=\"list\" item=\"%s\" separator=\",\">%s</foreach>", itemPrefix, fieldScript);
            return String.format("<script>INSERT INTO %s %s VALUES \n %s</script>", this.modelInfo.name(), columnScript, fieldScript);
        });
    }

    public SqlSource deleteById(Configuration config) {
        return this.buildSqlSource(config, () -> {
            ModelField idField = this.getAndValidIdField();
            return String.format("DELETE FROM %s WHERE %s = #{id}", this.modelInfo.name(), idField.column());
        });
    }

    public SqlSource deleteByIds(Configuration config) {
        return this.buildSqlSource(config, () -> {
            ModelField idField = this.getAndValidIdField();
            String condition = MybatisScripts.foreach("ids", "id");
            return String.format("<script>DELETE FROM %s WHERE %s IN \n %s </script>", this.modelInfo.name(), idField.column(), condition);
        });
    }

    public SqlSource deleteByConditions(Configuration config) {
        return SqlSourceProvider.buildDynamicSqlSource(config, p -> {
            Map param = (Map)p;
            Conditions conditions = (Conditions)param.get("config");
            List<ModelField> conditionFields = conditions.getFields(this.modelInfo.getAllFields());
            if (conditionFields.isEmpty()) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u6761\u4ef6\u5220\u9664");
            }
            String condition = MybatisScripts.conditionScript(conditionFields, conditions, false);
            if (SimpleCrudUtils.isBlank(condition)) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u6761\u4ef6\u5220\u9664");
            }
            return String.format("<script>DELETE FROM %s %s</script>", this.modelInfo.name(), condition);
        });
    }

    public SqlSource updateById(Configuration config, boolean updateNullField) {
        Supplier<String> scriptFunc = () -> {
            ModelField idField = this.getAndValidIdField();
            String script = this.modelInfo.getUpdateFields().stream().map(field -> {
                String set = MybatisScripts.columnEqual(field) + ",";
                return updateNullField ? set : MybatisScripts.wrapperIf(field, set);
            }).collect(Collectors.joining("\n"));
            return String.format("<script>UPDATE %s \n <set>%s</set> \n WHERE %s</script>", this.modelInfo.name(), script, MybatisScripts.columnEqual(idField));
        };
        return this.buildSqlSource(config, scriptFunc);
    }

    public SqlSource updateByConditions(Configuration config) {
        return SqlSourceProvider.buildDynamicSqlSource(config, p -> {
            Map param = (Map)p;
            Conditions conditions = (Conditions)param.get("config");
            List<ModelField> conditionFields = conditions.getFields(this.modelInfo.getAllFields());
            if (conditionFields.isEmpty()) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u6761\u4ef6\u4fee\u6539");
            }
            String script = this.modelInfo.getUpdateFields().stream().map(field -> {
                String fieldName = "model." + field.fieldName();
                String set = String.format("%s = #{%s},", field.column(), fieldName);
                return MybatisScripts.wrapperIf(fieldName, set);
            }).collect(Collectors.joining("\n"));
            if (SimpleCrudUtils.isBlank(script)) {
                throw new IllegalArgumentException("\u65e0\u53ef\u4fee\u6539\u5b57\u6bb5");
            }
            String condition = MybatisScripts.conditionScript(conditionFields, conditions, false);
            if (SimpleCrudUtils.isBlank(condition)) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u6761\u4ef6\u4fee\u6539");
            }
            return String.format("<script>UPDATE %s \n <set>%s</set> \n %s</script>", this.modelInfo.name(), script, condition);
        });
    }

    public SqlSource findById(Configuration config) {
        return this.buildSqlSource(config, () -> {
            ModelField idField = this.getAndValidIdField();
            List<ModelField> fields = this.modelInfo.getAllFields();
            String script = MybatisScripts.selectColumnFromTable(this.modelInfo.name(), fields);
            return String.format("<script>%s WHERE %s = #{id}</script>", script, idField.column());
        });
    }

    public SqlSource listByIds(Configuration config) {
        return this.buildSqlSource(config, () -> {
            ModelField idField = this.getAndValidIdField();
            List<ModelField> fields = this.modelInfo.getAllFields();
            String script = MybatisScripts.selectColumnFromTable(this.modelInfo.name(), fields);
            String condition = "<foreach collection=\"ids\" item=\"id\" open=\"(\" separator=\",\" close=\")\">#{id}</foreach>";
            return String.format("<script>%s WHERE \n %s IN \n %s </script>", script, idField.column(), condition);
        });
    }

    public SqlSource listByCondition(Configuration config, boolean dynamicQuery) {
        if (dynamicQuery) {
            return SqlSourceProvider.buildDynamicSqlSource(config, p -> {
                Map param = (Map)p;
                boolean hasModelCondition = param.get("model") != null;
                QueryConfig queryConfig = (QueryConfig)param.get("config");
                List<ModelField> allFields = this.modelInfo.getAllFields();
                String column = MybatisScripts.selectColumnFromTable(this.modelInfo.name(), queryConfig.getSelectFields(allFields));
                String condition = MybatisScripts.conditionScript(allFields, queryConfig.getConditions(), hasModelCondition);
                String sort = MybatisScripts.sortScript(allFields, queryConfig.getSorter());
                return "<script>" + column + condition + sort + "</script>";
            });
        }
        return this.buildSqlSource(config, () -> {
            List<ModelField> allFields = this.modelInfo.getAllFields();
            String column = MybatisScripts.selectColumnFromTable(this.modelInfo.name(), allFields);
            String condition = MybatisScripts.conditionScript(allFields);
            return "<script>" + column + condition + "</script>";
        });
    }

    public SqlSource countByCondition(Configuration config, boolean dynamicQuery) {
        if (dynamicQuery) {
            return SqlSourceProvider.buildDynamicSqlSource(config, p -> {
                Map param = (Map)p;
                boolean hasModelCondition = param.get("model") != null;
                QueryConfig queryConfig = (QueryConfig)param.get("config");
                List<ModelField> fields = this.modelInfo.getAllFields();
                String condition = MybatisScripts.conditionScript(fields, queryConfig.getConditions(), hasModelCondition);
                return String.format("<script>SELECT COUNT(*) FROM %s %s</script>", this.modelInfo.name(), condition);
            });
        }
        return this.buildSqlSource(config, () -> {
            List<ModelField> fields = this.modelInfo.getAllFields();
            String condition = MybatisScripts.conditionScript(fields);
            return String.format("<script>SELECT COUNT(*) FROM %s %s</script>", this.modelInfo.name(), condition);
        });
    }

    private ModelField getAndValidIdField() {
        ModelField modelId = this.modelInfo.id();
        if (modelId == null) {
            throw new IllegalArgumentException(String.format("%s \u672a\u914d\u7f6e id \u5b57\u6bb5", this.modelInfo.name()));
        }
        return modelId;
    }

    private SqlSource buildSqlSource(Configuration config, Supplier<String> script) {
        if (this.dynamic) {
            return SqlSourceProvider.buildDynamicSqlSource(config, p -> (String)script.get());
        }
        return config.getDefaultScriptingLanguageInstance().createSqlSource(config, script.get(), null);
    }

    private static SqlSource buildDynamicSqlSource(Configuration config, Function<Object, String> script) {
        return param -> config.getDefaultScriptingLanguageInstance().createSqlSource(config, (String)script.apply(param), null).getBoundSql(param);
    }
}

