/*
 * Decompiled with CFR 0.152.
 */
package io.simpleframework.crud.util;

import io.simpleframework.crud.core.SerializedFunction;
import java.lang.invoke.SerializedLambda;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SimpleCrudUtils {
    private static final List<String> PROXY_CLASSES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");
    private static final Map<Class<?>, WeakReference<SerializedLambda>> LAMBDA_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, WeakReference<Constructor>> CONSTRUCTORS = new ConcurrentHashMap();
    public static boolean jpaPresent;
    public static boolean pageHelperPresent;
    public static boolean mybatisPlusPresent;

    public static Class<?> getTargetClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        boolean isProxy = false;
        for (Class<?> cls : clazz.getInterfaces()) {
            if (!PROXY_CLASSES.contains(cls.getName())) continue;
            isProxy = true;
            break;
        }
        return isProxy ? clazz.getSuperclass() : clazz;
    }

    public static String camelToUnderline(String param) {
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static List<Field> getFields(Class<?> clazz, Predicate<Field> fieldFilter) {
        ArrayList superFields = new ArrayList();
        for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(superFields, declaredFields);
        }
        Map fields = Stream.of(clazz.getDeclaredFields()).collect(Collectors.toMap(Field::getName, f -> f, (o1, o2) -> o1, LinkedHashMap::new));
        for (Field field : superFields) {
            String fieldName = field.getName();
            if (fields.containsKey(fieldName)) continue;
            fields.put(fieldName, field);
        }
        return fields.values().stream().filter(fieldFilter).collect(Collectors.toList());
    }

    public static String getLambdaFieldName(SerializedFunction<?, ?> function) {
        boolean firstCharNeedToLower;
        Class<?> funcClass = function.getClass();
        SerializedLambda lambda = Optional.ofNullable(LAMBDA_CACHE.get(funcClass)).map(Reference::get).orElseGet(() -> {
            SerializedLambda temp;
            try {
                Method method = funcClass.getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(Boolean.TRUE);
                temp = (SerializedLambda)method.invoke((Object)function, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            LAMBDA_CACHE.put(funcClass, new WeakReference<SerializedLambda>(temp));
            return temp;
        });
        String result = lambda.getImplMethodName();
        if (result.startsWith("is")) {
            result = result.substring(2);
        } else if (result.startsWith("get") || result.startsWith("set")) {
            result = result.substring(3);
        }
        boolean bl = firstCharNeedToLower = result.length() == 1 || result.length() > 1 && !Character.isUpperCase(result.charAt(1));
        if (firstCharNeedToLower) {
            result = result.substring(0, 1).toLowerCase(Locale.ENGLISH) + result.substring(1);
        }
        return result;
    }

    public static <T> T getFromSuperclass(Class<?> clazz, Function<Class<?>, T> func) {
        if (clazz == null || clazz == Object.class) {
            return null;
        }
        T result = null;
        for (Class<?> supperClass = clazz.getSuperclass(); result == null && supperClass != null && supperClass != Object.class; supperClass = supperClass.getSuperclass()) {
            result = func.apply(supperClass);
        }
        return result;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> constructorParameterTypes) {
        return Optional.ofNullable(CONSTRUCTORS.get(clazz)).map(Reference::get).orElseGet(() -> {
            Constructor c = null;
            try {
                c = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                try {
                    c = clazz.getDeclaredConstructor(constructorParameterTypes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CONSTRUCTORS.put(clazz, new WeakReference(c));
            return c;
        });
    }

    public static Class<?> getGenericClass(Field field, Class<?> defaultClass) {
        Class result = defaultClass;
        Type genericType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        try {
            result = (Class)genericType;
        }
        catch (Exception ignore) {
            try {
                result = (Class)((ParameterizedType)genericType).getRawType();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean hasText(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(String str) {
        return !SimpleCrudUtils.hasText(str);
    }

    static {
        try {
            Class.forName("javax.persistence.Table");
            jpaPresent = true;
        }
        catch (Throwable e) {
            jpaPresent = false;
        }
        try {
            Class.forName("com.github.pagehelper.PageHelper");
            pageHelperPresent = true;
        }
        catch (Throwable e) {
            pageHelperPresent = false;
        }
        try {
            Class.forName("com.baomidou.mybatisplus.core.metadata.IPage");
            mybatisPlusPresent = true;
        }
        catch (Throwable e) {
            mybatisPlusPresent = false;
        }
    }
}

