/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.simplesource.api.CommandId;
import io.simplesource.kafka.api.CommandSerdes;
import io.simplesource.kafka.model.CommandRequest;
import io.simplesource.kafka.model.CommandResponse;
import io.simplesource.kafka.serialization.json.JsonGenericMapper;
import io.simplesource.kafka.serialization.json.JsonSerdes;
import io.simplesource.kafka.serialization.util.GenericMapper;
import io.simplesource.kafka.serialization.util.GenericSerde;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

public final class JsonCommandSerdes<K, C>
extends JsonSerdes<K, C>
implements CommandSerdes<K, C> {
    private final Serde<String> serde = Serdes.String();
    private final Gson gson;
    private final JsonParser parser;
    private final Serde<K> ak;
    private final Serde<CommandRequest<K, C>> cr;
    private final Serde<CommandId> crk;
    private final Serde<CommandResponse<K>> cr2;

    public JsonCommandSerdes() {
        this(JsonGenericMapper.jsonDomainMapper(), JsonGenericMapper.jsonDomainMapper());
    }

    public JsonCommandSerdes(GenericMapper<K, JsonElement> keyMapper, GenericMapper<C, JsonElement> commandMapper) {
        super(keyMapper, commandMapper);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(CommandRequest.class, (Object)new JsonSerdes.CommandRequestAdapter(this));
        gsonBuilder.registerTypeAdapter(CommandId.class, (Object)new JsonSerdes.CommandIdAdapter(this));
        gsonBuilder.registerTypeAdapter(CommandResponse.class, (Object)new JsonSerdes.CommandResponseAdapter(this));
        this.gson = gsonBuilder.create();
        this.parser = new JsonParser();
        this.ak = GenericSerde.of(this.serde, k -> ((JsonElement)keyMapper.toGeneric(k)).toString(), s -> keyMapper.fromGeneric(this.parser.parse(s)));
        this.cr = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (CommandRequest)this.gson.fromJson(s, new TypeToken<CommandRequest<K, C>>(){}.getType()));
        this.crk = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (CommandId)this.gson.fromJson(s, new TypeToken<CommandId>(){}.getType()));
        this.cr2 = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (CommandResponse)this.gson.fromJson(s, new TypeToken<CommandResponse>(){}.getType()));
    }

    public Serde<K> aggregateKey() {
        return this.ak;
    }

    public Serde<CommandRequest<K, C>> commandRequest() {
        return this.cr;
    }

    public Serde<CommandId> commandId() {
        return this.crk;
    }

    public Serde<CommandResponse<K>> commandResponse() {
        return this.cr2;
    }
}

