/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.simplesource.kafka.serialization.util.GenericMapper;
import java.util.Optional;

public final class JsonGenericMapper<D>
implements GenericMapper<D, JsonElement> {
    private static final String VALUE = "value";
    private static final String CLASS = "class";
    private final Gson gson = new Gson();
    private static final JsonGenericMapper INSTANCE = new JsonGenericMapper();

    private JsonGenericMapper() {
    }

    @Override
    public JsonElement toGeneric(D value) {
        JsonObject wrapper = new JsonObject();
        wrapper.add(VALUE, this.gson.toJsonTree(value));
        wrapper.addProperty(CLASS, (String)Optional.ofNullable(value).map(o -> o.getClass().getName()).orElse(null));
        return wrapper;
    }

    @Override
    public D fromGeneric(JsonElement serialized) {
        JsonObject wrapper = serialized.getAsJsonObject();
        if (wrapper.get(CLASS).isJsonNull()) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(wrapper.get(CLASS).getAsString());
            return (D)this.gson.fromJson(wrapper.get(VALUE), clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid JSON domain object", e);
        }
    }

    public static <D> GenericMapper<D, JsonElement> jsonDomainMapper() {
        return INSTANCE;
    }
}

