/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery;

import java.util.HashMap;
import java.util.Map;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.atomic.AbstractTimeInstant;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.DTD;
import org.brackit.xquery.atomic.Date;
import org.brackit.xquery.atomic.DateTime;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Time;
import org.brackit.xquery.node.SimpleStore;
import org.brackit.xquery.node.d2linked.D2NodeFactory;
import org.brackit.xquery.update.UpdateList;
import org.brackit.xquery.update.op.UpdateOp;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.JsonStore;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.brackit.xquery.xdm.node.NodeFactory;
import org.brackit.xquery.xdm.node.NodeStore;
import org.brackit.xquery.xdm.type.ItemType;

public class BrackitQueryContext
implements QueryContext {
    protected static final NodeFactory<?> FACTORY = new D2NodeFactory();
    protected static final NodeStore STORE = null;
    private final NodeFactory<?> nodeFactory;
    private final NodeStore nodeStore;
    private UpdateList updates;
    private Item extCtxItem;
    private ItemType extCtxItemType;
    private Map<QNm, Sequence> externalVars;
    private Node<?> defaultDocument;
    private NodeCollection<?> defaultCollection;
    private DateTime dateTime;
    private Date date;
    private Time time;
    private final DTD implicitTimezone = AbstractTimeInstant.LOCAL_TIMEZONE;

    public BrackitQueryContext() {
        this.nodeFactory = FACTORY;
        this.nodeStore = new SimpleStore();
    }

    public BrackitQueryContext(NodeStore store) {
        this.nodeFactory = FACTORY;
        this.nodeStore = store;
    }

    @Override
    public void addPendingUpdate(UpdateOp op) {
        if (this.updates == null) {
            this.updates = new UpdateList();
        }
        this.updates.append(op);
    }

    @Override
    public void applyUpdates() {
        if (this.updates != null) {
            this.updates.apply();
        }
    }

    @Override
    public UpdateList getUpdateList() {
        return this.updates;
    }

    @Override
    public void setUpdateList(UpdateList updates) {
        this.updates = updates;
    }

    @Override
    public void bind(QNm name, Sequence sequence) {
        if (this.externalVars == null) {
            this.externalVars = new HashMap<QNm, Sequence>(3);
        }
        this.externalVars.put(name, sequence);
    }

    @Override
    public Sequence resolve(QNm name) {
        return this.externalVars != null ? this.externalVars.get(name) : null;
    }

    @Override
    public boolean isBound(QNm name) {
        return this.externalVars != null && this.externalVars.containsKey(name);
    }

    @Override
    public void setContextItem(Item item) {
        this.extCtxItem = item;
        if (item != null) {
            this.extCtxItemType = item.itemType();
        }
    }

    @Override
    public Item getContextItem() {
        return this.extCtxItem;
    }

    @Override
    public ItemType getItemType() {
        return this.extCtxItemType;
    }

    @Override
    public Node<?> getDefaultDocument() {
        return this.defaultDocument;
    }

    @Override
    public void setDefaultDocument(Node<?> defaultDocument) {
        this.defaultDocument = defaultDocument;
    }

    @Override
    public NodeCollection<?> getDefaultCollection() {
        return this.defaultCollection;
    }

    @Override
    public void setDefaultCollection(NodeCollection<?> defaultCollection) {
        this.defaultCollection = defaultCollection;
    }

    @Override
    public DateTime getDateTime() {
        return this.dateTime != null ? this.dateTime : (this.dateTime = new DateTime(this.implicitTimezone));
    }

    @Override
    public Date getDate() {
        return this.date != null ? this.date : (this.date = new Date(this.getDateTime()));
    }

    @Override
    public Time getTime() {
        return this.time != null ? this.time : (this.time = new Time(this.getDateTime()));
    }

    @Override
    public DTD getImplicitTimezone() {
        return this.implicitTimezone;
    }

    @Override
    public AnyURI getBaseUri() {
        return AnyURI.EMPTY;
    }

    @Override
    public NodeFactory<?> getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    @Override
    public JsonStore getJsonItemStore() {
        return null;
    }
}

