/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brackit.xquery.BrackitQueryContext;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.node.parser.DocumentParser;
import org.brackit.xquery.util.io.URIHandler;
import org.brackit.xquery.xdm.StructuredItem;
import org.brackit.xquery.xdm.node.NodeCollection;
import org.brackit.xquery.xdm.node.NodeFactory;

public class Main {
    private static final List<Option> options = new ArrayList<Option>();

    public static void main(String[] args) {
        try {
            Config config = Main.parseParams(args);
            BrackitQueryContext ctx = new BrackitQueryContext();
            String file = config.getValue("-f");
            if (file != null) {
                URI uri = new URI(file);
                try (InputStream in = URIHandler.getInputStream(uri);){
                    DocumentParser parser = new DocumentParser(in);
                    String name = uri.toURL().getFile();
                    NodeFactory<?> factory = ctx.getNodeFactory();
                    NodeCollection<?> coll = factory.collection(name, parser);
                    StructuredItem doc = coll.getDocument();
                    ctx.setContextItem(doc);
                }
            }
            String query = config.isSet("-q") && !"-".equals(config.getValue("-q")) ? Main.readFile(config.getValue("-q")) : Main.readString(System.in);
            XQuery xq = new XQuery(query);
            if (config.isSet("-p")) {
                xq.prettyPrint();
            }
            xq.serialize((QueryContext)ctx, System.out);
        }
        catch (QueryException e) {
            System.out.println("Error: " + e.getMessage());
            System.exit(-2);
        }
        catch (IOException e) {
            System.out.println("I/O Error: " + e.getMessage());
            System.exit(-3);
        }
        catch (Throwable e) {
            System.out.println("Error: " + e.getMessage());
            System.exit(-4);
        }
    }

    private static Config parseParams(String[] args) throws Exception {
        Config config = new Config();
        for (int i = 0; i < args.length; ++i) {
            boolean valid = false;
            String s = args[i];
            for (Option o : options) {
                if (!o.key.equals(s)) continue;
                String val = o.hasValue ? args[++i] : null;
                config.setOption(o.key, val);
                valid = true;
                break;
            }
            if (valid) continue;
            Main.printUsage();
            throw new Exception("Invalid parameter: " + s);
        }
        return config;
    }

    private static String readFile(String file) throws IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            String string = Main.readString(fin);
            return string;
        }
    }

    private static String readString(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        while ((r = in.read()) != -1) {
            payload.write(r);
        }
        return payload.toString(StandardCharsets.UTF_8);
    }

    private static void printUsage() {
        System.out.println("No query provided");
        System.out.println(String.format("Usage: java %s [options]", Main.class.getName()));
        System.out.println("Options:");
        for (Option o : options) {
            System.out.print(" ");
            System.out.print(o.key);
            if (o.hasValue) {
                System.out.print(" <param>\t");
            } else {
                System.out.print("\t\t");
            }
            System.out.print("- ");
            System.out.println(o.desc);
        }
        System.exit(-1);
    }

    static {
        options.add(new Option("-q", "query file [use '-' for stdin (default)]", true));
        options.add(new Option("-f", "default document", true));
        options.add(new Option("-p", "pretty print", false));
    }

    private static class Config {
        Map<String, String> options = new HashMap<String, String>();

        private Config() {
        }

        boolean isSet(String option) {
            return this.options.containsKey(option);
        }

        String getValue(String option) {
            return this.options.get(option);
        }

        void setOption(String option, String value) {
            this.options.put(option, value);
        }
    }

    private static class Option {
        final String key;
        final String desc;
        final boolean hasValue;

        Option(String key, String desc, boolean hasValue) {
            this.key = key;
            this.desc = desc;
            this.hasValue = hasValue;
        }
    }
}

