/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.array;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.sequence.FlatteningSequence;
import org.brackit.xquery.xdm.AbstractItem;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Array;
import org.brackit.xquery.xdm.type.ArrayType;
import org.brackit.xquery.xdm.type.ItemType;

public abstract class AbstractArray
extends AbstractItem
implements Array {
    @Override
    public ItemType itemType() throws QueryException {
        return ArrayType.ARRAY;
    }

    @Override
    public Atomic atomize() throws QueryException {
        throw new QueryException(ErrorCode.ERR_ITEM_HAS_NO_TYPED_VALUE, "The atomized value of array items is undefined");
    }

    @Override
    public boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value of array items is undefined.");
    }

    @Override
    public Iter iterate() {
        return new BaseIter(){
            private List<Sequence> sequences;
            private final Deque<Item> flatteningSequences = new ArrayDeque<Item>();
            private int index;

            @Override
            public Item next() {
                if (this.sequences == null) {
                    this.sequences = AbstractArray.this.values();
                } else if (!this.flatteningSequences.isEmpty()) {
                    return this.flatteningSequences.removeFirst();
                }
                if (this.index < this.sequences.size()) {
                    Sequence sequence;
                    if ((sequence = this.sequences.get(this.index++)) instanceof FlatteningSequence) {
                        try (Iter iter = sequence.iterate();){
                            Item item;
                            while ((item = iter.next()) != null) {
                                this.flatteningSequences.addLast(item);
                            }
                            Item item2 = this.flatteningSequences.removeFirst();
                            return item2;
                        }
                    }
                    return (Item)sequence;
                }
                return null;
            }

            @Override
            public void close() {
            }
        };
    }
}

