/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.array;

import java.util.List;
import java.util.Objects;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.array.AbstractArray;
import org.brackit.xquery.array.DRArray;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Array;
import org.magicwerk.brownies.collections.GapList;

public final class DArray
extends AbstractArray {
    private final List<Sequence> vals;

    public DArray(List<? extends Sequence> vals) {
        this.vals = new GapList(vals);
    }

    @Override
    public List<Sequence> values() {
        return this.vals;
    }

    @Override
    public Array insert(int index, Sequence value) {
        if (index < 0 || index > this.vals.size()) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
        this.vals.add(index, value);
        return this;
    }

    @Override
    public Array append(Sequence value) {
        this.vals.add(value);
        return this;
    }

    @Override
    public Array replaceAt(int index, Sequence value) {
        if (index < 0 || index > this.vals.size() - 1) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
        this.vals.set(index, value);
        return this;
    }

    @Override
    public Array replaceAt(IntNumeric index, Sequence value) {
        this.replace(index.intValue(), value);
        return this;
    }

    @Override
    public Array insert(IntNumeric index, Sequence value) {
        return this.insert(index.intValue(), value);
    }

    @Override
    public Array remove(int index) {
        if (index < 0 || index > this.vals.size() - 1) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
        this.vals.remove(index);
        return this;
    }

    @Override
    public Array remove(IntNumeric index) {
        return this.remove(index.intValue());
    }

    @Override
    public Sequence at(IntNumeric index) {
        return this.at(index.intValue());
    }

    @Override
    public Sequence at(int i) {
        try {
            return this.vals.get(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", i);
        }
    }

    @Override
    public IntNumeric length() {
        int length = this.vals.size();
        return length <= 20 ? Int32.ZERO_TWO_TWENTY[length] : new Int32(length);
    }

    @Override
    public int len() {
        return this.vals.size();
    }

    @Override
    public Array range(IntNumeric from, IntNumeric to) {
        try {
            Objects.checkFromToIndex(from.intValue(), to.intValue(), this.vals.size());
        }
        catch (IndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array indexes: %s", e.getMessage());
        }
        return new DRArray(this.vals, from.intValue(), to.intValue());
    }
}

