/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.array;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.array.AbstractArray;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.json.Array;

public final class DRArray
extends AbstractArray {
    private final List<Sequence> vals;
    private final int start;
    private final int end;

    public DRArray(List<Sequence> vals, int start, int end) {
        if (start < 0 || start > end || start >= vals.size()) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array start index: %s", start);
        }
        if (end > vals.size()) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array end index: %s", end);
        }
        this.vals = vals;
        this.start = start;
        this.end = end;
    }

    @Override
    public Array replaceAt(IntNumeric index, Sequence value) {
        this.replace(index.intValue(), value);
        return this;
    }

    @Override
    public Array replaceAt(int index, Sequence value) {
        if (this.start + index < 0 || this.start + index > this.vals.size()) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
        this.vals.set(this.start + index, value);
        return this;
    }

    @Override
    public Array insert(int index, Sequence value) {
        if (this.start + index < 0 || this.start + index > this.vals.size() - 1) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
        this.vals.add(this.start + index, value);
        return this;
    }

    @Override
    public Array append(Sequence value) {
        this.vals.add(value);
        return this;
    }

    @Override
    public Array remove(int index) {
        if (this.start + index < 0 || this.start + index > this.vals.size() - 1) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
        this.vals.remove(this.start + index);
        return this;
    }

    @Override
    public Array remove(IntNumeric index) {
        return this.remove(index.intValue());
    }

    @Override
    public Array insert(IntNumeric index, Sequence value) {
        return this.insert(index.intValue(), value);
    }

    @Override
    public List<Sequence> values() {
        ArrayList<Sequence> values = new ArrayList<Sequence>();
        int length = this.len();
        for (int i = 0; i < length; ++i) {
            values.add(this.at(i));
        }
        return values;
    }

    @Override
    public Sequence at(IntNumeric index) throws QueryException {
        try {
            int ii = this.start + index.intValue();
            if (ii >= this.end) {
                throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
            }
            return this.vals.get(ii);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
    }

    @Override
    public Sequence at(int index) throws QueryException {
        try {
            int ii = this.start + index;
            if (ii >= this.end) {
                throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
            }
            return this.vals.get(ii);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array index: %s", index);
        }
    }

    @Override
    public IntNumeric length() throws QueryException {
        int length = this.end - this.start;
        return length <= 20 ? Int32.ZERO_TWO_TWENTY[length] : new Int32(length);
    }

    @Override
    public int len() throws QueryException {
        return this.end - this.start;
    }

    @Override
    public Array range(IntNumeric from, IntNumeric to) throws QueryException {
        try {
            Objects.checkFromToIndex(from.intValue(), to.intValue(), this.vals.size());
        }
        catch (IndexOutOfBoundsException e) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Invalid array indexes: %s", e.getMessage());
        }
        return new DRArray(this.vals, this.start + from.intValue(), this.start + to.intValue());
    }
}

