/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractAtomic;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Duration;

public abstract class AbstractDuration
extends AbstractAtomic
implements Duration {
    @Override
    public int hashCode() {
        throw new RuntimeException("Not implemented yet");
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    @Override
    public final boolean eq(Atomic atomic) throws QueryException {
        if (atomic instanceof Duration) {
            Duration other = (Duration)((Object)atomic);
            return this.isNegative() == other.isNegative() && this.getYears() == other.getYears() && this.getMonths() == other.getMonths() && this.getDays() == other.getDays() && this.getHours() == other.getHours() && this.getMinutes() == other.getMinutes() && this.getMicros() == other.getMicros();
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    protected abstract boolean zeroMonthsWhenZero();

    @Override
    public final String stringValue() {
        boolean fieldSet = false;
        boolean timeSet = false;
        StringBuilder out = !this.isNegative() ? new StringBuilder("P") : new StringBuilder("-P");
        short years = this.getYears();
        byte months = this.getMonths();
        short days = this.getDays();
        byte hours = this.getHours();
        byte minutes = this.getMinutes();
        int micros = this.getMicros();
        if (years != 0) {
            out.append(years);
            out.append('Y');
            fieldSet = true;
        }
        if (months != 0) {
            out.append(months);
            out.append('M');
            fieldSet = true;
        }
        if (days != 0) {
            out.append(days);
            out.append('D');
            fieldSet = true;
        }
        if (hours != 0) {
            if (!timeSet) {
                out.append('T');
                timeSet = true;
            }
            out.append(hours);
            out.append('H');
            fieldSet = true;
        }
        if (minutes != 0) {
            if (!timeSet) {
                out.append('T');
                timeSet = true;
            }
            out.append(minutes);
            out.append('M');
            fieldSet = true;
        }
        if (micros != 0) {
            if (!timeSet) {
                out.append('T');
                timeSet = true;
            }
            int seconds = micros / 1000000;
            out.append(seconds);
            int remainder = micros - seconds * 1000000;
            if (remainder != 0) {
                out.append('.');
                out.append(remainder);
            }
            out.append('S');
            fieldSet = true;
        }
        if (!fieldSet) {
            out.append(this.zeroMonthsWhenZero() ? "0M" : "T0S");
        }
        return out.toString();
    }

    @Override
    public final boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value of duration is undefined.");
    }
}

