/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import java.math.BigDecimal;
import org.brackit.xquery.atomic.Int;
import org.brackit.xquery.atomic.Int64;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.atomic.LonNumeric;

public class Counter {
    private long lv;
    private BigDecimal bdv;

    public IntNumeric asIntNumeric() {
        return this.bdv == null ? new Int64(this.lv) : new Int(this.bdv);
    }

    public Counter inc() {
        if (this.bdv == null) {
            if (this.lv < Long.MAX_VALUE) {
                ++this.lv;
                return this;
            }
            this.bdv = new BigDecimal(this.lv);
            this.lv = -1L;
        }
        this.bdv = this.bdv.add(BigDecimal.ONE);
        return this;
    }

    public int cmp(IntNumeric i) {
        if (this.bdv == null) {
            if (i instanceof LonNumeric) {
                long ov = i.longValue();
                return Long.compare(this.lv, ov);
            }
            return new BigDecimal(this.lv).compareTo(i.integerValue());
        }
        return this.bdv.compareTo(i.integerValue());
    }
}

