/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractTimeInstant;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.DTD;
import org.brackit.xquery.atomic.DateTime;
import org.brackit.xquery.atomic.YMD;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.xdm.Type;

public class Date
extends AbstractTimeInstant {
    private final short year;
    private final byte month;
    private final byte day;
    private final DTD timezone;

    public Date(short year, byte month, byte day, DTD timezone) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.timezone = timezone;
    }

    public Date(String str) throws QueryException {
        short year;
        int v;
        DTD timezone = null;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int pos = 0;
        int length = charArray.length;
        boolean negative = false;
        if (pos == length || charArray[pos] == '-') {
            negative = true;
            ++pos;
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        if (end - start < 4) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date", str);
        }
        if (end - start > 4 && negative) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date", str);
        }
        int n = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v > Short.MAX_VALUE || v == 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date", str);
        }
        short s = year = negative ? (short)(-v) : (short)v;
        if (pos >= length || charArray[pos++] != '-') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n2 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 1 || v > 12) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date: illegal month", str);
        }
        byte month = (byte)v;
        if (pos >= length || charArray[pos++] != '-') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n3 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 1 || v > 31) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date: illegal day", str);
        }
        byte day = (byte)v;
        byte maxDaysInMonth = this.maxDayInMonth(year, month);
        if (day > maxDaysInMonth) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:date: Day %s does not exist in month %s of year %s", day, month, year, str);
        }
        if (pos < length) {
            timezone = this.parseTimezone(str, charArray, pos, length);
        }
        this.year = year;
        this.month = month;
        this.day = day;
        this.timezone = timezone;
    }

    public Date(DateTime dateTime) {
        this.year = dateTime.getYear();
        this.month = dateTime.getMonth();
        this.day = dateTime.getDay();
        this.timezone = dateTime.getTimezone();
    }

    @Override
    public Type type() {
        return Type.DATE;
    }

    public Date add(DTD dayTimeDuration) throws QueryException {
        return (Date)this.add(dayTimeDuration.isNegative(), dayTimeDuration, this.timezone);
    }

    public Date add(YMD yearMonthDuration) throws QueryException {
        return (Date)this.add(yearMonthDuration.isNegative(), yearMonthDuration, this.timezone);
    }

    public Date subtract(DTD dayTimeDuration) throws QueryException {
        return (Date)this.add(!dayTimeDuration.isNegative(), dayTimeDuration, this.timezone);
    }

    public Date subtract(YMD yearMonthDuration) throws QueryException {
        return (Date)this.add(!yearMonthDuration.isNegative(), yearMonthDuration, this.timezone);
    }

    public DTD subtract(Date date) throws QueryException {
        return super.subtract(date);
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        if (!(atomic instanceof Date)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.cmp((Date)atomic);
    }

    @Override
    public int atomicCode() {
        return 2;
    }

    @Override
    public String stringValue() {
        String yTmp = this.year < 0 ? "-" : (this.year < 10 ? "000" : (this.year < 100 ? "00" : (this.year < 1000 ? "0" : ""))) + this.year;
        String mTmp = (this.month < 10 ? "0" : "") + this.month;
        String dTmp = (this.day < 10 ? "0" : "") + this.day;
        String tzTmp = this.timezoneString();
        return String.format("%s-%s-%s%s", yTmp, mTmp, dTmp, tzTmp);
    }

    @Override
    public short getYear() {
        return this.year;
    }

    @Override
    public byte getMonth() {
        return this.month;
    }

    @Override
    public byte getDay() {
        return this.day;
    }

    @Override
    public byte getHours() {
        return 0;
    }

    @Override
    public byte getMinutes() {
        return 0;
    }

    @Override
    public int getMicros() {
        return 0;
    }

    @Override
    public DTD getTimezone() {
        return this.timezone;
    }

    @Override
    protected AbstractTimeInstant create(short year, byte month, byte day, byte hours, byte minutes, int micros, DTD timezone) {
        return new Date(year, month, day, timezone);
    }
}

