/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import java.math.BigDecimal;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractNumeric;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.DblNumeric;
import org.brackit.xquery.atomic.FltNumeric;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.xdm.Type;

public class Flt
extends AbstractNumeric
implements FltNumeric {
    public static final Flt NaN = new Flt(Float.NaN);
    public static final Flt NINF = new Flt(Float.NEGATIVE_INFINITY);
    public static final Flt PINF = new Flt(Float.POSITIVE_INFINITY);
    public final float v;

    public Flt(String str) throws QueryException {
        float parsed;
        try {
            str = Whitespace.collapseTrimOnly(str);
            parsed = Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            if (str.equals("INF")) {
                float parsed2 = Float.POSITIVE_INFINITY;
            } else if (str.equals("-INF")) {
                float parsed3 = Float.NEGATIVE_INFINITY;
            } else if (str.equals("NaN")) {
                float parsed3 = Float.NaN;
            }
            throw new QueryException(e, ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:float", str);
        }
        this.v = parsed;
    }

    public static Flt parse(String str) throws QueryException {
        try {
            str = Whitespace.collapseTrimOnly(str);
            float flt = Float.parseFloat(str);
            return new Flt(flt);
        }
        catch (NumberFormatException e) {
            if (str.equals("INF")) {
                return PINF;
            }
            if (str.equals("-INF")) {
                return NINF;
            }
            if (str.equals("NaN")) {
                return NaN;
            }
            throw new QueryException(e, ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:float", str);
        }
    }

    public Flt(Float v) {
        this.v = v.floatValue();
    }

    public Flt(float v) {
        this.v = v;
    }

    @Override
    public Type type() {
        return Type.FLO;
    }

    @Override
    public IntNumeric asIntNumeric() {
        if (Float.isNaN(this.v) || Float.isInfinite(this.v)) {
            return null;
        }
        int i = (int)this.v;
        double f = this.v - (float)i;
        return f == 0.0 ? new Int32(i) : null;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return this.validate(Type.FLO, new DFlt(this.v, type));
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return this.v != 0.0f && !Float.isNaN(this.v) && Float.isInfinite(this.v);
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof Numeric) {
            if (!(other instanceof DblNumeric)) {
                return Float.compare(this.v, ((Numeric)other).floatValue());
            }
            return Double.compare(this.v, ((Numeric)other).doubleValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic other) {
        if (!(other instanceof DblNumeric)) {
            return Float.compare(this.v, ((Numeric)other).floatValue());
        }
        return Double.compare(this.v, ((Numeric)other).doubleValue());
    }

    @Override
    public String stringValue() {
        if (Float.isNaN(this.v)) {
            return "NaN";
        }
        if (Float.isInfinite(this.v)) {
            return this.v > 0.0f ? "INF" : "-INF";
        }
        if (this.v == 0.0f) {
            return 1.0f / this.v == Float.POSITIVE_INFINITY ? "0" : "-0";
        }
        return this.killTrailingZeros(this.v > 0.0f && (double)this.v >= 1.0E-6 && (double)this.v < 1000000.0 || (double)(-this.v) >= 1.0E-6 && (double)(-this.v) < 1000000.0 ? DF.format(this.v) : SF.format(this.v));
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.v);
    }

    @Override
    public BigDecimal integerValue() {
        return new BigDecimal(Math.floor(this.v));
    }

    @Override
    public double doubleValue() {
        return this.v;
    }

    @Override
    public float floatValue() {
        return this.v;
    }

    @Override
    public long longValue() {
        return (long)this.v;
    }

    @Override
    public int intValue() {
        return (int)this.v;
    }

    @Override
    public Numeric add(Numeric other) throws QueryException {
        if (!(other instanceof DblNumeric)) {
            return this.addFloat(this.v, other.floatValue());
        }
        return this.addDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric subtract(Numeric other) throws QueryException {
        if (!(other instanceof DblNumeric)) {
            return this.subtractFloat(this.v, other.floatValue());
        }
        return this.subtractDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric multiply(Numeric other) throws QueryException {
        if (!(other instanceof DblNumeric)) {
            return this.multiplyFloat(this.v, other.floatValue());
        }
        return this.multiplyDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric div(Numeric other) throws QueryException {
        if (!(other instanceof DblNumeric)) {
            return this.divideFloat(this.v, other.floatValue());
        }
        return this.divideDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric idiv(Numeric other) throws QueryException {
        if (!(other instanceof DblNumeric)) {
            return this.idivideFloat(this.v, other.floatValue());
        }
        return this.idivideDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric mod(Numeric other) throws QueryException {
        if (!(other instanceof DblNumeric)) {
            return this.modFloat(this.v, other.floatValue());
        }
        return this.modDouble(this.v, other.doubleValue());
    }

    @Override
    public Numeric negate() throws QueryException {
        return new Flt(-this.v);
    }

    @Override
    public Numeric round() throws QueryException {
        return Float.isInfinite(this.v) || this.v == 0.0f || Float.isNaN(this.v) ? this : new Flt(Math.round(this.v));
    }

    @Override
    public Numeric abs() throws QueryException {
        return this.v == Float.POSITIVE_INFINITY || this.v >= 0.0f || Float.isNaN(this.v) ? this : new Flt(Math.abs(this.v));
    }

    @Override
    public Numeric ceiling() throws QueryException {
        return Float.isInfinite(this.v) || this.v == 0.0f || Float.isNaN(this.v) ? this : new Flt((float)Math.ceil(this.v));
    }

    @Override
    public Numeric floor() throws QueryException {
        return Float.isInfinite(this.v) || this.v == 0.0f || Float.isNaN(this.v) ? this : new Flt((float)Math.floor(this.v));
    }

    @Override
    public Numeric roundHalfToEven(int precision) throws QueryException {
        if (Float.isInfinite(this.v) || this.v == 0.0f || Float.isNaN(this.v)) {
            return this;
        }
        double factor = Math.pow(10.0, precision);
        double scaled = (double)this.v * factor;
        if (Float.isInfinite((float)scaled)) {
            BigDecimal bd = new BigDecimal(this.v);
            bd = bd.scaleByPowerOfTen(precision);
            bd = bd.setScale(0, 6);
            bd = bd.scaleByPowerOfTen(-precision);
            return new Flt(bd.floatValue());
        }
        scaled = Math.rint(scaled);
        return new Flt((float)(scaled / factor));
    }

    private class DFlt
    extends Flt {
        private final Type type;

        public DFlt(float v, Type type) {
            super(v);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

