/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractTimeInstant;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.DTD;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.xdm.Type;

public class GYE
extends AbstractTimeInstant {
    private final short year;
    private final DTD timezone;

    public GYE(short year, DTD timezone) {
        this.year = year;
        this.timezone = timezone;
    }

    public GYE(String str) throws QueryException {
        short year;
        int v;
        DTD timezone = null;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int pos = 0;
        int length = charArray.length;
        boolean negative = false;
        if (pos == length || charArray[pos] == '-') {
            negative = true;
            ++pos;
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        if (end - start < 4) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYear", str);
        }
        if (end - start > 4 && negative) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYear", str);
        }
        int n = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v > Short.MAX_VALUE || v == 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:gYear", str);
        }
        short s = year = negative ? (short)(-v) : (short)v;
        if (pos < length) {
            timezone = this.parseTimezone(str, charArray, pos, length);
        }
        this.year = year;
        this.timezone = timezone;
    }

    @Override
    public int atomicCode() {
        return 9;
    }

    @Override
    protected AbstractTimeInstant create(short year, byte month, byte day, byte hours, byte minutes, int micros, DTD timezone) {
        return new GYE(year, timezone);
    }

    @Override
    public byte getDay() {
        return 0;
    }

    @Override
    public byte getHours() {
        return 0;
    }

    @Override
    public byte getMinutes() {
        return 0;
    }

    @Override
    public byte getMonth() {
        return 0;
    }

    @Override
    public int getMicros() {
        return 0;
    }

    @Override
    public DTD getTimezone() {
        return this.timezone;
    }

    @Override
    public short getYear() {
        return this.year;
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    @Override
    public boolean eq(Atomic atomic) throws QueryException {
        if (!(atomic instanceof GYE)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.cmp((GYE)atomic) == 0;
    }

    @Override
    public String stringValue() {
        String yTmp = this.year < 0 ? "-" : (this.year < 10 ? "000" : (this.year < 100 ? "00" : (this.year < 1000 ? "0" : ""))) + this.year;
        String tzTmp = this.timezoneString();
        return String.format("%s%s", yTmp, tzTmp);
    }

    @Override
    public Type type() {
        return Type.GYE;
    }
}

