/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import java.util.Arrays;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractAtomic;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.xdm.Type;

public class Hex
extends AbstractAtomic {
    private final byte[] bytes;

    public Hex(byte[] bytes) {
        this.bytes = bytes;
    }

    public Hex(String str) throws QueryException {
        str = Whitespace.collapseTrimOnly(str);
        if ((str.length() & 1) != 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:hexBinary", str);
        }
        byte[] bytes = new byte[str.length() >>> 1];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            char c = str.charAt(j++);
            int v = this.hex(str, c);
            c = str.charAt(j++);
            bytes[i] = (byte)(v << 4 | this.hex(str, c));
        }
        this.bytes = bytes;
    }

    private int hex(String str, char c) throws QueryException {
        int v;
        if (c >= '0' && c <= '9') {
            v = c - 48;
        } else if (c >= 'A' && c <= 'F') {
            v = c - 55;
        } else if (c >= 'a' && c <= 'f') {
            v = c - 87;
        } else {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast %s to xs:hexBinary", str);
        }
        return v;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR);
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        byte[] bytes2 = ((Hex)atomic).bytes;
        for (int i = 0; i < Math.min(this.bytes.length, bytes2.length); ++i) {
            if (this.bytes[i] == bytes2[i]) continue;
            return (this.bytes[i] & 0xFF) - (bytes2[i] & 0xFF);
        }
        return this.bytes.length - bytes2.length;
    }

    @Override
    public int atomicCode() {
        return 15;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public boolean eq(Atomic atomic) throws QueryException {
        if (!(atomic instanceof Hex)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return Arrays.equals(this.bytes, ((Hex)atomic).bytes);
    }

    @Override
    public String stringValue() {
        StringBuilder out = new StringBuilder();
        for (byte aByte : this.bytes) {
            int v = aByte & 0xFF;
            int v1 = v >>> 4;
            int v2 = v & 0xF;
            char c1 = (char)(v1 < 10 ? v1 + 48 : v1 + 55);
            char c2 = (char)(v2 < 10 ? v2 + 48 : v2 + 55);
            out.append(c1);
            out.append(c2);
        }
        return out.toString();
    }

    @Override
    public Type type() {
        return Type.HEX;
    }

    @Override
    public boolean booleanValue() throws QueryException {
        throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value of '%s' is undefined.", this.type());
    }
}

