/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractAtomic;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.xdm.Type;

public class QNm
extends AbstractAtomic {
    private final String nsURI;
    private final String prefix;
    private final String localName;

    public QNm(String nsURI, String prefix, String localName) {
        this.nsURI = nsURI == null ? "" : nsURI;
        this.prefix = prefix == null ? "" : prefix;
        this.localName = localName == null ? "" : localName;
    }

    public QNm(String nsURI, String string) {
        int prefixLength = string.indexOf(":");
        if (prefixLength > -1) {
            if (prefixLength == 0 || prefixLength == string.length() - 1 || string.indexOf(":", prefixLength + 1) != -1) {
                throw new IllegalStateException("Illegal QName: " + string);
            }
            this.prefix = string.substring(0, prefixLength);
            string = string.substring(prefixLength + 1);
        } else {
            this.prefix = "";
        }
        this.nsURI = nsURI == null ? "" : nsURI;
        this.localName = string;
    }

    public QNm(String string) {
        this.prefix = "";
        this.nsURI = "";
        this.localName = string == null ? "" : string;
    }

    @Override
    public Type type() {
        return Type.QNM;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DQnm(this.nsURI, this.prefix, this.localName, type);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.nsURI;
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return !this.localName.isEmpty();
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof QNm) {
            QNm qName = (QNm)other;
            int res = this.nsURI.compareTo(qName.nsURI);
            if (res != 0) {
                return res;
            }
            return this.localName.compareTo(qName.localName);
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic other) {
        QNm qName = (QNm)other;
        int res = this.nsURI.compareTo(qName.nsURI);
        if (res != 0) {
            return res;
        }
        return this.localName.compareTo(qName.localName);
    }

    @Override
    public int atomicCode() {
        return 17;
    }

    @Override
    public String stringValue() {
        return this.localName;
    }

    @Override
    public int hashCode() {
        return this.nsURI.hashCode() + this.localName.hashCode();
    }

    @Override
    public String toString() {
        return this.prefix.isEmpty() ? this.localName : this.prefix + ":" + this.localName;
    }

    private static class DQnm
    extends QNm {
        private final Type type;

        public DQnm(String nsURI, String prefix, String localName, Type type) {
            super(nsURI, prefix, localName);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

