/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractAtomic;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Una;
import org.brackit.xquery.xdm.Type;

public class Str
extends AbstractAtomic {
    public static final Str EMPTY = new Str("");
    private final String str;

    public Str(String str) {
        if (str == null) {
            str = "";
        }
        this.str = str;
    }

    @Override
    public Type type() {
        return Type.STR;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DStr(this.str, type);
    }

    @Override
    public Str asStr() {
        return this;
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return !this.str.isEmpty();
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof Str || other instanceof Una) {
            return this.str.compareTo(other.stringValue());
        }
        if (other instanceof AnyURI) {
            return this.str.compareTo(other.stringValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        return this.str.compareTo(atomic.stringValue());
    }

    @Override
    public int atomicCode() {
        return 16;
    }

    @Override
    public String stringValue() {
        return this.str;
    }

    public Str concat(Str s) {
        return new Str(this.str + s.str);
    }

    @Override
    public int hashCode() {
        return this.str.hashCode();
    }

    private class DStr
    extends Str {
        private final Type type;

        public DStr(String str2, Type type) {
            super(str2);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

