/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractTimeInstant;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.DTD;
import org.brackit.xquery.atomic.DateTime;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.xdm.Type;

public class Time
extends AbstractTimeInstant {
    private final byte hour;
    private final byte minute;
    private final int micros;
    private final DTD timezone;

    public Time(byte hour, byte minute, int micros, DTD timezone) {
        this.hour = hour;
        this.minute = minute;
        this.micros = micros;
        this.timezone = timezone;
    }

    public Time(DateTime dateTime) {
        this.hour = dateTime.getHours();
        this.minute = dateTime.getMinutes();
        this.micros = dateTime.getMicros();
        this.timezone = dateTime.getTimezone();
    }

    public Time(String str) throws QueryException {
        int v;
        int pos;
        DTD timezone = null;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int length = charArray.length;
        int start = pos;
        for (pos = 0; pos < length && '0' <= charArray[pos] && charArray[pos] <= '9'; ++pos) {
        }
        int end = pos;
        int n = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 0 || v > 24) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:time: illegal hour", str);
        }
        byte hour = (byte)v;
        if (pos >= length || charArray[pos++] != ':') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:time", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n2 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 0 || v > 59) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:time: illegal minute", str);
        }
        byte minute = (byte)v;
        if (pos >= length || charArray[pos++] != ':') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:time", str);
        }
        start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        end = pos;
        int n3 = v = end - start == 2 ? Integer.parseInt(str.substring(start, end)) : -1;
        if (v < 0 || v > 59) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:time: illegal seconds", str);
        }
        int micros = v * 1000000;
        if (pos < length && charArray[pos] == '.') {
            start = ++pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            int l = end - start;
            int n4 = v = start != end ? Integer.parseInt(str.substring(start, start + Math.min(l, 6))) : -1;
            if (v == -1) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:time: illegal seconds", str);
            }
            if (v > 0) {
                for (int i = 0; i < 6 - l; ++i) {
                    v *= 10;
                }
                micros += v;
            }
        }
        if (hour == 24 && minute != 0) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:dateTime: 24 hours is not allowed when minutes is non-zero", str);
        }
        if (pos < length) {
            timezone = this.parseTimezone(str, charArray, pos, length);
        }
        this.hour = hour;
        this.minute = minute;
        this.micros = micros;
        this.timezone = timezone;
    }

    @Override
    public int atomicCode() {
        return 3;
    }

    @Override
    public Type type() {
        return Type.TIME;
    }

    public Time add(DTD dayTimeDuration) throws QueryException {
        return (Time)this.add(dayTimeDuration.isNegative(), dayTimeDuration, this.timezone);
    }

    public Time subtract(DTD dayTimeDuration) throws QueryException {
        return (Time)this.add(!dayTimeDuration.isNegative(), dayTimeDuration, this.timezone);
    }

    public DTD subtract(Time time) throws QueryException {
        return super.subtract(time);
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        if (!(atomic instanceof Time)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.cmp((Time)atomic);
    }

    @Override
    public String stringValue() {
        String hTmp = (this.hour < 10 ? "0" : "") + this.hour;
        String minTmp = (this.minute < 10 ? "0" : "") + this.minute;
        String tzTmp = this.timezoneString();
        int seconds = this.micros / 1000000;
        int remainder = this.micros - seconds * 1000000;
        String sTmp = (seconds < 10 ? "0" : "") + seconds;
        if (remainder != 0) {
            while (remainder / 10 == 0) {
                remainder /= 10;
            }
            sTmp = sTmp + ":" + remainder;
        }
        return String.format("%s:%s:%s%s", hTmp, minTmp, sTmp, tzTmp);
    }

    @Override
    public short getYear() {
        return 0;
    }

    @Override
    public byte getMonth() {
        return 0;
    }

    @Override
    public byte getDay() {
        return 0;
    }

    @Override
    public byte getHours() {
        return this.hour;
    }

    @Override
    public byte getMinutes() {
        return this.minute;
    }

    @Override
    public int getMicros() {
        return this.micros;
    }

    @Override
    public DTD getTimezone() {
        return this.timezone;
    }

    @Override
    protected AbstractTimeInstant create(short year, byte month, byte day, byte hours, byte minutes, int micros, DTD timezone) {
        return new Time(hours, minutes, micros, timezone);
    }
}

