/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractAtomic;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.xdm.Type;

public class Una
extends AbstractAtomic {
    public static final Una EMPTY = new Una("");
    public final String str;

    public Una(String str) {
        if (str == null) {
            str = "";
        }
        this.str = str;
    }

    @Override
    public Type type() {
        return Type.UNA;
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return new DUna(this.str, type);
    }

    @Override
    public Una asUna() {
        return this;
    }

    @Override
    public boolean booleanValue() throws QueryException {
        return !this.str.isEmpty();
    }

    @Override
    public int cmp(Atomic other) throws QueryException {
        if (other instanceof Str || other instanceof Una) {
            return this.str.compareTo(other.stringValue());
        }
        throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s' with '%s'", this.type(), other.type());
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        return this.str.compareTo(atomic.stringValue());
    }

    @Override
    public int atomicCode() {
        return 16;
    }

    @Override
    public String stringValue() {
        return this.str;
    }

    @Override
    public int hashCode() {
        return this.str.hashCode();
    }

    private static class DUna
    extends Una {
        private final Type type;

        public DUna(String str, Type type) {
            super(str);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

