/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.atomic;

import java.math.BigDecimal;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AbstractDuration;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Dbl;
import org.brackit.xquery.atomic.Dec;
import org.brackit.xquery.atomic.Dur;
import org.brackit.xquery.atomic.Numeric;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.xdm.Type;

public class YMD
extends AbstractDuration {
    private final short years;
    private final byte months;

    public YMD(boolean negative, short years, byte months) {
        this.years = years;
        this.months = !negative ? months : (byte)(months | 0x80);
    }

    public YMD(String str) throws QueryException {
        int v;
        int pos;
        boolean negative = false;
        short years = 0;
        byte months = 0;
        str = Whitespace.collapseTrimOnly(str);
        char[] charArray = str.toCharArray();
        int length = charArray.length;
        for (pos = 0; pos < length && str.charAt(pos) == ' '; ++pos) {
        }
        if (pos == length || charArray[pos] == '-') {
            negative = true;
            ++pos;
        }
        if (length - pos < 3 || charArray[pos++] != 'P') {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration", str);
        }
        int start = pos;
        while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
            ++pos;
        }
        int end = pos;
        int sectionTerminator = pos < length ? charArray[pos++] : -1;
        int n = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        if (sectionTerminator == 89) {
            if (v > Short.MAX_VALUE) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
            }
            years = (short)v;
            start = pos;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            end = pos;
            sectionTerminator = pos < length ? charArray[pos++] : -1;
            int n2 = v = start != end ? Integer.parseInt(str.substring(start, end)) : -1;
        }
        if (sectionTerminator == 77 && v > -1) {
            int newYears = years + v / 12;
            v %= 12;
            if (newYears > Short.MAX_VALUE) {
                throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration: component too large", str);
            }
            months = (byte)(months | v);
            years = (short)newYears;
            while (pos < length && '0' <= charArray[pos] && charArray[pos] <= '9') {
                ++pos;
            }
            int n3 = sectionTerminator = pos < length ? charArray[pos] : -1;
        }
        if (sectionTerminator != -1) {
            throw new QueryException(ErrorCode.ERR_INVALID_VALUE_FOR_CAST, "Cannot cast '%s' to xs:duration", str);
        }
        this.years = years;
        this.months = !negative ? months : (byte)(months | 0x80);
    }

    @Override
    public Atomic asType(Type type) throws QueryException {
        return type.instanceOf(Type.YMD) ? new DYMDur(this.months < 0, this.years, (byte)(this.months & 0x7F), type) : new Dur(this.months < 0, this.years, (byte)(this.months & 0x7F), 0, 0, 0, 0).asType(type);
    }

    @Override
    protected boolean zeroMonthsWhenZero() {
        return true;
    }

    @Override
    public int cmp(Atomic atomic) throws QueryException {
        if (!(atomic instanceof YMD)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Cannot compare '%s with '%s'", this.type(), atomic.type());
        }
        return this.atomicCmpInternal(atomic);
    }

    @Override
    public int atomicCmpInternal(Atomic atomic) {
        YMD other = (YMD)atomic;
        int sign = this.months & 0x80;
        int oSign = other.months & 0x80;
        if (sign != oSign) {
            return sign < oSign ? -1 : 1;
        }
        int res = this.years - other.years;
        if (res != 0) {
            return res;
        }
        res = (this.months & 0x7F) - (other.months & 0x7F);
        return res;
    }

    @Override
    public int atomicCode() {
        return 5;
    }

    public YMD add(YMD other) throws QueryException {
        return this.addInternal(other.isNegative(), other.getYears(), other.getMonths());
    }

    public YMD subtract(YMD other) throws QueryException {
        return this.addInternal(!other.isNegative(), other.getYears(), other.getMonths());
    }

    public YMD multiply(Dbl dbl) throws QueryException {
        double v = dbl.doubleValue();
        if (Double.isNaN(v)) {
            throw new QueryException(ErrorCode.ERR_PARAMETER_NAN);
        }
        if (Double.isInfinite(v)) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        long newYears = Math.round((double)this.getYears() * v);
        long newMonths = Math.round((double)this.getMonths() * v);
        boolean newNegative = this.isNegative() ^ v < 0.0;
        if (this.isNegative() ^ newNegative) {
            newYears *= -1L;
            newMonths *= -1L;
        }
        newYears += newMonths / 12L;
        newMonths %= 12L;
        if (newYears > 32767L) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        return new YMD(newNegative, (short)newYears, (byte)newMonths);
    }

    public YMD divide(Dbl dbl) throws QueryException {
        double v = dbl.doubleValue();
        if (Double.isNaN(v)) {
            throw new QueryException(ErrorCode.ERR_PARAMETER_NAN);
        }
        if (Double.isInfinite(v)) {
            return new YMD(false, 0, 0);
        }
        long newYears = Math.round((double)this.getYears() / v);
        long newMonths = Math.round((double)this.getMonths() / v);
        boolean newNegative = this.isNegative() ^ v < 0.0;
        if (this.isNegative() ^ newNegative) {
            newYears *= -1L;
            newMonths *= -1L;
        }
        newYears += newMonths / 12L;
        newMonths %= 12L;
        if (newYears > 32767L) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        return new YMD(newNegative, (short)newYears, (byte)newMonths);
    }

    public Numeric divide(YMD dur) throws QueryException {
        int a = this.getYears() * 12 + this.getMonths();
        int b = dur.getYears() * 12 + dur.getMonths();
        if (b == 0) {
            throw new QueryException(ErrorCode.ERR_DIVISION_BY_ZERO);
        }
        return new Dec(new BigDecimal(a)).div(new Dec(new BigDecimal(b)));
    }

    private YMD addInternal(boolean n2, short y2, byte m2) throws QueryException {
        boolean newNegative;
        boolean n1 = this.isNegative();
        byte m1 = this.getMonths();
        short y1 = this.getYears();
        if (n1) {
            m1 = (byte)(m1 * -1);
            y1 = (short)(y1 * -1);
        }
        if (n2) {
            m2 = (byte)(m2 * -1);
            y2 = (short)(y2 * -1);
        }
        int newMonths = m1 + m2;
        int newYears = y1 + y2;
        boolean bl = newNegative = newYears < 0;
        if (newNegative) {
            newYears *= -1;
            newMonths *= -1;
        }
        newYears += newMonths / 12;
        newMonths %= 12;
        if (newYears > Short.MAX_VALUE) {
            throw new QueryException(ErrorCode.ERR_OVERFLOW_UNDERFLOW_IN_DURATION);
        }
        return new YMD(newNegative, (short)newYears, (byte)newMonths);
    }

    @Override
    public Type type() {
        return Type.YMD;
    }

    @Override
    public boolean isNegative() {
        return this.months < 0;
    }

    @Override
    public byte getMonths() {
        return (byte)(this.months & 0x7F);
    }

    @Override
    public short getYears() {
        return this.years;
    }

    @Override
    public short getDays() {
        return 0;
    }

    @Override
    public byte getHours() {
        return 0;
    }

    @Override
    public byte getMinutes() {
        return 0;
    }

    @Override
    public int getMicros() {
        return 0;
    }

    private static class DYMDur
    extends YMD {
        private final Type type;

        public DYMDur(boolean negative, short year, byte month, Type type) {
            super(negative, year, month);
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }
}

