/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.brackit.xquery.compiler.ModuleResolver;
import org.brackit.xquery.module.Module;
import org.brackit.xquery.util.io.URIHandler;

public class BaseResolver
implements ModuleResolver {
    protected Map<String, List<Module>> modules;

    @Override
    public void register(String targetNSUri, Module module) {
        if (this.modules == null) {
            this.modules = new HashMap<String, List<Module>>();
        }
        List list = this.modules.computeIfAbsent(targetNSUri, k -> new ArrayList(1));
        list.add(module);
    }

    @Override
    public void unregister(String targetNSUri) {
        if (this.modules != null) {
            this.modules.remove(targetNSUri);
        }
    }

    @Override
    public List<Module> resolve(String uri, String ... locUris) {
        List<Module> list = this.modules == null ? null : this.modules.get(uri);
        return list == null ? Collections.emptyList() : list;
    }

    @Override
    public List<String> load(String uri, String[] locations) throws IOException {
        LinkedList<String> loaded = new LinkedList<String>();
        for (String loc : locations) {
            String s = this.load(loc);
            if (s == null) continue;
            loaded.add(s);
        }
        return loaded;
    }

    protected String load(String loc) throws IOException {
        String s = null;
        try {
            InputStreamReader in = new InputStreamReader(URIHandler.getInputStream(new URI(loc)));
            CharBuffer buf = CharBuffer.allocate(533504);
            in.read(buf);
            in.close();
            s = buf.rewind().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return s;
    }
}

