/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler;

import java.util.Map;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.BaseResolver;
import org.brackit.xquery.compiler.ModuleResolver;
import org.brackit.xquery.compiler.Target;
import org.brackit.xquery.compiler.analyzer.Analyzer;
import org.brackit.xquery.compiler.optimizer.Optimizer;
import org.brackit.xquery.compiler.optimizer.TopDownOptimizer;
import org.brackit.xquery.compiler.parser.XQParser;
import org.brackit.xquery.compiler.translator.TopDownTranslator;
import org.brackit.xquery.compiler.translator.Translator;
import org.brackit.xquery.function.bit.ArrayValues;
import org.brackit.xquery.function.bit.BitFun;
import org.brackit.xquery.function.bit.Create;
import org.brackit.xquery.function.bit.Drop;
import org.brackit.xquery.function.bit.Eval;
import org.brackit.xquery.function.bit.Exists;
import org.brackit.xquery.function.bit.Fields;
import org.brackit.xquery.function.bit.Len;
import org.brackit.xquery.function.bit.Load;
import org.brackit.xquery.function.bit.Mkdir;
import org.brackit.xquery.function.bit.Now;
import org.brackit.xquery.function.bit.Parse;
import org.brackit.xquery.function.bit.Serialize;
import org.brackit.xquery.function.bit.Silent;
import org.brackit.xquery.function.bit.Store;
import org.brackit.xquery.function.bit.Values;
import org.brackit.xquery.function.io.Ls;
import org.brackit.xquery.function.io.Read;
import org.brackit.xquery.function.io.Readline;
import org.brackit.xquery.function.io.Write;
import org.brackit.xquery.function.io.Writeline;
import org.brackit.xquery.function.json.JSONParse;
import org.brackit.xquery.module.Functions;
import org.brackit.xquery.module.Module;
import org.brackit.xquery.util.dot.DotUtil;

public class CompileChain {
    final AnyURI baseURI;
    final ModuleResolver resolver;

    public CompileChain() {
        this(new BaseResolver(), null);
    }

    public CompileChain(AnyURI baseURI) {
        this(new BaseResolver(), baseURI);
    }

    public CompileChain(ModuleResolver resolver) {
        this(resolver, null);
    }

    public CompileChain(ModuleResolver resolver, AnyURI baseURI) {
        this.resolver = resolver;
        this.baseURI = baseURI;
    }

    protected Optimizer getOptimizer(Map<QNm, Str> options) {
        return new TopDownOptimizer(options);
    }

    protected Translator getTranslator(Map<QNm, Str> options) {
        return new TopDownTranslator(options);
    }

    protected ModuleResolver getModuleResolver() {
        return this.resolver;
    }

    protected AST parse(String query) throws QueryException {
        return new XQParser(query).parse();
    }

    public Module compile(String query) throws QueryException {
        if (XQuery.DEBUG) {
            System.out.println(String.format("Compiling:\n%s", query));
        }
        ModuleResolver resolver = this.getModuleResolver();
        AST parsed = this.parse(query);
        if (XQuery.DEBUG) {
            DotUtil.drawDotToFile(parsed.dot(), XQuery.DEBUG_DIR, "parsed");
        }
        Analyzer analyzer = new Analyzer(resolver, this.baseURI, parsed);
        AST xquery = analyzer.getAST();
        Module module = analyzer.getModules().get(0);
        Map<QNm, Str> options = module.getOptions();
        for (Target t : analyzer.getTargets()) {
            t.optimize(this.getOptimizer(options));
        }
        if (XQuery.DEBUG) {
            DotUtil.drawDotToFile(xquery.dot(), XQuery.DEBUG_DIR, "xquery");
        }
        for (Target t : analyzer.getTargets()) {
            t.translate(this.getTranslator(options));
        }
        for (Module m : analyzer.getModules()) {
            if (m.getTargetNS() == null) continue;
            resolver.register(m.getTargetNS(), m);
        }
        return module;
    }

    static {
        Functions.predefine(new Readline());
        Functions.predefine(new Writeline());
        Functions.predefine(new Read());
        Functions.predefine(new Write());
        Functions.predefine(new Ls(true));
        Functions.predefine(new Ls(false));
        Functions.predefine(BitFun.SOME_FUNC);
        Functions.predefine(BitFun.EVERY_FUNC);
        Functions.predefine(new Now());
        Functions.predefine(new Silent());
        Functions.predefine(new Parse());
        Functions.predefine(new Eval());
        Functions.predefine(new Serialize());
        Functions.predefine(new Len());
        Functions.predefine(new Fields());
        Functions.predefine(new Values());
        Functions.predefine(new Store(true));
        Functions.predefine(new Store(false));
        Functions.predefine(new Load(true));
        Functions.predefine(new Load(false));
        Functions.predefine(new Create());
        Functions.predefine(new Drop());
        Functions.predefine(new Mkdir());
        Functions.predefine(new Exists());
        Functions.predefine(new ArrayValues());
        Functions.predefine(new JSONParse());
    }
}

