/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler;

import org.brackit.xquery.QueryException;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.Unit;
import org.brackit.xquery.compiler.optimizer.Optimizer;
import org.brackit.xquery.compiler.translator.Translator;
import org.brackit.xquery.module.Module;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Expr;

public class Target {
    protected final Module module;
    protected final StaticContext sctx;
    protected final Unit unit;
    protected final boolean allowUpdate;
    protected AST ast;

    public Target(Module module, StaticContext sctx, AST ast, Unit unit, boolean allowUpdate) {
        this.module = module;
        this.sctx = sctx;
        this.ast = ast;
        this.unit = unit;
        this.allowUpdate = allowUpdate;
    }

    public void optimize(Optimizer optimizer) throws QueryException {
        this.ast = optimizer.optimize(this.sctx, this.ast);
    }

    public void translate(Translator translator) throws QueryException {
        Expr expr = translator.expression(this.module, this.sctx, this.ast, this.allowUpdate);
        this.unit.setExpr(expr);
    }

    public Module getModule() {
        return this.module;
    }

    public StaticContext getStaticContext() {
        return this.sctx;
    }

    public AST getAst() {
        return this.ast;
    }

    public boolean allowUpdate() {
        return this.allowUpdate;
    }
}

