/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.analyzer;

import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.module.Namespaces;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.util.log.Logger;
import org.brackit.xquery.xdm.Signature;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.XMLChar;
import org.brackit.xquery.xdm.type.AnyItemType;
import org.brackit.xquery.xdm.type.AnyJsonItemType;
import org.brackit.xquery.xdm.type.AnyNodeType;
import org.brackit.xquery.xdm.type.AnyStructuredItemType;
import org.brackit.xquery.xdm.type.ArrayType;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.AttributeType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.CommentType;
import org.brackit.xquery.xdm.type.DocumentType;
import org.brackit.xquery.xdm.type.ElementType;
import org.brackit.xquery.xdm.type.FunctionType;
import org.brackit.xquery.xdm.type.ItemType;
import org.brackit.xquery.xdm.type.PIType;
import org.brackit.xquery.xdm.type.RecordType;
import org.brackit.xquery.xdm.type.SequenceType;
import org.brackit.xquery.xdm.type.TextType;

public abstract class AbstractAnalyzer {
    protected static final Logger log = Logger.getLogger(AbstractAnalyzer.class);
    protected StaticContext sctx;

    SequenceType sequenceType(AST stype) throws QueryException {
        AST type = stype.getChild(0);
        if (type.getType() == 70) {
            return SequenceType.EMPTY_SEQUENCE;
        }
        ItemType itype = this.itemType(type);
        Cardinality card = Cardinality.ZeroOrMany;
        if (stype.getChildCount() == 2) {
            card = this.occurrenceIndicator(stype.getChild(1));
        }
        return new SequenceType(itype, card);
    }

    protected ItemType anyKind(AST kind) throws QueryException {
        if (kind.getType() != 71) {
            return null;
        }
        return AnyItemType.ANY;
    }

    protected Cardinality occurrenceIndicator(AST card) {
        if (card.getType() == 74) {
            return Cardinality.ZeroOrOne;
        }
        if (card.getType() == 75) {
            return Cardinality.ZeroOrMany;
        }
        return Cardinality.OneOrMany;
    }

    ItemType itemType(AST itype) throws QueryException {
        ItemType type = this.kindTest(itype);
        type = type != null ? type : this.anyKind(itype);
        type = type != null ? type : this.functionTest(itype);
        type = type != null ? type : this.atomicOrUnionType(itype);
        type = type != null ? type : this.parenthesizedItemType(itype);
        return type;
    }

    protected ItemType functionTest(AST type) throws QueryException {
        if (type.getType() != 125) {
            return null;
        }
        int pos = 0;
        AST annotationOrTest = type.getChild(pos);
        while (annotationOrTest.getType() == 124) {
            QNm name = (QNm)annotationOrTest.getChild(0).getValue();
            name = this.expand(name, DefaultNS.FUNCTION);
            annotationOrTest.getChild(0).setValue(name);
            String uri = name.getNamespaceURI();
            if (!uri.equals("http://www.w3.org/XML/1998/namespace") && !uri.equals("http://www.w3.org/2001/XMLSchema") && !uri.equals("http://www.w3.org/2001/XMLSchema-instance") && !uri.equals("http://www.w3.org/2005/xpath-functions") && !uri.equals("http://www.w3.org/2005/xpath-functions/math")) continue;
            throw new QueryException(ErrorCode.ERR_FUNCTION_DECL_IN_ILLEGAL_NAMESPACE, "Function declaration %s is in illegal namespace: %s", name, uri);
        }
        if (annotationOrTest.getType() == 126) {
            SequenceType any = new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany);
            return new FunctionType(new Signature(any, true, null, any));
        }
        if (annotationOrTest.getType() == 127) {
            return this.typedFunctionTest(annotationOrTest);
        }
        return null;
    }

    protected ItemType typedFunctionTest(AST test) throws QueryException {
        SequenceType[] params = new SequenceType[test.getChildCount() - 1];
        for (int i = 0; i < test.getChildCount() - 1; ++i) {
            params[i] = this.sequenceType(test.getChild(i));
        }
        SequenceType resType = this.sequenceType(test.getChild(test.getChildCount() - 1));
        return new FunctionType(new Signature(resType, params));
    }

    protected ItemType atomicOrUnionType(AST type) throws QueryException {
        QNm name = (QNm)type.getChild(0).getValue();
        name = this.expand(name, DefaultNS.ELEMENT_OR_TYPE);
        type.getChild(0).setValue(name);
        Type t = this.sctx.getTypes().resolveType(name);
        return new AtomicType(t);
    }

    protected ItemType parenthesizedItemType(AST type) throws QueryException {
        return this.itemType(type);
    }

    protected SequenceType singleType(AST type) throws QueryException {
        ItemType aouType = this.atomicOrUnionType(type.getChild(0));
        Cardinality card = Cardinality.One;
        if (type.getChildCount() >= 2 && type.getChild(1).getType() == 74) {
            card = Cardinality.ZeroOrOne;
        }
        return new SequenceType(aouType, card);
    }

    protected ItemType kindTest(AST kindTest) throws QueryException {
        DocumentType test = this.documentTest(kindTest);
        test = test != null ? test : this.elementTest(kindTest);
        test = test != null ? test : this.attributeTest(kindTest);
        test = test != null ? test : this.schemaElementTest(kindTest);
        test = test != null ? test : this.schemaAttributeTest(kindTest);
        test = test != null ? test : this.piTest(kindTest);
        test = test != null ? test : this.commentTest(kindTest);
        test = test != null ? test : this.textTest(kindTest);
        test = test != null ? test : this.namespaceNodeTest(kindTest);
        test = test != null ? test : this.structuredItemTest(kindTest);
        test = test != null ? test : this.jsonItemTest(kindTest);
        test = test != null ? test : this.recordTest(kindTest);
        test = test != null ? test : this.arrayTest(kindTest);
        test = test != null ? test : this.anyKindTest(kindTest);
        return test;
    }

    protected DocumentType documentTest(AST kindTest) throws QueryException {
        if (kindTest.getType() != 98) {
            return null;
        }
        if (kindTest.getChildCount() == 0) {
            return new DocumentType();
        }
        AST child = kindTest.getChild(0);
        ElementType test = this.elementTest(child);
        test = test != null ? test : this.schemaElementTest(child);
        return new DocumentType(test);
    }

    protected ElementType elementTest(AST test) throws QueryException {
        if (test.getType() != 102) {
            return null;
        }
        Type type = null;
        QNm name = null;
        if (test.getChildCount() >= 1) {
            AST child = test.getChild(0);
            if (child.getType() != 100 && child.getType() == 119) {
                name = (QNm)child.getValue();
                name = this.expand(name, DefaultNS.ELEMENT_OR_TYPE);
                child.setValue(name);
            }
            if (test.getChildCount() >= 2) {
                child = test.getChild(1);
                QNm typeName = (QNm)child.getValue();
                typeName = this.expand(typeName, DefaultNS.ELEMENT_OR_TYPE);
                child.setValue(typeName);
                type = this.sctx.getTypes().resolveType(typeName);
                if (test.getChildCount() >= 3) {
                    child = test.getChild(2);
                }
            }
        }
        return new ElementType(name, type);
    }

    protected AttributeType attributeTest(AST test) throws QueryException {
        if (test.getType() != 103) {
            return null;
        }
        Type type = null;
        QNm name = null;
        if (test.getChildCount() >= 1) {
            AST child = test.getChild(0);
            if (child.getType() != 100 && child.getType() == 119) {
                name = (QNm)child.getValue();
                name = this.expand(name, DefaultNS.EMPTY);
                child.setValue(name);
            }
            if (test.getChildCount() >= 2) {
                child = test.getChild(1);
                QNm typeName = (QNm)child.getValue();
                typeName = this.expand(typeName, DefaultNS.ELEMENT_OR_TYPE);
                child.setValue(typeName);
                type = this.sctx.getTypes().resolveType(typeName);
            }
        }
        return new AttributeType(name, type);
    }

    protected ElementType schemaElementTest(AST test) throws QueryException {
        if (test.getType() != 104) {
            return null;
        }
        AST child = test.getChild(0);
        QNm name = (QNm)child.getValue();
        name = this.expand(name, DefaultNS.ELEMENT_OR_TYPE);
        child.setValue(name);
        Type type = this.sctx.getTypes().resolveType(name);
        return new ElementType(name, type);
    }

    protected AttributeType schemaAttributeTest(AST test) throws QueryException {
        if (test.getType() != 105) {
            return null;
        }
        AST child = test.getChild(0);
        QNm name = (QNm)child.getValue();
        name = this.expand(name, DefaultNS.ELEMENT_OR_TYPE);
        child.setValue(name);
        Type type = this.sctx.getTypes().resolveType(name);
        return new AttributeType(name, type);
    }

    protected ItemType piTest(AST test) throws QueryException {
        if (test.getType() != 106) {
            return null;
        }
        String target = null;
        if (test.getChildCount() == 1) {
            target = test.getChild(0).getStringValue();
            target = Whitespace.normalizeXML11(target);
            if (!XMLChar.isNCName(target = Whitespace.collapse(target))) {
                throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "PI target name is not a valid NCName: %s", target);
            }
            test.getChild(0).setValue(target);
        }
        return new PIType(target);
    }

    protected ItemType commentTest(AST test) throws QueryException {
        if (test.getType() != 107) {
            return null;
        }
        return new CommentType();
    }

    protected ItemType textTest(AST test) throws QueryException {
        if (test.getType() != 108) {
            return null;
        }
        return new TextType();
    }

    protected ItemType namespaceNodeTest(AST test) throws QueryException {
        if (test.getType() != 109) {
            return null;
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Namespace test not implemented yet");
    }

    protected ItemType structuredItemTest(AST test) throws QueryException {
        if (test.getType() != 263) {
            return null;
        }
        return new AnyStructuredItemType();
    }

    protected ItemType jsonItemTest(AST test) throws QueryException {
        if (test.getType() != 262) {
            return null;
        }
        return new AnyJsonItemType();
    }

    protected ItemType recordTest(AST test) throws QueryException {
        if (test.getType() != 247) {
            return null;
        }
        return new RecordType();
    }

    protected ItemType arrayTest(AST test) throws QueryException {
        if (test.getType() != 242) {
            return null;
        }
        return new ArrayType();
    }

    protected ItemType anyKindTest(AST test) throws QueryException {
        if (test.getType() != 97) {
            return null;
        }
        return AnyNodeType.ANY_NODE;
    }

    protected QNm expand(QNm name, DefaultNS mode) throws QueryException {
        if (!name.getNamespaceURI().isEmpty()) {
            return name;
        }
        String prefix = name.getPrefix();
        Namespaces ns = this.sctx.getNamespaces();
        if (mode == DefaultNS.ELEMENT_OR_TYPE) {
            if (prefix.isEmpty()) {
                return new QNm(ns.getDefaultElementNamespace(), "", name.getLocalName());
            }
            String uri = ns.resolve(prefix);
            if (uri != null) {
                return new QNm(uri, prefix, name.getLocalName());
            }
        } else if (mode == DefaultNS.FUNCTION) {
            if (prefix.isEmpty()) {
                return new QNm(ns.getDefaultFunctionNamespace(), "", name.getLocalName());
            }
            String uri = ns.resolve(prefix);
            if (uri != null) {
                return new QNm(uri, prefix, name.getLocalName());
            }
        } else if (mode == DefaultNS.PRAGMA) {
            if (prefix.isEmpty() && !name.getNamespaceURI().isEmpty()) {
                return name;
            }
            String uri = ns.resolve(prefix);
            if (uri != null) {
                return new QNm(uri, prefix, name.getLocalName());
            }
        } else {
            if (prefix.isEmpty()) {
                return name;
            }
            String uri = ns.resolve(prefix);
            if (uri != null) {
                return new QNm(uri, prefix, name.getLocalName());
            }
        }
        throw new QueryException(ErrorCode.ERR_UNDEFINED_NAMESPACE_PREFIX, "Undefined namespace prefix: '%s'", prefix);
    }

    protected String resolvePrefix(String prefix) throws QueryException {
        String nsURI = this.sctx.getNamespaces().resolve(prefix);
        if (nsURI == null) {
            throw new QueryException(ErrorCode.ERR_UNDEFINED_NAMESPACE_PREFIX, "Undefined namespace prefix: '%s'", prefix);
        }
        return nsURI;
    }

    protected static enum DefaultNS {
        EMPTY,
        FUNCTION,
        ELEMENT_OR_TYPE,
        PRAGMA;

    }
}

