/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.analyzer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.brackit.xquery.atomic.QNm;

class Dependencies<E> {
    Map<E, List<E>> map = new HashMap<E, List<E>>();
    List<List<E>> cycles;

    Dependencies() {
    }

    List<List<E>> findCycles() {
        ArrayDeque path = new ArrayDeque();
        for (E u : this.map.keySet()) {
            this.chase(path, u);
        }
        return this.cycles;
    }

    private boolean chase(ArrayDeque<E> path, E u) {
        if (path.contains(u)) {
            this.extract(path, u);
            return true;
        }
        path.push(u);
        List<E> deps = this.map.get(u);
        if (deps != null) {
            ArrayList<E> copy = new ArrayList<E>(deps);
            for (Object dep : copy) {
                if (!this.chase(path, dep)) continue;
                deps.remove(dep);
            }
        }
        path.pop();
        return false;
    }

    private void extract(ArrayDeque<E> path, E u) {
        ArrayList<E> cycle = new ArrayList<E>();
        for (E t : path) {
            cycle.add(t);
            if (!t.equals(u)) continue;
            break;
        }
        if (this.cycles == null) {
            this.cycles = new ArrayList<List<E>>();
        }
        this.cycles.add(cycle);
    }

    void dependsOn(E unit, E dependency) {
        List<E> deps = this.map.get(unit);
        if (deps == null) {
            deps = new LinkedList();
            deps.add(dependency);
            this.map.put(unit, deps);
        } else {
            for (E dep : deps) {
                if (dep != dependency) continue;
                return;
            }
            deps.add(dependency);
        }
    }

    public static void main(String[] args) {
        QNm a = new QNm("a");
        QNm b = new QNm("b");
        QNm c = new QNm("c");
        QNm d = new QNm("d");
        QNm e = new QNm("e");
        Dependencies<QNm> deps = new Dependencies<QNm>();
        deps.dependsOn(a, b);
        deps.dependsOn(a, d);
        deps.dependsOn(b, c);
        deps.dependsOn(c, d);
        deps.dependsOn(d, b);
        deps.dependsOn(d, a);
        deps.dependsOn(e, d);
        deps.dependsOn(d, e);
        System.out.println(deps.findCycles());
    }
}

