/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.analyzer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.Target;
import org.brackit.xquery.compiler.Unit;
import org.brackit.xquery.compiler.analyzer.AbstractAnalyzer;
import org.brackit.xquery.compiler.analyzer.ExprAnalyzer;
import org.brackit.xquery.expr.DeclVariable;
import org.brackit.xquery.function.UDF;
import org.brackit.xquery.module.Module;
import org.brackit.xquery.xdm.Function;

abstract class ForwardDeclaration
extends ExprAnalyzer {
    protected final Unit unit;
    protected Set<Unit> deps;
    protected int ctxItemLevel;

    public ForwardDeclaration(Module module, Unit unit) {
        super(module);
        this.unit = unit;
    }

    abstract Target process() throws QueryException;

    Unit getUnit() {
        return this.unit;
    }

    Set<Unit> dependsOn() {
        return this.deps != null ? this.deps : Collections.EMPTY_SET;
    }

    @Override
    protected boolean varRef(AST expr) throws QueryException {
        if (expr.getType() != 26) {
            return false;
        }
        QNm name = (QNm)expr.getValue();
        if (!super.varRef(expr)) {
            return false;
        }
        if (!this.variables.check(name = this.expand(name, AbstractAnalyzer.DefaultNS.EMPTY))) {
            DeclVariable dependency = (DeclVariable)this.module.getVariables().resolve(name);
            if (this.deps == null) {
                this.deps = new HashSet<Unit>();
            }
            this.deps.add(dependency);
        }
        return true;
    }

    @Override
    protected boolean functionCall(AST expr) throws QueryException {
        if (!super.functionCall(expr)) {
            return false;
        }
        if (expr.getType() != 80) {
            return true;
        }
        QNm name = (QNm)expr.getValue();
        Function fun = this.sctx.getFunctions().resolve(name, expr.getChildCount());
        if (fun instanceof UDF) {
            if (this.deps == null) {
                this.deps = new HashSet<Unit>();
            }
            this.deps.add((UDF)fun);
        }
        return true;
    }

    @Override
    protected void openContextItemScope() throws QueryException {
        ++this.ctxItemLevel;
    }

    @Override
    protected void closeContextItemScope() throws QueryException {
        --this.ctxItemLevel;
    }

    @Override
    protected void referContextItem() throws QueryException {
        if (this.ctxItemLevel == 0) {
            if (this.deps == null) {
                this.deps = new HashSet<Unit>();
            }
            this.deps.add(this.module.getVariables().getDftCtxItem());
        }
    }
}

