/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.optimizer;

import java.util.ArrayList;
import java.util.Map;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.optimizer.DefaultOptimizer;
import org.brackit.xquery.compiler.optimizer.Stage;
import org.brackit.xquery.compiler.optimizer.walker.topdown.GroupByAggregates;
import org.brackit.xquery.compiler.optimizer.walker.topdown.JoinGroupDemarcation;
import org.brackit.xquery.compiler.optimizer.walker.topdown.JoinRewriter;
import org.brackit.xquery.compiler.optimizer.walker.topdown.JoinToSelectConversion;
import org.brackit.xquery.compiler.optimizer.walker.topdown.LeftJoinLifting;
import org.brackit.xquery.compiler.optimizer.walker.topdown.LeftJoinRemoval;
import org.brackit.xquery.compiler.optimizer.walker.topdown.LeftJoinUnnesting;
import org.brackit.xquery.compiler.optimizer.walker.topdown.LetBindToLeftJoin;
import org.brackit.xquery.compiler.optimizer.walker.topdown.PredicateMerge;
import org.brackit.xquery.compiler.optimizer.walker.topdown.PredicateSplit;
import org.brackit.xquery.compiler.optimizer.walker.topdown.PullEvaluation;
import org.brackit.xquery.compiler.optimizer.walker.topdown.SelectPullup;
import org.brackit.xquery.compiler.optimizer.walker.topdown.TopDownPipeline;
import org.brackit.xquery.compiler.optimizer.walker.topdown.TrivialLeftJoinRemoval;
import org.brackit.xquery.module.StaticContext;

public class TopDownOptimizer
extends DefaultOptimizer {
    public TopDownOptimizer(Map<QNm, Str> options) {
        super(options, new ArrayList<Stage>());
        this.stages.add(new DefaultOptimizer.Simplification(this));
        this.stages.add(new Pipelining());
        this.stages.add(new Reordering());
        if (JOIN_DETECTION) {
            this.stages.add(new JoinRecognition());
        }
        if (UNNEST) {
            this.stages.add(new Unnest());
        }
        this.stages.add(new FinalizePipeline());
        this.stages.add(new DefaultOptimizer.Finalize());
    }

    private static class Pipelining
    implements Stage {
        private Pipelining() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new TopDownPipeline().walk(ast);
            return ast;
        }
    }

    private static class Reordering
    implements Stage {
        private Reordering() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new PredicateSplit().walk(ast);
            ast = new SelectPullup().walk(ast);
            return ast;
        }
    }

    private static class JoinRecognition
    implements Stage {
        private JoinRecognition() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new JoinRewriter(sctx).walk(ast);
            return ast;
        }
    }

    private static class Unnest
    implements Stage {
        private Unnest() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new LetBindToLeftJoin().walk(ast);
            ast = new LeftJoinLifting().walk(ast);
            ast = new LeftJoinRemoval().walk(ast);
            ast = new LeftJoinUnnesting().walk(ast);
            ast = new JoinToSelectConversion().walk(ast);
            return ast;
        }
    }

    private static class FinalizePipeline
    implements Stage {
        private FinalizePipeline() {
        }

        @Override
        public AST rewrite(StaticContext sctx, AST ast) throws QueryException {
            ast = new PredicateMerge().walk(ast);
            ast = new TrivialLeftJoinRemoval().walk(ast);
            ast = new GroupByAggregates().walk(ast);
            ast = new JoinGroupDemarcation().walk(ast);
            ast = new PullEvaluation().walk(ast);
            return ast;
        }
    }
}

