/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.optimizer.walker;

import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.optimizer.walker.Walker;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.xdm.Function;

public class PathDDOElimination
extends Walker {
    public PathDDOElimination(StaticContext sctx) {
        super(sctx);
    }

    @Override
    protected AST visit(AST node) {
        if (node.getType() != 81) {
            return node;
        }
        int stepCount = node.getChildCount();
        AST step = node.getChild(1);
        if (this.isForwardStep(step)) {
            boolean isLastStep;
            boolean isDescOrDescOSStep = this.isDescOrDescOSStep(step);
            boolean bl = isLastStep = stepCount == 2;
            if (!isDescOrDescOSStep || isLastStep) {
                AST firstStep = node.getChild(0);
                if (this.isAtomicOrEmpty(firstStep)) {
                    step.setProperty("skipDDO", Boolean.TRUE);
                } else {
                    step.setProperty("checkInput", Boolean.TRUE);
                }
            }
            if (isDescOrDescOSStep) {
                return node;
            }
        } else if (this.isBackwardStep(step)) {
            // empty if block
        }
        for (int i = 2; i < stepCount; ++i) {
            step = node.getChild(i);
            if (this.isForwardStep(step)) {
                boolean isLastStep;
                boolean isDescOrDescOSStep = this.isDescOrDescOSStep(step);
                boolean bl = isLastStep = i + 1 == stepCount;
                if (!isDescOrDescOSStep || isLastStep) {
                    step.setProperty("skipDDO", Boolean.TRUE);
                }
                if (!isDescOrDescOSStep) continue;
                return node;
            }
            if (!this.isBackwardStep(step)) continue;
        }
        return node;
    }

    private boolean isAtomicOrEmpty(AST step) {
        if (step.getType() == 113) {
            return true;
        }
        if (step.getType() == 80) {
            int childCount = step.getChildCount();
            QNm name = (QNm)step.getValue();
            Function fun = this.sctx.getFunctions().resolve(name, childCount);
            return fun.getSignature().getResultType().getCardinality().atMostOne();
        }
        if (step.getType() == 26) {
            // empty if block
        }
        return false;
    }

    protected boolean sortAfterStep(AST node, int position, int lastPosition) throws QueryException {
        AST child = node.getChild(position);
        if (child.getType() != 83) {
            return true;
        }
        int axis = this.getAxis(child);
        return axis == 86 || axis == 89 || axis == 85;
    }

    private boolean isForwardStep(AST step) {
        return step.getType() == 83 && this.isForwardAxis(this.getAxis(step));
    }

    private boolean isBackwardStep(AST step) {
        return step.getType() == 83 && !this.isForwardAxis(this.getAxis(step));
    }

    private boolean isDescOrDescOSStep(AST step) {
        if (step.getType() != 83) {
            return false;
        }
        int axis = this.getAxis(step);
        return axis == 87 || axis == 88;
    }

    private boolean isForwardAxis(int axis) {
        return axis == 86 || axis == 87 || axis == 89 || axis == 85 || axis == 88 || axis == 90 || axis == 91;
    }

    private boolean isReverseAxis(int axis) {
        return !this.isForwardAxis(axis);
    }

    private int getAxis(AST stepExpr) {
        return stepExpr.getChild(0).getChild(0).getType();
    }
}

