/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.optimizer.walker.topdown;

import java.util.ArrayDeque;
import java.util.Deque;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.optimizer.walker.topdown.CmpUtil;
import org.brackit.xquery.compiler.optimizer.walker.topdown.ScopeWalker;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.util.Cmp;

public class JoinRewriter
extends ScopeWalker {
    private Deque<Boolean> ordered = new ArrayDeque<Boolean>();

    public JoinRewriter(StaticContext sctx) {
        super(sctx);
        this.ordered.push(sctx.isOrderingModeOrdered());
    }

    @Override
    protected AST visit(AST select) {
        if (select.getType() != 232) {
            return select;
        }
        AST predicate = select.getChild(0);
        if (predicate.getType() != 55) {
            return select;
        }
        AST comparison = predicate.getChild(0);
        switch (comparison.getType()) {
            case 41: 
            case 47: 
            case 52: 
            case 53: 
            case 54: {
                return select;
            }
        }
        Cmp cmp = CmpUtil.cmp(comparison);
        boolean isGCmp = CmpUtil.isGCmp(comparison);
        AST s1Expr = predicate.getChild(1);
        ScopeWalker.VarRef s1VarRefs = this.findVarRefs(s1Expr);
        if (s1VarRefs == null) {
            return select;
        }
        AST s2Expr = predicate.getChild(2);
        ScopeWalker.VarRef s2VarRefs = this.findVarRefs(s2Expr);
        if (s2VarRefs == null) {
            return select;
        }
        ScopeWalker.Scope[] s1Scopes = this.sortScopes(s1VarRefs);
        ScopeWalker.Scope[] s2Scopes = this.sortScopes(s2VarRefs);
        if (s2Scopes[s2Scopes.length - 1].compareTo(s1Scopes[s1Scopes.length - 1]) < 0) {
            AST tmpAst = s1Expr;
            s1Expr = s2Expr;
            s2Expr = tmpAst;
            ScopeWalker.VarRef tmpMinVarRef = s1VarRefs;
            s1VarRefs = s2VarRefs;
            s2VarRefs = tmpMinVarRef;
            ScopeWalker.Scope[] tmpScopes = s1Scopes;
            s1Scopes = s2Scopes;
            s2Scopes = tmpScopes;
            cmp = cmp.swap();
        }
        int s1Pos = 0;
        int s2Pos = 0;
        ScopeWalker.Scope s0End = null;
        ScopeWalker.Scope s1Begin = s1Scopes[s1Pos];
        ScopeWalker.Scope s2Begin = s2Scopes[s2Pos];
        while (true) {
            if (s1Begin.compareTo(s2Begin) >= 0) {
                if (++s1Pos == s1Scopes.length) {
                    return select;
                }
                s0End = s1Begin;
                s1Begin = s1Scopes[s1Pos];
                continue;
            }
            if (s0End == null || s2Begin.compareTo(s0End) < 0) break;
            if (++s2Pos == s2Scopes.length) {
                return select;
            }
            s0End = s2Begin;
            s2Begin = s2Scopes[s2Pos];
        }
        AST anc = select.getParent();
        while (anc.getType() != 237 && anc.getType() != 240 && anc.getType() != 233 && anc.getType() != 234) {
            if (anc == s2Begin.node) {
                return this.convertToJoin(s2Begin.node, select, s1Expr, s2Expr, cmp, isGCmp);
            }
            anc = anc.getParent();
        }
        return select;
    }

    private AST convertToJoin(AST rightInRoot, AST select, AST s1Expr, AST s2Expr, Cmp cmp, boolean isGCmp) {
        AST rightIn;
        AST leftIn = new AST(237);
        AST s1End = new AST(241);
        s1End.addChild(s1Expr.copyTree());
        leftIn.addChild(s1End);
        AST copy = rightIn = new AST(237);
        for (AST rorig = rightInRoot; rorig != select; rorig = rorig.getLastChild()) {
            AST toAdd = rorig.copy();
            for (int i = 0; i < rorig.getChildCount() - 1; ++i) {
                toAdd.addChild(rorig.getChild(i).copyTree());
            }
            copy.addChild(toAdd);
            copy = toAdd;
        }
        AST s2End = new AST(241);
        s2End.addChild(s2Expr.copyTree());
        copy.addChild(s2End);
        AST join = new AST(235);
        join.addChild(leftIn);
        join.setProperty("cmp", (Object)cmp);
        join.setProperty("GCmp", isGCmp);
        if (!this.ordered.peek().booleanValue()) {
            join.setProperty("skipSort", Boolean.TRUE);
        }
        join.addChild(rightIn);
        AST postStart = new AST(237);
        postStart.addChild(new AST(241));
        join.addChild(postStart);
        join.addChild(select.getLastChild().copyTree());
        AST parent = rightInRoot.getParent();
        parent.replaceChild(rightInRoot.getChildIndex(), join);
        this.snapshot();
        this.refreshScopes(parent, true);
        parent = this.pushRightInput(join);
        this.snapshot();
        this.refreshScopes(parent, true);
        return parent;
    }

    protected AST pushRightInput(AST join) {
        AST copy;
        AST leftInRoot;
        ScopeWalker.VarRef rRefs = this.findVarRefs(join.getChild(1));
        ScopeWalker.VarRef[] sortedRRefs = this.sortVarRefs(rRefs);
        ScopeWalker.Scope joinScope = this.findScope(join);
        AST target = null;
        ScopeWalker.Scope targetScope = null;
        for (int i = sortedRRefs.length - 1; i >= 0; --i) {
            ScopeWalker.Scope s = sortedRRefs[i].var.scope;
            if (s.compareTo(joinScope) >= 0) continue;
            target = s.node;
            targetScope = s;
            break;
        }
        if (target == null) {
            target = join.getParent();
            while (target.getType() != 237) {
                target = target.getParent();
            }
        } else {
            ScopeWalker.VarRef[] sortedLRefs;
            ScopeWalker.VarRef lRefs = this.findVarRefs(join.getChild(0));
            for (ScopeWalker.VarRef sortedLRef : sortedLRefs = this.sortVarRefs(lRefs)) {
                ScopeWalker.Scope s = sortedLRef.var.scope;
                if (s.compareTo(targetScope) <= 0) continue;
                target = s.node.getParent();
            }
        }
        for (leftInRoot = join.getParent(); leftInRoot.getType() != 237 && leftInRoot != target; leftInRoot = leftInRoot.getParent()) {
        }
        AST copyEnd = copy = new AST(237);
        AST tmp = leftInRoot.getLastChild();
        if (tmp == join) {
            return join;
        }
        while (tmp != join) {
            AST clone = tmp.copy();
            for (int i = 0; i < tmp.getChildCount() - 1; ++i) {
                clone.addChild(tmp.getChild(i).copyTree());
            }
            copyEnd.addChild(clone);
            copyEnd = clone;
            tmp = tmp.getLastChild();
        }
        copyEnd.addChild(join.getChild(0).getChild(0).copyTree());
        join.replaceChild(0, copy);
        leftInRoot.replaceChild(leftInRoot.getChildCount() - 1, join);
        return leftInRoot;
    }
}

