/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.parser;

import java.util.Arrays;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.AnyURI;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.atomic.Dbl;
import org.brackit.xquery.atomic.Dec;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.Bits;
import org.brackit.xquery.compiler.parser.Tokenizer;
import org.brackit.xquery.module.Functions;
import org.brackit.xquery.xdm.Type;

public class XQParser
extends Tokenizer {
    private static final String[] RESERVED_FUNC_NAMES = new String[]{"attribute", "comment", "document-node", "element", "empty-sequence", "function", "if", "item", "namespace-node", "node", "processing-instruction", "schema-attribute", "schema-element", "switch", "text", "typeswitch, array, record"};
    private String version;

    public XQParser(String query) {
        super(query);
    }

    public AST parse() {
        try {
            AST module = this.module();
            if (module == null) {
                throw new QueryException(ErrorCode.ERR_PARSING_ERROR, "No module found");
            }
            this.consumeEOF();
            AST xquery = new AST(0);
            xquery.addChild(module);
            return xquery;
        }
        catch (Tokenizer.IllegalCharRefException e) {
            throw new QueryException(e, ErrorCode.ERR_UNDEFINED_CHARACTER_REFERENCE, (Object)e.getMessage());
        }
        catch (InvalidURIException e) {
            throw new QueryException(e, ErrorCode.ERR_INVALID_URI_LITERAL, (Object)e.getMessage());
        }
        catch (Exception e) {
            throw new QueryException(e, ErrorCode.ERR_PARSING_ERROR, (Object)e.getMessage());
        }
    }

    private void setXQVersion(String version) throws Tokenizer.TokenizerException {
        if ("3.0".equals(version)) {
            this.version = version;
        } else if ("1.0".equals(version)) {
            this.version = version;
        } else if ("1.1".equals(version)) {
            this.version = version;
        } else {
            throw new Tokenizer.TokenizerException((Tokenizer)this, "unsupported version '%s': %s", version, this.paraphrase());
        }
    }

    private void setEncoding(String encoding) {
        System.out.println("set encoding " + encoding);
    }

    private AST module() throws Tokenizer.TokenizerException {
        this.versionDecl();
        AST module = this.libraryModule();
        if (module == null) {
            module = this.mainModule();
        }
        return module;
    }

    private boolean versionDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("xquery");
        if (la == null) {
            return false;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "version");
        if (la2 != null) {
            this.consume(la);
            this.consume(la2);
            this.setXQVersion(this.stringLiteral(false, true).getStringValue());
            if (this.attemptSymSkipWS("encoding")) {
                this.setEncoding(this.stringLiteral(false, true).getStringValue());
            }
        } else {
            la2 = this.laSymSkipWS(la, "encoding");
            if (la2 != null) {
                this.consume(la);
                this.consume(la2);
                this.setEncoding(this.stringLiteral(false, true).getStringValue());
            } else {
                return false;
            }
        }
        this.consumeSkipWS(";");
        return true;
    }

    private AST libraryModule() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("module");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "namespace");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST ncn = this.ncnameLiteral(false, true);
        this.consumeSkipWS("=");
        AST uri = this.uriLiteral(false, true);
        this.consumeSkipWS(";");
        AST module = new AST(1);
        AST nsDecl = new AST(4);
        nsDecl.addChild(ncn);
        nsDecl.addChild(uri);
        module.addChild(nsDecl);
        AST prolog = this.prolog();
        if (prolog != null) {
            module.addChild(prolog);
        }
        return module;
    }

    private AST mainModule() throws Tokenizer.TokenizerException {
        AST prolog = this.prolog();
        AST body = this.queryBody();
        AST module = new AST(2);
        if (prolog != null) {
            module.addChild(prolog);
        }
        module.addChild(body);
        return module;
    }

    private AST prolog() throws Tokenizer.TokenizerException {
        AST def;
        AST prolog = new AST(3);
        while (true) {
            def = (def = this.defaultNamespaceDecl()) != null ? def : this.setter();
            def = def != null ? def : this.namespaceDecl();
            AST aST = def = def != null ? def : this.importDecl();
            if (def == null) break;
            this.consumeSkipWS(";");
            prolog.addChild(def);
        }
        while (true) {
            def = (def = this.contextItemDecl()) != null ? def : this.annotatedDecl();
            AST aST = def = def != null ? def : this.optionDecl();
            if (def == null) break;
            this.consumeSkipWS(";");
            prolog.addChild(def);
        }
        return prolog;
    }

    private AST defaultNamespaceDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "default");
        if (la2 == null) {
            return null;
        }
        boolean element = true;
        Tokenizer.Token la3 = this.laSymSkipWS(la2, "element");
        if (la3 == null) {
            la3 = this.laSymSkipWS(la2, "function");
            if (la3 == null) {
                return null;
            }
            element = false;
        }
        this.consume(la);
        this.consume(la2);
        this.consume(la3);
        AST decl = element ? new AST(160) : new AST(161);
        this.consumeSkipWS("namespace");
        AST uri = this.uriLiteral(false, true);
        decl.addChild(uri);
        return decl;
    }

    private AST setter() throws Tokenizer.TokenizerException {
        AST setter = this.boundarySpaceDecl();
        setter = setter != null ? setter : this.defaultCollationDecl();
        setter = setter != null ? setter : this.baseURIDecl();
        setter = setter != null ? setter : this.constructionDecl();
        setter = setter != null ? setter : this.orderingModeDecl();
        setter = setter != null ? setter : this.emptyOrderDecl();
        setter = setter != null ? setter : this.revalidationDecl();
        setter = setter != null ? setter : this.copyNamespacesDecl();
        setter = setter != null ? setter : this.decimalFormatDecl();
        return setter;
    }

    private AST boundarySpaceDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "boundary-space");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST decl = new AST(170);
        if (this.attemptSkipWS("preserve")) {
            decl.addChild(new AST(171));
        } else if (this.attemptSkipWS("strip")) {
            decl.addChild(new AST(172));
        } else {
            throw new Tokenizer.MismatchException((Tokenizer)this, "preserve", "strip");
        }
        return decl;
    }

    private AST defaultCollationDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "default");
        if (la2 == null) {
            return null;
        }
        Tokenizer.Token la3 = this.laSymSkipWS(la2, "collation");
        if (la3 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consume(la3);
        AST decl = new AST(173);
        decl.addChild(this.uriLiteral(false, true));
        return decl;
    }

    private AST baseURIDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "base-uri");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST decl = new AST(174);
        decl.addChild(this.uriLiteral(false, true));
        return decl;
    }

    private AST constructionDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "construction");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST decl = new AST(175);
        if (this.attemptSkipWS("preserve")) {
            decl.addChild(new AST(176));
        } else if (this.attemptSkipWS("strip")) {
            decl.addChild(new AST(177));
        } else {
            throw new Tokenizer.MismatchException((Tokenizer)this, "preserve", "strip");
        }
        return decl;
    }

    private AST orderingModeDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "ordering");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST decl = new AST(178);
        if (this.attemptSkipWS("ordered")) {
            decl.addChild(new AST(179));
        } else if (this.attemptSkipWS("unordered")) {
            decl.addChild(new AST(180));
        } else {
            throw new Tokenizer.MismatchException((Tokenizer)this, "ordered", "unordered");
        }
        return decl;
    }

    private AST emptyOrderDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "default");
        if (la2 == null) {
            return null;
        }
        Tokenizer.Token la3 = this.laSymSkipWS(la2, "order");
        if (la3 == null) {
            return null;
        }
        Tokenizer.Token la4 = this.laSymSkipWS(la3, "empty");
        if (la4 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consume(la3);
        this.consume(la4);
        AST decl = new AST(181);
        if (this.attemptSkipWS("greatest")) {
            decl.addChild(new AST(182));
        } else if (this.attemptSkipWS("least")) {
            decl.addChild(new AST(183));
        } else {
            throw new Tokenizer.MismatchException((Tokenizer)this, "greatest", "least");
        }
        return decl;
    }

    private AST revalidationDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "revalidation");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST decl = new AST(215);
        if (this.attemptSkipWS("strict")) {
            decl.addChild(new AST(216));
        } else if (this.attemptSkipWS("lax")) {
            decl.addChild(new AST(217));
        } else if (this.attemptSkipWS("skip")) {
            decl.addChild(new AST(218));
        } else {
            throw new Tokenizer.MismatchException((Tokenizer)this, "strict", "lax", "skip");
        }
        return decl;
    }

    private AST copyNamespacesDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "copy-namespaces");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST decl = new AST(184);
        decl.addChild(this.preserveMode());
        this.consumeSkipWS(",");
        decl.addChild(this.inheritMode());
        return decl;
    }

    private AST preserveMode() throws Tokenizer.TokenizerException {
        if (this.attemptSkipWS("preserve")) {
            return new AST(185);
        }
        if (this.attemptSkipWS("no-preserve")) {
            return new AST(186);
        }
        throw new Tokenizer.MismatchException((Tokenizer)this, "preserve", "no-preserve");
    }

    private AST inheritMode() throws Tokenizer.TokenizerException {
        if (this.attemptSkipWS("inherit")) {
            return new AST(187);
        }
        if (this.attemptSkipWS("no-inherit")) {
            return new AST(188);
        }
        throw new Tokenizer.MismatchException((Tokenizer)this, "inherit", "no-inherit");
    }

    private AST decimalFormatDecl() throws Tokenizer.TokenizerException {
        AST dfPropertyName;
        AST format;
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "decimal-format");
        if (la2 != null) {
            this.consume(la);
            this.consume(la2);
            format = this.eqnameLiteral(false, true);
        } else {
            la2 = this.laSymSkipWS(la, "default");
            if (la2 != null) {
                Tokenizer.Token la3 = this.laSymSkipWS(la2, "decimal-format");
                if (la3 == null) {
                    return null;
                }
                this.consume(la);
                this.consume(la2);
                this.consume(la3);
                format = new AST(190);
            } else {
                return null;
            }
        }
        AST decl = new AST(189);
        decl.addChild(format);
        AST[] dfProperties = new AST[]{};
        while ((dfPropertyName = this.dfPropertyName()) != null) {
            this.consumeSkipWS("=");
            AST value = this.stringLiteral(false, true);
            AST dfp = new AST(191);
            dfp.addChild(dfPropertyName);
            dfp.addChild(value);
            dfProperties = this.add(dfProperties, dfp);
        }
        decl.addChildren(dfProperties);
        return decl;
    }

    private AST dfPropertyName() {
        if (this.attemptSkipWS("decimal-separator")) {
            return new AST(192);
        }
        if (this.attemptSkipWS("grouping-separator")) {
            return new AST(193);
        }
        if (this.attemptSkipWS("infinity")) {
            return new AST(194);
        }
        if (this.attemptSkipWS("minus-sign")) {
            return new AST(195);
        }
        if (this.attemptSkipWS("NaN")) {
            return new AST(196);
        }
        if (this.attemptSkipWS("percent")) {
            return new AST(197);
        }
        if (this.attemptSkipWS("per-mille")) {
            return new AST(198);
        }
        if (this.attemptSkipWS("zero-digit")) {
            return new AST(199);
        }
        if (this.attemptSkipWS("digit")) {
            return new AST(200);
        }
        if (this.attemptSkipWS("pattern-separator")) {
            return new AST(201);
        }
        return null;
    }

    private AST namespaceDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "namespace");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST prefix = this.ncnameLiteral(false, true);
        this.consumeSkipWS("=");
        AST uri = this.uriLiteral(false, true);
        AST decl = new AST(4);
        decl.addChild(prefix);
        decl.addChild(uri);
        return decl;
    }

    private AST importDecl() throws Tokenizer.TokenizerException {
        AST importDecl = this.schemaImport();
        return importDecl != null ? importDecl : this.moduleImport();
    }

    private AST schemaImport() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("import");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "schema");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST schemaPrefix = this.schemaPrefix();
        if (schemaPrefix == null) {
            schemaPrefix = new AST(4);
        }
        AST uri = this.uriLiteral(false, true);
        AST[] locs = new AST[]{};
        if (this.attemptSymSkipWS("at")) {
            do {
                AST locUri = this.uriLiteral(true, true);
                locs = this.add(locs, locUri);
            } while (this.attemptSkipWS(","));
        }
        AST imp = new AST(162);
        schemaPrefix.addChild(uri);
        imp.addChild(schemaPrefix);
        imp.addChildren(locs);
        return imp;
    }

    private AST schemaPrefix() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("namespace");
        if (la != null) {
            this.consume(la);
            AST ncname = this.ncnameLiteral(false, true);
            this.consumeSkipWS("=");
            AST ns = new AST(4);
            ns.addChild(ncname);
            return ns;
        }
        la = this.laSymSkipWS("default");
        if (la == null) {
            return null;
        }
        this.consume(la);
        this.consumeSymSkipWS("element");
        this.consumeSymSkipWS("namespace");
        return new AST(160);
    }

    private AST moduleImport() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("import");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "module");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST ns = new AST(4);
        Tokenizer.Token la3 = this.laSkipWS("namespace");
        this.consume(la3);
        AST prefix = this.ncnameLiteral(false, true);
        this.consumeSkipWS("=");
        ns.addChild(prefix);
        AST uri = this.uriLiteral(false, true);
        ns.addChild(uri);
        AST[] locs = new AST[]{};
        if (this.attemptSkipWS("at")) {
            AST locUri;
            while ((locUri = this.uriLiteral(true, true)) != null) {
                locs = this.add(locs, locUri);
            }
        }
        AST imp = new AST(163);
        imp.addChild(ns);
        imp.addChildren(locs);
        return imp;
    }

    private AST contextItemDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "context");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSymSkipWS("item");
        AST ctxItemDecl = new AST(165);
        if (this.attemptSymSkipWS("as")) {
            ctxItemDecl.addChild(this.itemType());
        } else {
            ctxItemDecl.addChild(new AST(71));
        }
        if (this.attemptSkipWS(":=")) {
            ctxItemDecl.addChild(this.varValue());
        } else {
            this.consumeSymSkipWS("external");
            ctxItemDecl.addChild(new AST(166));
            if (this.attemptSkipWS(":=")) {
                ctxItemDecl.addChild(this.varDefaultValue());
            }
        }
        return ctxItemDecl;
    }

    private AST varValue() throws Tokenizer.TokenizerException {
        return this.exprSingle();
    }

    private AST varDefaultValue() throws Tokenizer.TokenizerException {
        return this.exprSingle();
    }

    private AST annotatedDecl() throws Tokenizer.TokenizerException {
        AST ann;
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        if (this.laSkipWS(la, "%") == null && this.laSymSkipWS(la, "variable") == null && this.laSymSkipWS(la, "function") == null && this.laSymSkipWS(la, "updating") == null) {
            return null;
        }
        this.consume(la);
        AST[] anns = new AST[]{};
        while ((ann = this.annotation()) != null) {
            anns = this.add(anns, ann);
        }
        AST decl = this.varDecl();
        decl = decl != null ? decl : this.functionDecl();
        for (AST a : anns) {
            assert (decl != null);
            decl.insertChild(0, a);
        }
        return decl;
    }

    private AST varDecl() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("variable")) {
            return null;
        }
        this.consumeSkipWS("$");
        QNm varName = this.eqname(false, true);
        AST varDecl = new AST(148);
        varDecl.addChild(new AST(11, varName));
        AST typeDecl = this.typeDeclaration();
        if (typeDecl != null) {
            varDecl.addChild(typeDecl);
        }
        if (this.attemptSkipWS(":=")) {
            varDecl.addChild(this.varValue());
        } else {
            this.consumeSkipWS("external");
            varDecl.addChild(new AST(166));
            if (this.attemptSkipWS(":=")) {
                varDecl.addChild(this.varDefaultValue());
            }
        }
        return varDecl;
    }

    private AST functionDecl() throws Tokenizer.TokenizerException {
        AST param;
        if (!this.attemptSymSkipWS("function")) {
            return null;
        }
        AST qname = this.eqnameLiteral(false, true);
        AST funcDecl = new AST(168);
        funcDecl.addChild(qname);
        this.consumeSkipWS("(");
        while ((param = this.param()) != null) {
            funcDecl.addChild(param);
            if (this.attemptSkipWS(",")) continue;
        }
        this.consumeSkipWS(")");
        if (this.attemptSymSkipWS("as")) {
            funcDecl.addChild(this.sequenceType());
        } else {
            AST typeDecl = this.defaultFunctionResultType();
            funcDecl.addChild(typeDecl);
        }
        if (this.attemptSkipWS("external")) {
            funcDecl.addChild(new AST(169));
        } else {
            funcDecl.addChild(this.functionBody());
        }
        return funcDecl;
    }

    private AST defaultFunctionResultType() {
        AST typeDecl = new AST(69);
        typeDecl.addChild(new AST(71));
        typeDecl.addChild(new AST(75));
        return typeDecl;
    }

    private AST functionBody() throws Tokenizer.TokenizerException {
        return this.enclosedExpr(true);
    }

    private AST optionDecl() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("declare");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "option");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST decl = new AST(202);
        decl.addChild(this.eqnameLiteral(false, true));
        decl.addChild(this.stringLiteral(false, true));
        return decl;
    }

    private AST queryBody() throws Tokenizer.TokenizerException {
        AST expr = this.expr();
        AST body = new AST(5);
        body.addChild(expr);
        return body;
    }

    private AST expr() throws Tokenizer.TokenizerException {
        AST first = this.assignmentClause();
        if (first == null) {
            first = this.concatExpr();
            if (this.laSkipWS(";") == null) {
                return first;
            }
            AST c = new AST(12);
            AST bnd = new AST(10);
            bnd.addChild(new AST(11, Bits.FS_FOO));
            c.addChild(bnd);
            c.addChild(first);
            first = c;
        } else if (this.laSkipWS(";") == null) {
            return first.getChild(1);
        }
        QNm lastVar = (QNm)first.getChild(0).getChild(0).getValue();
        AST sequenceExpr = new AST(7);
        sequenceExpr.addChild(first);
        while (this.attemptSkipWS(";")) {
            AST c = this.assignmentClause();
            if (c == null) {
                c = new AST(12);
                AST bnd = new AST(10);
                bnd.addChild(new AST(11, Bits.FS_FOO));
                c.addChild(bnd);
                c.addChild(this.concatExpr());
                lastVar = Bits.FS_FOO;
            } else {
                lastVar = (QNm)c.getChild(0).getChild(0).getValue();
            }
            sequenceExpr.addChild(c);
        }
        AST returnClause = new AST(37);
        returnClause.addChild(new AST(26, lastVar));
        sequenceExpr.addChild(returnClause);
        return sequenceExpr;
    }

    private AST concatExpr() throws Tokenizer.TokenizerException {
        AST first = this.exprSingle();
        if (!this.attemptSkipWS(",")) {
            return first;
        }
        AST sequenceExpr = new AST(6);
        sequenceExpr.addChild(first);
        do {
            AST e = this.exprSingle();
            sequenceExpr.addChild(e);
        } while (this.attemptSkipWS(","));
        return sequenceExpr;
    }

    private AST exprSingle() throws Tokenizer.TokenizerException {
        AST expr = this.flowrExpr();
        expr = expr != null ? expr : this.quantifiedExpr();
        expr = expr != null ? expr : this.switchExpr();
        expr = expr != null ? expr : this.typeswitchExpr();
        expr = expr != null ? expr : this.ifExpr();
        expr = expr != null ? expr : this.tryCatchExpr();
        expr = expr != null ? expr : this.insertExpr();
        expr = expr != null ? expr : this.deleteExpr();
        expr = expr != null ? expr : this.renameExpr();
        expr = expr != null ? expr : this.replaceExpr();
        expr = expr != null ? expr : this.transformExpr();
        expr = expr != null ? expr : this.insertJsonExpr();
        expr = expr != null ? expr : this.deleteJsonExpr();
        expr = expr != null ? expr : this.replaceJsonExpr();
        expr = expr != null ? expr : this.renameJsonExpr();
        expr = expr != null ? expr : this.appendJsonExpr();
        AST aST = expr = expr != null ? expr : this.orExpr();
        if (expr == null) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Non-expression faced: %s", this.paraphrase());
        }
        return expr;
    }

    private AST insertJsonExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("insert");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "json");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST exprSingle = this.exprSingle();
        if (exprSingle == null) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, "expr single expected", new Object[0]);
        }
        if (!this.attemptSymSkipWS("into")) {
            throw new Tokenizer.MismatchException((Tokenizer)this, "into");
        }
        AST target = this.exprSingle();
        if (!this.attemptSymSkipWS("at")) {
            AST expr = new AST(266);
            expr.addChild(exprSingle);
            expr.addChild(target);
            return expr;
        }
        if (!this.attemptSymSkipWS("position")) {
            throw new Tokenizer.MismatchException((Tokenizer)this, "position");
        }
        AST position = this.exprSingle();
        if (position == null) {
            throw new IllegalStateException("No position given.");
        }
        AST expr = new AST(266);
        expr.addChild(exprSingle);
        expr.addChild(target);
        expr.addChild(position);
        return expr;
    }

    private AST deleteJsonExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("delete");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "json");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST target = this.exprSingle();
        AST expr = new AST(267);
        expr.addChild(target);
        return expr;
    }

    private AST replaceJsonExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("replace");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "json");
        if (la2 == null) {
            return null;
        }
        Tokenizer.Token la3 = this.laSymSkipWS(la2, "value");
        if (la3 == null) {
            return null;
        }
        Tokenizer.Token la4 = this.laSymSkipWS(la3, "of");
        if (la4 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consume(la3);
        this.consume(la4);
        AST target = this.postFixExpr();
        AST expr = new AST(269);
        this.consumeSymSkipWS("with");
        AST newExpr = this.exprSingle();
        expr.addChild(target);
        expr.addChild(newExpr);
        return expr;
    }

    private AST renameJsonExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("rename");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "json");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST target = this.postFixExpr();
        AST expr = new AST(268);
        this.consumeSymSkipWS("as");
        AST newExpr = this.exprSingle();
        expr.addChild(target);
        expr.addChild(newExpr);
        return expr;
    }

    private AST appendJsonExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("append");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "json");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST target = this.exprSingle();
        AST expr = new AST(270);
        this.consumeSymSkipWS("into");
        AST newExpr = this.exprSingle();
        expr.addChild(target);
        expr.addChild(newExpr);
        return expr;
    }

    private AST insertExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("insert");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "node");
        if (la2 == null) {
            la2 = this.laSymSkipWS(la, "nodes");
        }
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST src = this.exprSingle();
        AST targetChoice = this.insertExprTargetChoice();
        AST target = this.exprSingle();
        AST expr = new AST(219);
        expr.addChild(targetChoice);
        expr.addChild(src);
        expr.addChild(target);
        return expr;
    }

    private AST insertExprTargetChoice() throws Tokenizer.TokenizerException {
        if (this.attemptSymSkipWS("as")) {
            if (this.attemptSymSkipWS("first")) {
                this.consumeSymSkipWS("into");
                return new AST(220);
            }
            if (this.attemptSymSkipWS("last")) {
                this.consumeSymSkipWS("into");
                return new AST(221);
            }
            throw new Tokenizer.MismatchException((Tokenizer)this, "first", "last");
        }
        if (this.attemptSymSkipWS("into")) {
            return new AST(224);
        }
        if (this.attemptSymSkipWS("after")) {
            return new AST(222);
        }
        if (this.attemptSymSkipWS("before")) {
            return new AST(223);
        }
        throw new Tokenizer.MismatchException((Tokenizer)this, "as", "after", "before");
    }

    private AST deleteExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("delete");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "node");
        if (la2 == null) {
            la2 = this.laSymSkipWS(la, "nodes");
        }
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST target = this.exprSingle();
        AST expr = new AST(225);
        expr.addChild(target);
        return expr;
    }

    private AST renameExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("rename");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "node");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST target = this.exprSingle();
        this.consumeSymSkipWS("as");
        AST newNameExpr = this.exprSingle();
        AST expr = new AST(228);
        expr.addChild(target);
        expr.addChild(newNameExpr);
        return expr;
    }

    private AST replaceExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("replace");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "value");
        if (la2 != null) {
            Tokenizer.Token la3 = this.laSymSkipWS(la2, "of");
            if (la3 == null) {
                return null;
            }
            Tokenizer.Token la4 = this.laSymSkipWS(la3, "node");
            if (la4 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            this.consume(la3);
            this.consume(la4);
            AST target = this.exprSingle();
            AST expr = new AST(226);
            this.consumeSymSkipWS("with");
            AST newExpr = this.exprSingle();
            expr.addChild(target);
            expr.addChild(newExpr);
            return expr;
        }
        la2 = this.laSymSkipWS(la, "node");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST target = this.exprSingle();
        AST expr = new AST(227);
        this.consumeSymSkipWS("with");
        AST newExpr = this.exprSingle();
        expr.addChild(target);
        expr.addChild(newExpr);
        return expr;
    }

    private AST transformExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("copy");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "$");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        AST expr = new AST(229);
        do {
            this.consumeSkipWS("$");
            QNm varName = this.eqname(false, true);
            this.consumeSkipWS(":=");
            AST exprSingle = this.exprSingle();
            AST binding = new AST(230);
            binding.addChild(new AST(11, varName));
            binding.addChild(exprSingle);
            expr.addChild(binding);
        } while (this.attemptSkipWS(","));
        this.consumeSymSkipWS("modify");
        expr.addChild(this.exprSingle());
        this.consumeSymSkipWS("return");
        expr.addChild(this.exprSingle());
        return expr;
    }

    private AST flowrExpr() throws Tokenizer.TokenizerException {
        AST[] intermediateClause;
        AST[] initialClause = this.initialClause();
        if (initialClause == null || initialClause.length == 0) {
            return null;
        }
        AST flworExpr = new AST(7);
        flworExpr.addChildren(initialClause);
        while ((intermediateClause = this.intermediateClause()) != null) {
            flworExpr.addChildren(intermediateClause);
        }
        AST returnExpr = this.returnClause();
        flworExpr.addChild(returnExpr);
        return flworExpr;
    }

    private AST[] initialClause() throws Tokenizer.TokenizerException {
        AST[] clause = this.forClause();
        clause = clause != null ? clause : this.letClause();
        clause = clause != null ? clause : this.windowClause();
        return clause;
    }

    private AST[] forClause() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("for");
        if (la == null) {
            return null;
        }
        if (this.laSkipWS(la, "$") == null) {
            return null;
        }
        this.consume(la);
        AST[] forClauses = new AST[]{};
        do {
            forClauses = this.add(forClauses, this.forBinding());
        } while (this.attemptSkipWS(","));
        return forClauses;
    }

    private AST forBinding() throws Tokenizer.TokenizerException {
        AST posVar;
        AST forClause = new AST(8);
        forClause.addChild(this.typedVarBinding());
        if (this.attemptSymSkipWS("allowing")) {
            this.consumeSymSkipWS("empty");
            forClause.addChild(new AST(9));
        }
        if ((posVar = this.positionalVar()) != null) {
            forClause.addChild(posVar);
        }
        this.consumeSymSkipWS("in");
        forClause.addChild(this.exprSingle());
        return forClause;
    }

    private AST typedVarBinding() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("$")) {
            return null;
        }
        QNm varName = this.eqname(false, true);
        AST binding = new AST(10);
        binding.addChild(new AST(11, varName));
        AST typeDecl = this.typeDeclaration();
        if (typeDecl != null) {
            binding.addChild(typeDecl);
        }
        return binding;
    }

    private AST typeDeclaration() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("as")) {
            return null;
        }
        return this.sequenceType();
    }

    private AST positionalVar() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("at")) {
            return null;
        }
        this.consumeSkipWS("$");
        QNm varName = this.eqname(false, true);
        AST posVarBinding = new AST(10);
        posVarBinding.addChild(new AST(11, varName));
        return posVarBinding;
    }

    private AST[] letClause() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("let");
        if (la == null) {
            return null;
        }
        if (this.laSkipWS(la, "$") == null) {
            return null;
        }
        this.consume(la);
        AST[] letClauses = new AST[]{};
        do {
            letClauses = this.add(letClauses, this.letBinding());
        } while (this.attemptSkipWS(","));
        return letClauses;
    }

    private AST letBinding() throws Tokenizer.TokenizerException {
        AST letClause = new AST(12);
        letClause.addChild(this.typedVarBinding());
        this.consumeSkipWS(":=");
        letClause.addChild(this.exprSingle());
        return letClause;
    }

    private AST[] windowClause() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("for");
        if (la == null) {
            return null;
        }
        if (this.laSymSkipWS(la, "sliding") != null) {
            this.consume(la);
            AST clause = this.tumblingWindowClause();
            return new AST[]{clause};
        }
        if (this.laSymSkipWS(la, "tumbling") != null) {
            this.consume(la);
            AST clause = this.slidingWindowClause();
            return new AST[]{clause};
        }
        return null;
    }

    private AST tumblingWindowClause() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("sliding");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "window");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST clause = new AST(209);
        this.consumeSkipWS("$");
        QNm varName = this.eqname(false, true);
        AST binding = new AST(10);
        binding.addChild(new AST(11, varName));
        AST typeDecl = this.typeDeclaration();
        if (typeDecl != null) {
            binding.addChild(typeDecl);
        }
        clause.addChild(binding);
        this.consumeSymSkipWS("in");
        clause.addChild(this.exprSingle());
        clause.addChild(this.windowStartCondition());
        if (this.laSymSkipWS("only") != null || this.laSymSkipWS("end") != null) {
            clause.addChild(this.windowEndCondition());
        }
        return clause;
    }

    private AST windowStartCondition() throws Tokenizer.TokenizerException {
        this.consumeSymSkipWS("start");
        AST cond = new AST(210);
        cond.addChild(this.windowVars());
        this.consumeSymSkipWS("when");
        cond.addChild(this.exprSingle());
        return cond;
    }

    private AST windowEndCondition() throws Tokenizer.TokenizerException {
        boolean only = this.attemptSymSkipWS("only");
        this.consumeSymSkipWS("end");
        AST cond = new AST(211);
        cond.setProperty("only", only);
        cond.addChild(this.windowVars());
        this.consumeSymSkipWS("when");
        cond.addChild(this.exprSingle());
        return cond;
    }

    private AST windowVars() throws Tokenizer.TokenizerException {
        AST binding;
        QNm varName;
        AST posVar;
        AST vars = new AST(212);
        if (this.attemptSkipWS("$")) {
            QNm varName2 = this.eqname(false, true);
            AST binding2 = new AST(10);
            binding2.addChild(new AST(11, varName2));
            vars.addChild(binding2);
        }
        if ((posVar = this.positionalVar()) != null) {
            vars.addChild(posVar);
        }
        if (this.attemptSymSkipWS("previous")) {
            this.consumeSkipWS("$");
            varName = this.eqname(false, true);
            binding = new AST(213);
            binding.addChild(new AST(11, varName));
            vars.addChild(binding);
        }
        if (this.attemptSymSkipWS("next")) {
            this.consumeSkipWS("$");
            varName = this.eqname(false, true);
            binding = new AST(214);
            binding.addChild(new AST(11, varName));
            vars.addChild(binding);
        }
        return vars;
    }

    private AST slidingWindowClause() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("tumbling");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "window");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST clause = new AST(208);
        this.consumeSkipWS("$");
        QNm varName = this.eqname(false, true);
        AST binding = new AST(10);
        binding.addChild(new AST(11, varName));
        AST typeDecl = this.typeDeclaration();
        if (typeDecl != null) {
            binding.addChild(typeDecl);
        }
        clause.addChild(binding);
        this.consumeSymSkipWS("in");
        clause.addChild(this.exprSingle());
        clause.addChild(this.windowStartCondition());
        clause.addChild(this.windowEndCondition());
        return null;
    }

    private AST[] intermediateClause() throws Tokenizer.TokenizerException {
        AST[] aSTArray;
        AST[] clauses = this.initialClause();
        if (clauses != null) {
            return clauses;
        }
        AST clause = this.whereClause();
        clause = clause != null ? clause : this.groupByClause();
        clause = clause != null ? clause : this.orderByClause();
        AST aST = clause = clause != null ? clause : this.countClause();
        if (clause != null) {
            AST[] aSTArray2 = new AST[1];
            aSTArray = aSTArray2;
            aSTArray2[0] = clause;
        } else {
            aSTArray = null;
        }
        return aSTArray;
    }

    private AST whereClause() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("where")) {
            return null;
        }
        AST whereClause = new AST(13);
        whereClause.addChild(this.exprSingle());
        return whereClause;
    }

    private AST groupByClause() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("group")) {
            return null;
        }
        this.consumeSymSkipWS("by");
        AST groupByClause = new AST(14);
        if (!this.attemptSkipWS("*")) {
            do {
                this.consumeSkipWS("$");
                AST gs = new AST(15);
                QNm varName = this.eqname(false, true);
                gs.addChild(new AST(26, varName));
                if (this.attemptSymSkipWS("collation")) {
                    AST uriLiteral = this.uriLiteral(false, true);
                    AST collation = new AST(27);
                    collation.addChild(uriLiteral);
                    gs.addChild(collation);
                }
                groupByClause.addChild(gs);
            } while (this.attemptSkipWS(","));
        }
        AST dftAggregate = new AST(17);
        dftAggregate.addChild(new AST(19));
        groupByClause.addChild(dftAggregate);
        return groupByClause;
    }

    private AST orderByClause() throws Tokenizer.TokenizerException {
        if (this.attemptSymSkipWS("stable")) {
            this.consumeSymSkipWS("order");
        } else if (!this.attemptSymSkipWS("order")) {
            return null;
        }
        this.consumeSymSkipWS("by");
        AST clause = new AST(28);
        do {
            AST os = new AST(29);
            clause.addChild(os);
            os.addChild(this.exprSingle());
            if (this.attemptSymSkipWS("ascending")) {
                obk = new AST(30);
                obk.addChild(new AST(31));
                os.addChild(obk);
            } else if (this.attemptSymSkipWS("descending")) {
                obk = new AST(30);
                obk.addChild(new AST(32));
                os.addChild(obk);
            }
            if (this.attemptSymSkipWS("empty")) {
                if (this.attemptSymSkipWS("greatest")) {
                    obem = new AST(33);
                    obem.addChild(new AST(34));
                    os.addChild(obem);
                } else if (this.attemptSymSkipWS("least")) {
                    obem = new AST(33);
                    obem.addChild(new AST(35));
                    os.addChild(obem);
                }
            }
            if (!this.attemptSymSkipWS("collation")) continue;
            AST uriLiteral = this.uriLiteral(false, true);
            AST collation = new AST(27);
            collation.addChild(uriLiteral);
            os.addChild(collation);
        } while (this.attemptSkipWS(","));
        return clause;
    }

    private AST countClause() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("count");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "$");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        QNm varName = this.eqname(false, true);
        AST countClause = new AST(36);
        AST binding = new AST(10);
        AST var = new AST(11, varName);
        binding.addChild(var);
        AST type = new AST(69);
        AST aouType = new AST(72);
        type.addChild(aouType);
        aouType.addChild(new AST(119, Type.INR.getName()));
        binding.addChild(type);
        countClause.addChild(binding);
        return countClause;
    }

    private AST returnClause() throws Tokenizer.TokenizerException {
        this.consumeSymSkipWS("return");
        AST returnExpr = new AST(37);
        returnExpr.addChild(this.exprSingle());
        return returnExpr;
    }

    private AST quantifiedExpr() throws Tokenizer.TokenizerException {
        AST quantifier;
        if (this.attemptSymSkipWS("some")) {
            quantifier = new AST(128);
        } else if (this.attemptSymSkipWS("every")) {
            quantifier = new AST(129);
        } else {
            return null;
        }
        if (this.laSkipWS("$") == null) {
            return null;
        }
        AST qExpr = new AST(130);
        qExpr.addChild(quantifier);
        AST qBinding = new AST(131);
        qBinding.addChild(this.typedVarBinding());
        this.consumeSymSkipWS("in");
        qBinding.addChild(this.exprSingle());
        qExpr.addChild(qBinding);
        while (this.attemptSkipWS(",")) {
            AST binding = this.typedVarBinding();
            if (binding == null) {
                throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected variable binding: %s", this.paraphrase());
            }
            AST qBinding2 = new AST(131);
            qBinding2.addChild(binding);
            this.consumeSymSkipWS("in");
            qBinding2.addChild(this.exprSingle());
            qExpr.addChild(qBinding2);
        }
        this.consumeSymSkipWS("satisfies");
        qExpr.addChild(this.exprSingle());
        return qExpr;
    }

    private AST switchExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("switch");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST sExpr = new AST(132);
        sExpr.addChild(this.expr());
        this.consumeSkipWS(")");
        AST clause = this.switchClause();
        if (clause == null) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected switch clause: %s", this.paraphrase());
        }
        sExpr.addChild(clause);
        while ((clause = this.switchClause()) != null) {
            sExpr.addChild(clause);
        }
        this.consumeSymSkipWS("default");
        this.consumeSymSkipWS("return");
        sExpr.addChild(this.exprSingle());
        return sExpr;
    }

    private AST switchClause() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("case")) {
            return null;
        }
        AST clause = new AST(133);
        do {
            clause.addChild(this.exprSingle());
        } while (!this.attemptSymSkipWS("return"));
        clause.addChild(this.exprSingle());
        return clause;
    }

    private AST typeswitchExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("typeswitch");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST tsExpr = new AST(134);
        tsExpr.addChild(this.expr());
        this.consumeSkipWS(")");
        AST clause = this.caseClause();
        if (clause == null) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected case clause: %s", this.paraphrase());
        }
        tsExpr.addChild(clause);
        while ((clause = this.caseClause()) != null) {
            tsExpr.addChild(clause);
        }
        this.consumeSymSkipWS("default");
        AST dftClause = new AST(135);
        if (this.attemptSkipWS("$")) {
            QNm varName = this.eqname(false, true);
            dftClause.addChild(new AST(11, varName));
        }
        this.consumeSymSkipWS("return");
        dftClause.addChild(this.exprSingle());
        tsExpr.addChild(dftClause);
        return tsExpr;
    }

    private AST caseClause() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("case")) {
            return null;
        }
        AST clause = new AST(135);
        if (this.attemptSkipWS("$")) {
            QNm varName = this.eqname(false, true);
            clause.addChild(new AST(11, varName));
            this.consumeSymSkipWS("as");
        }
        do {
            clause.addChild(this.sequenceType());
        } while (this.attemptSkipWS("|"));
        this.consumeSymSkipWS("return");
        clause.addChild(this.exprSingle());
        return clause;
    }

    private AST ifExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("if");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST ifExpr = new AST(136);
        ifExpr.addChild(this.exprSingle());
        this.consumeSkipWS(")");
        this.consumeSymSkipWS("then");
        ifExpr.addChild(this.exprSingle());
        this.consumeSymSkipWS("else");
        ifExpr.addChild(this.exprSingle());
        return ifExpr;
    }

    private AST tryCatchExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSymSkipWS("try");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "{");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST tcExpr = new AST(137);
        tcExpr.addChild(this.expr());
        this.consumeSkipWS("}");
        AST clause = this.tryClause();
        if (clause == null) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected try clause: %s", this.paraphrase());
        }
        tcExpr.addChild(clause);
        while ((clause = this.tryClause()) != null) {
            tcExpr.addChild(clause);
        }
        return tcExpr;
    }

    private AST tryClause() throws Tokenizer.TokenizerException {
        if (!this.attemptSymSkipWS("catch")) {
            return null;
        }
        AST clause = new AST(138);
        clause.addChild(this.catchErrorList());
        this.consumeSkipWS("{");
        clause.addChild(this.expr());
        this.consumeSkipWS("}");
        return clause;
    }

    private AST catchErrorList() throws Tokenizer.TokenizerException {
        AST list = new AST(139);
        do {
            list.addChild(this.nameTest());
        } while (this.attemptSkipWS("|"));
        return list;
    }

    private AST orExpr() throws Tokenizer.TokenizerException {
        AST first = this.andExpr();
        if (first == null) {
            return null;
        }
        while (this.attemptSymSkipWS("or")) {
            AST second = this.andExpr();
            AST expr = new AST(38);
            expr.addChild(first);
            expr.addChild(second);
            first = expr;
        }
        return first;
    }

    private AST andExpr() throws Tokenizer.TokenizerException {
        AST first = this.comparisonExpr();
        if (first == null) {
            return null;
        }
        while (this.attemptSymSkipWS("and")) {
            AST second = this.comparisonExpr();
            AST expr = new AST(39);
            expr.addChild(first);
            expr.addChild(second);
            first = expr;
        }
        return first;
    }

    private AST comparisonExpr() throws Tokenizer.TokenizerException {
        AST cmp;
        AST first = this.rangeExpr();
        if (first == null) {
            return null;
        }
        if (this.attemptSkipWS("=")) {
            cmp = new AST(40);
        } else if (this.attemptSkipWS("!=")) {
            cmp = new AST(41);
        } else if (this.attemptSkipWS("<=")) {
            cmp = new AST(43);
        } else if (this.attemptSkipWS("<<")) {
            cmp = new AST(53);
        } else if (this.attemptSkipWS("<")) {
            cmp = new AST(42);
        } else if (this.attemptSkipWS(">=")) {
            cmp = new AST(45);
        } else if (this.attemptSkipWS(">>")) {
            cmp = new AST(54);
        } else if (this.attemptSkipWS(">")) {
            cmp = new AST(44);
        } else if (this.attemptSymSkipWS("eq")) {
            cmp = new AST(46);
        } else if (this.attemptSymSkipWS("ne")) {
            cmp = new AST(47);
        } else if (this.attemptSymSkipWS("lt")) {
            cmp = new AST(48);
        } else if (this.attemptSymSkipWS("le")) {
            cmp = new AST(49);
        } else if (this.attemptSymSkipWS("gt")) {
            cmp = new AST(50);
        } else if (this.attemptSymSkipWS("ge")) {
            cmp = new AST(51);
        } else if (this.attemptSymSkipWS("is")) {
            cmp = new AST(52);
        } else {
            return first;
        }
        AST second = this.comparisonExpr();
        AST expr = new AST(55);
        expr.addChild(cmp);
        expr.addChild(first);
        expr.addChild(second);
        return expr;
    }

    private AST rangeExpr() throws Tokenizer.TokenizerException {
        AST first = this.additiveExpr();
        if (first == null) {
            return null;
        }
        if (!this.attemptSymSkipWS("to")) {
            return first;
        }
        AST second = this.additiveExpr();
        AST expr = new AST(57);
        expr.addChild(first);
        expr.addChild(second);
        return expr;
    }

    private AST additiveExpr() throws Tokenizer.TokenizerException {
        AST first = this.multiplicativeExpr();
        if (first == null) {
            return null;
        }
        while (true) {
            AST op;
            if (this.attemptSkipWS("+")) {
                op = new AST(58);
            } else if (this.attemptSkipWS("-")) {
                op = new AST(59);
            } else {
                return first;
            }
            AST second = this.multiplicativeExpr();
            AST expr = new AST(60);
            expr.addChild(op);
            expr.addChild(first);
            expr.addChild(second);
            first = expr;
        }
    }

    private AST multiplicativeExpr() throws Tokenizer.TokenizerException {
        AST first = this.unionExpr();
        if (first == null) {
            return null;
        }
        while (true) {
            AST op;
            if (this.attemptSkipWS("*")) {
                op = new AST(61);
            } else if (this.attemptSymSkipWS("div")) {
                op = new AST(62);
            } else if (this.attemptSymSkipWS("idiv")) {
                op = new AST(63);
            } else if (this.attemptSymSkipWS("mod")) {
                op = new AST(64);
            } else {
                return first;
            }
            AST second = this.unionExpr();
            AST expr = new AST(60);
            expr.addChild(op);
            expr.addChild(first);
            expr.addChild(second);
            first = expr;
        }
    }

    private AST unionExpr() throws Tokenizer.TokenizerException {
        AST first = this.intersectExpr();
        if (first == null) {
            return null;
        }
        while (this.laSkipWS("|}") == null) {
            if (!this.attemptSymSkipWS("union") && !this.attemptSkipWS("|")) {
                return first;
            }
            AST second = this.intersectExpr();
            AST expr = new AST(65);
            expr.addChild(first);
            expr.addChild(second);
            first = expr;
        }
        return first;
    }

    private AST intersectExpr() throws Tokenizer.TokenizerException {
        AST first = this.instanceOfExpr();
        if (first == null) {
            return null;
        }
        while (true) {
            AST expr;
            if (this.attemptSymSkipWS("intersect")) {
                expr = new AST(66);
            } else if (this.attemptSymSkipWS("except")) {
                expr = new AST(67);
            } else {
                return first;
            }
            AST second = this.instanceOfExpr();
            expr.addChild(first);
            expr.addChild(second);
            first = expr;
        }
    }

    private AST instanceOfExpr() throws Tokenizer.TokenizerException {
        AST first = this.treatExpr();
        if (first == null) {
            return null;
        }
        if (!this.attemptSymSkipWS("instance")) {
            return first;
        }
        this.consumeSymSkipWS("of");
        AST type = this.sequenceType();
        AST expr = new AST(68);
        expr.addChild(first);
        expr.addChild(type);
        return expr;
    }

    private AST sequenceType() throws Tokenizer.TokenizerException {
        AST type = this.emptySequence();
        AST occInd = null;
        if (type == null) {
            type = this.itemType();
            occInd = this.occurrenceIndicator();
        }
        AST typeDecl = new AST(69);
        typeDecl.addChild(type);
        if (occInd != null) {
            typeDecl.addChild(occInd);
        }
        return typeDecl;
    }

    private AST emptySequence() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("empty-sequence");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(70);
    }

    private AST anyKind() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("item");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(71);
    }

    private AST jsonItemType() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("json-item");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(262);
    }

    private AST recordType() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("record");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(247);
    }

    private AST arrayType() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("array");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(242);
    }

    private AST occurrenceIndicator() {
        if (this.attemptSkipWS("?")) {
            return new AST(74);
        }
        if (this.attemptSkipWS("*")) {
            return new AST(75);
        }
        if (this.attemptSkipWS("+")) {
            return new AST(76);
        }
        return null;
    }

    private AST itemType() throws Tokenizer.TokenizerException {
        AST type = this.kindTest();
        type = type != null ? type : this.jsonTest();
        type = type != null ? type : this.structuredItemTest();
        type = type != null ? type : this.anyKind();
        type = type != null ? type : this.functionTest();
        type = type != null ? type : this.atomicOrUnionType();
        type = type != null ? type : this.parenthesizedItemType();
        return type;
    }

    private AST structuredItemTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("structured-item");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(263);
    }

    private AST jsonTest() throws Tokenizer.TokenizerException {
        AST test = this.jsonItemType();
        test = test != null ? test : this.recordType();
        test = test != null ? test : this.arrayType();
        return test;
    }

    private AST functionTest() throws Tokenizer.TokenizerException {
        AST ann;
        AST funcTest = null;
        while ((ann = this.annotation()) != null) {
            if (funcTest == null) {
                funcTest = new AST(125);
            }
            funcTest.addChild(ann);
        }
        AST test = this.anyFunctionTest();
        AST aST = test = test != null ? test : this.typedFunctionTest();
        if (test == null) {
            if (funcTest != null) {
                throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected function test: %s", this.paraphrase());
            }
            return null;
        }
        if (funcTest == null) {
            funcTest = new AST(125);
        }
        funcTest.addChild(test);
        return funcTest;
    }

    private AST annotation() throws Tokenizer.TokenizerException {
        if (this.attemptSymSkipWS("updating")) {
            return new AST(124, "updating");
        }
        if (!this.attemptSkipWS("%")) {
            return null;
        }
        QNm eqname = this.eqname(false, true);
        AST ann = new AST(124, eqname);
        if (this.attemptSkipWS("(")) {
            do {
                ann.addChild(this.stringLiteral(false, true));
            } while (this.attemptSkipWS(","));
            this.consumeSkipWS(")");
        }
        return ann;
    }

    private AST anyFunctionTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("function");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        Tokenizer.Token la3 = this.laSkipWS(la2, "*");
        if (la3 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consume(la3);
        this.consumeSkipWS(")");
        return new AST(126);
    }

    private AST typedFunctionTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("function");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST typedFunc = new AST(127);
        if (!this.attemptSkipWS(")")) {
            do {
                typedFunc.addChild(this.sequenceType());
            } while (this.attemptSkipWS(","));
            this.consumeSkipWS(")");
        }
        this.consumeSymSkipWS("as");
        typedFunc.addChild(this.sequenceType());
        return typedFunc;
    }

    private AST atomicOrUnionType() throws Tokenizer.TokenizerException {
        AST eqname = this.eqnameLiteral(true, true);
        if (eqname == null) {
            return null;
        }
        AST aouType = new AST(72);
        aouType.addChild(eqname);
        return aouType;
    }

    private AST parenthesizedItemType() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("(")) {
            return null;
        }
        AST itemType = this.itemType();
        this.consumeSkipWS(")");
        return itemType;
    }

    private AST singleType() throws Tokenizer.TokenizerException {
        AST aouType = this.atomicOrUnionType();
        if (aouType == null) {
            return null;
        }
        AST type = new AST(69);
        type.addChild(aouType);
        if (this.attemptSkipWS("?")) {
            type.addChild(new AST(74));
        }
        return type;
    }

    private AST treatExpr() throws Tokenizer.TokenizerException {
        AST first = this.castableExpr();
        if (first == null) {
            return null;
        }
        if (!this.attemptSymSkipWS("treat")) {
            return first;
        }
        this.consumeSymSkipWS("as");
        AST type = this.sequenceType();
        AST expr = new AST(77);
        expr.addChild(first);
        expr.addChild(type);
        return expr;
    }

    private AST castableExpr() throws Tokenizer.TokenizerException {
        AST first = this.castExpr();
        if (first == null) {
            return null;
        }
        if (!this.attemptSymSkipWS("castable")) {
            return first;
        }
        this.consumeSymSkipWS("as");
        AST type = this.singleType();
        AST expr = new AST(78);
        expr.addChild(first);
        expr.addChild(type);
        return expr;
    }

    private AST castExpr() throws Tokenizer.TokenizerException {
        AST first = this.unaryExpr();
        if (first == null) {
            return null;
        }
        if (!this.attemptSymSkipWS("cast")) {
            return first;
        }
        this.consumeSymSkipWS("as");
        AST type = this.singleType();
        AST expr = new AST(79);
        expr.addChild(first);
        expr.addChild(type);
        return expr;
    }

    private AST unaryExpr() throws Tokenizer.TokenizerException {
        int minusCount = 0;
        while (true) {
            if (this.attemptSkipWS("+")) {
                continue;
            }
            if (!this.attemptSkipWS("-")) break;
            ++minusCount;
        }
        if ((minusCount & 1) == 0) {
            return this.valueExpr();
        }
        AST expr = new AST(60);
        expr.addChild(new AST(61));
        expr.addChild(new AST(117, Int32.N_ONE));
        expr.addChild(this.valueExpr());
        return expr;
    }

    private AST valueExpr() throws Tokenizer.TokenizerException {
        AST expr = this.validateExpr();
        expr = expr != null ? expr : this.pathExpr();
        expr = expr != null ? expr : this.extensionExpr();
        return expr;
    }

    private AST extensionExpr() throws Tokenizer.TokenizerException {
        AST pragma = this.pragma();
        if (pragma == null) {
            return null;
        }
        AST eExpr = new AST(140);
        eExpr.addChild(pragma);
        while ((pragma = this.pragma()) != null) {
            eExpr.addChild(pragma);
        }
        this.consumeSkipWS("{");
        if (!this.attemptSkipWS("}")) {
            eExpr.addChild(this.expr());
            this.consumeSkipWS("}");
        }
        return eExpr;
    }

    private AST pragma() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("(#")) {
            return null;
        }
        AST pragma = new AST(141);
        this.attemptWS();
        pragma.addChild(this.eqnameLiteral(false, false));
        if (this.attemptWS()) {
            pragma.addChild(this.pragmaContent());
        }
        this.consume("#)");
        return pragma;
    }

    private AST pathExpr() throws Tokenizer.TokenizerException {
        return this.relativePathExpr();
    }

    private AST relativePathExpr() throws Tokenizer.TokenizerException {
        AST[] path;
        AST step;
        if (this.attemptSkipWS("//")) {
            step = this.stepExpr();
            if (step == null) {
                throw new Tokenizer.TokenizerException((Tokenizer)this, "Incomplete path step: %s", this.paraphrase());
            }
            treat = this.fnRootTreatAsDocument();
            AST dosn = this.descendantOrSelfNode();
            path = new AST[]{treat, dosn, step};
        } else if (this.attemptSkipWS("/")) {
            step = this.stepExpr();
            if (step == null) {
                if (!this.checkLeadingLoneSlash()) {
                    throw new Tokenizer.TokenizerException((Tokenizer)this, "Incomplete path step: %s", this.paraphrase());
                }
                return this.fnRootTreatAsDocument();
            }
            treat = this.fnRootTreatAsDocument();
            path = new AST[]{treat, step};
        } else {
            step = this.stepExpr();
            if (step == null) {
                return null;
            }
            path = new AST[]{step};
        }
        while (true) {
            if (this.attemptSkipWS("//")) {
                path = this.add(path, this.descendantOrSelfNode());
            } else if (!this.attemptSkipWS("/")) break;
            step = this.stepExpr();
            if (step == null) {
                throw new Tokenizer.TokenizerException((Tokenizer)this, "Incomplete path step: %s", this.paraphrase());
            }
            path = this.add(path, step);
        }
        if (path.length == 1) {
            return path[0];
        }
        AST pathExpr = new AST(81);
        pathExpr.addChildren(path);
        return pathExpr;
    }

    private boolean checkLeadingLoneSlash() {
        return this.laSkipWS("*") == null && this.laSkipWS("<") == null && this.laNCNameSkipWS() == null && this.laQNameSkipWS() == null && this.laSkipWS("\"") == null && this.laSkipWS("'") == null;
    }

    private AST descendantOrSelfNode() {
        AST dosn = new AST(83);
        AST axisSpec = new AST(84);
        axisSpec.addChild(new AST(88));
        dosn.addChild(axisSpec);
        dosn.addChild(new AST(97));
        return dosn;
    }

    private AST fnRootTreatAsDocument() {
        AST treat = new AST(77);
        AST call = new AST(80, Functions.FN_ROOT);
        AST step = new AST(83);
        AST axisSpec = new AST(84);
        axisSpec.addChild(new AST(85));
        step.addChild(axisSpec);
        step.addChild(new AST(97));
        AST seqType = new AST(69);
        seqType.addChild(new AST(98));
        call.addChild(step);
        treat.addChild(call);
        treat.addChild(seqType);
        AST parenthesized = new AST(112);
        parenthesized.addChild(treat);
        return parenthesized;
    }

    private AST stepExpr() throws Tokenizer.TokenizerException {
        AST expr = this.postFixExpr();
        if (expr != null) {
            return expr;
        }
        return this.axisStep();
    }

    private AST axisStep() throws Tokenizer.TokenizerException {
        AST[] step = this.forwardStep();
        if (step == null) {
            step = this.reverseStep();
        }
        if (step == null) {
            step = this.temporalStep();
        }
        if (step == null) {
            return null;
        }
        AST[] predicateList = this.predicateList();
        AST stepExpr = new AST(83);
        stepExpr.addChildren(step);
        if (predicateList != null) {
            stepExpr.addChildren(predicateList);
        }
        return stepExpr;
    }

    private AST[] temporalStep() throws Tokenizer.TokenizerException {
        AST axis = this.temporalAxis();
        if (axis == null) {
            return null;
        }
        AST axisSpec = new AST(84);
        axisSpec.addChild(axis);
        return new AST[]{axisSpec, this.nodeTest()};
    }

    private AST temporalAxis() {
        AST axis;
        Tokenizer.Token la = this.laSkipWS("next");
        if (la != null) {
            axis = new AST(253);
        } else {
            la = this.laSkipWS("previous");
            if (la != null) {
                axis = new AST(254);
            } else {
                la = this.laSkipWS("future-or-self");
                if (la != null) {
                    axis = new AST(256);
                } else {
                    la = this.laSkipWS("future");
                    if (la != null) {
                        axis = new AST(255);
                    } else {
                        la = this.laSkipWS("past");
                        if (la != null) {
                            axis = new AST(257);
                        } else {
                            la = this.laSkipWS("past-or-self");
                            if (la != null) {
                                axis = new AST(258);
                            } else {
                                la = this.laSkipWS("last");
                                if (la != null) {
                                    axis = new AST(260);
                                } else {
                                    la = this.laSkipWS("first");
                                    if (la != null) {
                                        axis = new AST(259);
                                    } else {
                                        la = this.laSkipWS("all-times");
                                        if (la != null) {
                                            axis = new AST(261);
                                        } else {
                                            return null;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "::");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        return axis;
    }

    private AST[] forwardStep() throws Tokenizer.TokenizerException {
        AST axis = this.forwardAxis();
        if (axis == null) {
            return this.abbrevForwardStep();
        }
        AST axisSpec = new AST(84);
        axisSpec.addChild(axis);
        return new AST[]{axisSpec, this.nodeTest()};
    }

    private AST forwardAxis() {
        AST axis;
        Tokenizer.Token la = this.laSkipWS("child");
        if (la != null) {
            axis = new AST(86);
        } else {
            la = this.laSkipWS("descendant-or-self");
            if (la != null) {
                axis = new AST(88);
            } else {
                la = this.laSkipWS("descendant");
                if (la != null) {
                    axis = new AST(87);
                } else {
                    la = this.laSkipWS("attribute");
                    if (la != null) {
                        axis = new AST(89);
                    } else {
                        la = this.laSkipWS("self");
                        if (la != null) {
                            axis = new AST(85);
                        } else {
                            la = this.laSkipWS("following-sibling");
                            if (la != null) {
                                axis = new AST(90);
                            } else {
                                la = this.laSkipWS("following");
                                if (la != null) {
                                    axis = new AST(91);
                                } else {
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "::");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        return axis;
    }

    private AST[] abbrevForwardStep() throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        boolean attributeAxis = false;
        if (this.attemptSkipWS("@")) {
            attributeAxis = true;
        } else {
            la = this.laSkipWS("attribute");
            if (la == null) {
                la = this.laSkipWS("schema-attribute");
            }
            if (la != null && this.laSkipWS(la, "(") != null) {
                attributeAxis = true;
            }
        }
        la = this.laEQNameSkipWS(true);
        if (la != null && this.laSkipWS(la, "::") != null) {
            return null;
        }
        AST nodeTest = this.nodeTest();
        if (nodeTest == null) {
            return null;
        }
        AST axisSpec = new AST(84);
        if (attributeAxis) {
            axisSpec.addChild(new AST(89));
        } else {
            axisSpec.addChild(new AST(86));
        }
        return new AST[]{axisSpec, nodeTest};
    }

    private AST[] reverseStep() throws Tokenizer.TokenizerException {
        AST axis = this.reverseAxis();
        if (axis == null) {
            return this.abbrevReverseStep();
        }
        AST axisSpec = new AST(84);
        axisSpec.addChild(axis);
        return new AST[]{axisSpec, this.nodeTest()};
    }

    private AST reverseAxis() {
        AST axis;
        Tokenizer.Token la = this.laSkipWS("parent");
        if (la != null) {
            axis = new AST(92);
        } else {
            la = this.laSkipWS("ancestor-or-self");
            if (la != null) {
                axis = new AST(96);
            } else {
                la = this.laSkipWS("ancestor");
                if (la != null) {
                    axis = new AST(93);
                } else {
                    la = this.laSkipWS("preceding-sibling");
                    if (la != null) {
                        axis = new AST(94);
                    } else {
                        la = this.laSkipWS("preceding");
                        if (la != null) {
                            axis = new AST(95);
                        } else {
                            return null;
                        }
                    }
                }
            }
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "::");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        return axis;
    }

    private AST[] abbrevReverseStep() {
        if (!this.attemptSkipWS("..")) {
            return null;
        }
        AST axisSpec = new AST(84);
        axisSpec.addChild(new AST(92));
        AST nameTest = new AST(99);
        nameTest.addChild(new AST(100));
        return new AST[]{axisSpec, nameTest};
    }

    private AST nodeTest() throws Tokenizer.TokenizerException {
        AST test = this.kindTest();
        test = test != null ? test : this.nameTest();
        return test;
    }

    private AST kindTest() throws Tokenizer.TokenizerException {
        AST test = this.documentTest();
        test = test != null ? test : this.elementTest();
        test = test != null ? test : this.attributeTest();
        test = test != null ? test : this.schemaElementTest();
        test = test != null ? test : this.schemaAttributeTest();
        test = test != null ? test : this.piTest();
        test = test != null ? test : this.commentTest();
        test = test != null ? test : this.textTest();
        test = test != null ? test : this.namespaceNodeTest();
        test = test != null ? test : this.anyKindTest();
        return test;
    }

    private AST documentTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("document-node");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST elTest = this.elementTest();
        elTest = elTest != null ? elTest : this.schemaElementTest();
        this.consumeSkipWS(")");
        AST docTest = new AST(98);
        if (elTest != null) {
            docTest.addChild(elTest);
        }
        return docTest;
    }

    private AST elementTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("element");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST enow = this.elementNameOrWildcard();
        AST tn = null;
        AST nilled = null;
        if (enow != null && this.attemptSkipWS(",")) {
            tn = this.eqnameLiteral(true, true);
            if (this.attemptSkipWS("?")) {
                nilled = new AST(101);
            }
        }
        this.consumeSkipWS(")");
        AST elTest = new AST(102);
        if (enow != null) {
            elTest.addChild(enow);
        }
        if (tn != null) {
            elTest.addChild(tn);
        }
        if (nilled != null) {
            elTest.addChild(nilled);
        }
        return elTest;
    }

    private AST attributeTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("attribute");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST anow = this.attributeNameOrWildcard();
        AST tn = null;
        AST nilled = null;
        if (anow != null && this.attemptSkipWS(",")) {
            tn = this.eqnameLiteral(true, true);
            if (this.attemptSkipWS("?")) {
                nilled = new AST(101);
            }
        }
        this.consumeSkipWS(")");
        AST attTest = new AST(103);
        if (anow != null) {
            attTest.addChild(anow);
        }
        if (tn != null) {
            attTest.addChild(tn);
        }
        if (nilled != null) {
            attTest.addChild(nilled);
        }
        return attTest;
    }

    private AST schemaElementTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("schema-element");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST name = this.eqnameLiteral(false, true);
        this.consumeSkipWS(")");
        AST test = new AST(104);
        test.addChild(name);
        return test;
    }

    private AST schemaAttributeTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("schema-attribute");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST name = this.eqnameLiteral(false, true);
        this.consumeSkipWS(")");
        AST test = new AST(105);
        test.addChild(name);
        return test;
    }

    private AST piTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("processing-instruction");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST name = this.ncnameLiteral(true, true);
        name = name != null ? name : this.stringLiteral(true, true);
        this.consumeSkipWS(")");
        AST test = new AST(106);
        if (name != null) {
            test.addChild(name);
        }
        return test;
    }

    private AST commentTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("comment");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(107);
    }

    private AST textTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("text");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(108);
    }

    private AST namespaceNodeTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("namespace-node");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(109);
    }

    private AST anyKindTest() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("node");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        this.consumeSkipWS(")");
        return new AST(97);
    }

    private AST elementNameOrWildcard() throws Tokenizer.TokenizerException {
        AST enow = this.eqnameLiteral(true, true);
        if (enow != null) {
            return enow;
        }
        if (this.attemptSkipWS("*")) {
            return new AST(100);
        }
        return null;
    }

    private AST attributeNameOrWildcard() throws Tokenizer.TokenizerException {
        AST anow = this.eqnameLiteral(true, true);
        if (anow != null) {
            return anow;
        }
        if (this.attemptSkipWS("*")) {
            return new AST(100);
        }
        return null;
    }

    private AST nameTest() throws Tokenizer.TokenizerException {
        AST test = this.wildcard();
        AST aST = test = test != null ? test : this.eqnameLiteral(true, true);
        if (test == null) {
            return null;
        }
        AST nameTest = new AST(99);
        nameTest.addChild(test);
        return nameTest;
    }

    private AST wildcard() {
        Tokenizer.Token la = this.laSkipWS("*:");
        if (la != null) {
            Tokenizer.Token la2 = this.laNCName(la);
            if (la2 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            return new AST(110, la2.string());
        }
        if (this.attemptSkipWS("*")) {
            return new AST(100);
        }
        la = this.laNCNameSkipWS();
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.la(la, ":*");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        return new AST(111, la.string());
    }

    private AST[] predicateList() throws Tokenizer.TokenizerException {
        AST predicate;
        AST[] predicates = new AST[]{};
        while ((predicate = this.predicate()) != null) {
            predicates = this.add(predicates, predicate);
        }
        return predicates;
    }

    private AST predicate() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("[")) {
            return null;
        }
        AST pred = new AST(205);
        pred.addChild(this.expr());
        this.consumeSkipWS("]");
        return pred;
    }

    private AST validateExpr() throws Tokenizer.TokenizerException {
        AST mode;
        Tokenizer.Token la = this.laSymSkipWS("validate");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSymSkipWS(la, "lax");
        if (la2 != null) {
            this.consume(la);
            this.consume(la2);
            mode = new AST(144);
            this.consumeSkipWS("{");
        } else {
            la2 = this.laSymSkipWS(la, "strict");
            if (la2 != null) {
                this.consume(la);
                this.consume(la2);
                mode = new AST(145);
                this.consumeSkipWS("{");
            } else {
                la2 = this.laSymSkipWS(la, "strict");
                if (la2 != null) {
                    this.consume(la);
                    this.consume(la2);
                    mode = this.eqnameLiteral(false, true);
                    this.consumeSkipWS("{");
                } else {
                    la2 = this.laSkipWS(la, "{");
                    if (la2 != null) {
                        this.consume(la);
                        this.consume(la2);
                        mode = new AST(145);
                    } else {
                        return null;
                    }
                }
            }
        }
        AST vExpr = new AST(143);
        vExpr.addChild(mode);
        vExpr.addChild(this.expr());
        this.consumeSkipWS("}");
        return vExpr;
    }

    private AST postFixExpr() throws Tokenizer.TokenizerException {
        AST expr = this.primaryExpr();
        if (expr == null) {
            return null;
        }
        while (true) {
            AST deref;
            if ((deref = this.derefStep()) != null) {
                AST derefExpr = new AST(252);
                derefExpr.addChild(expr);
                derefExpr.addChild(deref);
                expr = derefExpr;
                continue;
            }
            AST index = this.index();
            if (index != null) {
                AST arrayAccess = new AST(243);
                arrayAccess.addChild(expr);
                arrayAccess.addChild(index);
                expr = arrayAccess;
                continue;
            }
            AST[] projectionList = this.projectionList();
            if (projectionList != null && projectionList.length > 0) {
                AST projectionExpr = new AST(248);
                projectionExpr.addChild(expr);
                projectionExpr.addChildren(projectionList);
                expr = projectionExpr;
                continue;
            }
            AST predicate = this.predicate();
            if (predicate != null) {
                AST filterExpr = new AST(206);
                filterExpr.addChild(expr);
                filterExpr.addChild(predicate);
                expr = filterExpr;
                continue;
            }
            AST[] argumentList = this.argumentList();
            if (argumentList == null || argumentList.length <= 0) break;
            AST dynFuncCallExpr = new AST(207);
            dynFuncCallExpr.addChild(expr);
            dynFuncCallExpr.addChildren(argumentList);
            expr = dynFuncCallExpr;
        }
        return expr;
    }

    private AST[] argumentList() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("(")) {
            return null;
        }
        AST[] args = new AST[]{};
        while (!this.attemptSkipWS(")")) {
            if (args.length > 0) {
                this.consumeSkipWS(",");
            }
            args = this.add(args, this.argument());
        }
        return args;
    }

    private AST primaryExpr() throws Tokenizer.TokenizerException {
        AST expr = this.literal();
        expr = expr != null ? expr : this.varRef();
        expr = expr != null ? expr : this.parenthesizedExpr();
        expr = expr != null ? expr : this.contextItemExpr();
        expr = expr != null ? expr : this.functionCall();
        expr = expr != null ? expr : this.orderedExpr();
        expr = expr != null ? expr : this.unorderedExpr();
        expr = expr != null ? expr : this.constructor();
        expr = expr != null ? expr : this.functionItemExpr();
        return expr;
    }

    private AST literal() throws Tokenizer.TokenizerException {
        AST lit = this.numericLiteral();
        if (lit != null) {
            return lit;
        }
        Tokenizer.Token la = this.laStringSkipWS(true);
        if (la == null) {
            return null;
        }
        this.consume(la);
        return new AST(118, new Str(la.string()));
    }

    private AST varRef() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("$")) {
            return null;
        }
        QNm varName = this.eqname(false, true);
        return new AST(26, varName);
    }

    private AST parenthesizedExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("(");
        if (la == null || this.la(la, "#") != null) {
            return null;
        }
        AST expr = new AST(112);
        this.consume(la);
        if (this.attemptSkipWS(")")) {
            return expr;
        }
        expr.addChild(this.expr());
        this.consumeSkipWS(")");
        return expr;
    }

    private AST contextItemExpr() {
        Tokenizer.Token la = this.laSkipWS(".");
        if (la == null || this.la(la, ".") != null) {
            return null;
        }
        this.consume(la);
        return new AST(113);
    }

    private AST functionCall() throws Tokenizer.TokenizerException {
        Tokenizer.EQNameToken la = this.laEQNameSkipWS(true);
        if (la == null) {
            return null;
        }
        String funcName = la.string();
        if (this.isReservedFuncName(funcName)) {
            return null;
        }
        if (this.laSkipWS(la, "(") == null) {
            return null;
        }
        this.consume(la);
        AST call = new AST(80, la.qname());
        call.addChildren(this.argumentList());
        return call;
    }

    private AST argument() throws Tokenizer.TokenizerException {
        if (this.attempt("?")) {
            return new AST(114);
        }
        return this.exprSingle();
    }

    private boolean isReservedFuncName(String string) {
        for (String fun : RESERVED_FUNC_NAMES) {
            if (!fun.equals(string)) continue;
            return true;
        }
        return false;
    }

    private AST orderedExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("ordered");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "{");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST expr = this.expr();
        this.consumeSkipWS("}");
        AST orderedExpr = new AST(115);
        orderedExpr.addChild(expr);
        return orderedExpr;
    }

    private AST unorderedExpr() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("unordered");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "{");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST expr = this.expr();
        this.consumeSkipWS("}");
        AST unorderedExpr = new AST(116);
        unorderedExpr.addChild(expr);
        return unorderedExpr;
    }

    private AST constructor() throws Tokenizer.TokenizerException {
        AST con = this.directConstructor(false);
        con = con != null ? con : this.computedConstructor();
        con = con != null ? con : this.arrayConstructor();
        con = con != null ? con : this.recordConstructor();
        return con;
    }

    private AST directConstructor(boolean nested) throws Tokenizer.TokenizerException {
        AST con = this.dirElemConstructor(nested);
        con = con != null ? con : this.dirCommentConstructor(nested);
        con = con != null ? con : this.dirPIConstructor(nested);
        return con;
    }

    private AST dirElemConstructor(boolean nested) throws Tokenizer.TokenizerException {
        AST att;
        if (nested ? this.la("</") != null || this.la("<?") != null || this.la("<!") != null || !this.attempt("<") : this.laSkipWS("</") != null || this.laSkipWS("<?") != null || this.laSkipWS("<!") != null || !this.attemptSkipWS("<")) {
            return null;
        }
        AST stag = this.qnameLiteral(false, false);
        assert (stag != null);
        QNm name = (QNm)stag.getValue();
        AST elem = new AST(154);
        elem.addChild(stag);
        AST cseq = new AST(152);
        elem.addChild(cseq);
        while ((att = this.dirAttribute(true)) != null) {
            cseq.addChild(att);
        }
        this.skipS();
        if (!this.attempt("/>")) {
            AST content;
            this.consume(">");
            boolean checkBoundaryWS = true;
            while ((content = this.dirElementContent(checkBoundaryWS)) != null) {
                cseq.addChild(content);
                checkBoundaryWS = content.getType() == 154 || content.getType() == 156 || content.getType() == 157 || content.getType() == 153;
            }
            this.consume("</");
            this.skipS();
            Tokenizer.EQNameToken la = this.laQName();
            if (la == null || !la.string().equals(name.toString())) {
                throw new IllegalNestingException(name.toString());
            }
            this.consume(la);
            this.skipS();
            this.consume(">");
        }
        return elem;
    }

    private AST dirAttribute(boolean expand) throws Tokenizer.TokenizerException {
        this.skipS();
        AST attName = this.qnameLiteral(true, false);
        if (attName == null) {
            return null;
        }
        this.skipS();
        this.consume("=");
        this.skipS();
        AST att = new AST(155);
        att.addChild(attName);
        AST cseq = new AST(152);
        att.addChild(cseq);
        if (this.attempt("\"")) {
            AST val;
            while ((val = this.quotAttrValue()) != null) {
                cseq.addChild(val);
            }
            this.consume("\"");
        } else {
            AST val;
            this.consume("'");
            while ((val = this.aposAttrValue()) != null) {
                cseq.addChild(val);
            }
            this.consume("'");
        }
        return att;
    }

    private AST quotAttrValue() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.la("\"");
        if (la != null) {
            if (this.la(la, "\"") != null) {
                this.consume("\"\"");
                return new AST(118, "\"");
            }
            return null;
        }
        return this.quotAttrValueContent();
    }

    private AST quotAttrValueContent() throws Tokenizer.TokenizerException {
        Tokenizer.Token content = this.laQuotAttrContentChar();
        if (content != null) {
            this.consume(content);
            return new AST(118, content.string());
        }
        return this.commonContent();
    }

    private AST aposAttrValue() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.la("'");
        if (la != null) {
            if (this.la(la, "'") != null) {
                this.consume("''");
                return new AST(118, "'");
            }
            return null;
        }
        return this.aposAttrValueContent();
    }

    private AST aposAttrValueContent() throws Tokenizer.TokenizerException {
        Tokenizer.Token content = this.laAposAttrContentChar();
        if (content != null) {
            this.consume(content);
            return new AST(118, content.string());
        }
        return this.commonContent();
    }

    private AST commonContent() throws Tokenizer.TokenizerException {
        Tokenizer.Token c = this.laPredefEntityRef(false);
        c = c != null ? c : this.laCharRef(false);
        Tokenizer.Token token = c = c != null ? c : this.laEscapeCurly();
        if (c != null) {
            this.consume(c);
            return new AST(118, c.string());
        }
        return this.enclosedExpr(false);
    }

    private AST dirElementContent(boolean checkBoundaryWS) throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        if (checkBoundaryWS && ((la = this.laSkipS("<")) != null || (la = this.laSkipS("{")) != null && this.la(la, "{") == null) && (la = this.laS()) != null) {
            this.consume(la);
            AST boundaryWS = new AST(118, la.string());
            boundaryWS.setProperty("boundaryWS", true);
            return boundaryWS;
        }
        AST c = this.directConstructor(true);
        c = c != null ? c : this.cDataSection();
        c = c != null ? c : this.commonContent();
        c = c != null ? c : this.elementContentChar();
        return c;
    }

    private AST cDataSection() throws Tokenizer.TokenizerException {
        if (!this.attempt("<![CDATA[")) {
            return null;
        }
        Tokenizer.Token content = this.laCDataSectionContents();
        this.consume(content);
        this.consume("]]>");
        return new AST(118, content.string());
    }

    private AST elementContentChar() {
        Tokenizer.Token content = this.laElemContentChar();
        if (content == null) {
            return null;
        }
        this.consume(content);
        return new AST(118, content.string());
    }

    private AST dirCommentConstructor(boolean nested) throws Tokenizer.TokenizerException {
        if (nested ? !this.attempt("<!--") : !this.attemptSkipWS("<!--")) {
            return null;
        }
        Tokenizer.Token content = this.laCommentContents(false);
        this.consume(content);
        this.consume("-->");
        AST comment = new AST(156);
        comment.addChild(new AST(118, content.string()));
        return comment;
    }

    private AST dirPIConstructor(boolean nested) throws Tokenizer.TokenizerException {
        if (nested ? !this.attempt("<?") : !this.attemptSkipWS("<?")) {
            return null;
        }
        Tokenizer.Token target = this.laPITarget(false);
        this.consume(target);
        AST piCon = new AST(157);
        piCon.addChild(new AST(118, target.string()));
        if (this.skipS()) {
            Tokenizer.Token content = this.laPIContents();
            this.consume(content);
            piCon.addChild(new AST(118, content.string()));
        }
        this.consume("?>");
        return piCon;
    }

    private AST computedConstructor() throws Tokenizer.TokenizerException {
        AST c = this.compDocConstructor();
        c = c != null ? c : this.compElemConstructor();
        c = c != null ? c : this.compAttrConstructor();
        c = c != null ? c : this.compNamespaceConstructor();
        c = c != null ? c : this.compTextConstructor();
        c = c != null ? c : this.compCommentConstructor();
        c = c != null ? c : this.compPIConstructor();
        return c;
    }

    private AST compDocConstructor() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("document");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "{");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST doc = new AST(158);
        doc.addChild(this.expr());
        this.consumeSkipWS("}");
        return doc;
    }

    private AST compElemConstructor() throws Tokenizer.TokenizerException {
        AST elem;
        Tokenizer.Token la = this.laSkipWS("element");
        if (la == null) {
            return null;
        }
        Tokenizer.EQNameToken la2 = this.laEQNameSkipWS(la, true);
        if (la2 != null) {
            la3 = this.laSkipWS(la2, "{");
            if (la3 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            this.consume(la3);
            elem = new AST(149);
            QNm qname = la2.qname();
            elem.addChild(new AST(119, qname));
        } else {
            la3 = this.laSkipWS(la, "{");
            if (la3 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la3);
            elem = new AST(149);
            elem.addChild(this.expr());
            this.consumeSkipWS("}");
            this.consumeSkipWS("{");
        }
        AST conSeq = new AST(152);
        elem.addChild(conSeq);
        if (!this.attemptSkipWS("}")) {
            AST expr = this.expr();
            if (expr != null) {
                conSeq.addChild(expr);
            }
            this.consumeSkipWS("}");
        }
        return elem;
    }

    private AST compAttrConstructor() throws Tokenizer.TokenizerException {
        AST attr;
        Tokenizer.Token la = this.laSkipWS("attribute");
        if (la == null) {
            return null;
        }
        Tokenizer.EQNameToken la2 = this.laEQNameSkipWS(la, true);
        if (la2 != null) {
            la3 = this.laSkipWS(la2, "{");
            if (la3 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            this.consume(la3);
            attr = new AST(150);
            QNm qname = la2.qname();
            attr.addChild(new AST(119, qname));
        } else {
            la3 = this.laSkipWS(la, "{");
            if (la3 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la3);
            attr = new AST(150);
            attr.addChild(this.expr());
            this.consumeSkipWS("}");
            this.consumeSkipWS("{");
        }
        AST conSeq = new AST(152);
        attr.addChild(conSeq);
        if (!this.attemptSkipWS("}")) {
            AST expr = this.expr();
            if (expr != null) {
                conSeq.addChild(expr);
            }
            this.consumeSkipWS("}");
        }
        return attr;
    }

    private AST compNamespaceConstructor() throws Tokenizer.TokenizerException {
        AST ns;
        Tokenizer.Token la = this.laSkipWS("namespace");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laNCName(la);
        if (la2 != null) {
            Tokenizer.Token la3 = this.laSkipWS(la2, "{");
            if (la3 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            this.consume(la3);
            ns = new AST(203);
            ns.addChild(new AST(118, la2.string()));
        } else {
            la2 = this.laSkipWS(la, "{");
            if (la2 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            ns = new AST(203);
            ns.addChild(this.expr());
            this.consumeSkipWS("}");
            this.consumeSkipWS("{");
        }
        if (!this.attemptSkipWS("}")) {
            AST expr = this.expr();
            if (expr != null) {
                ns.addChild(expr);
            }
            this.consumeSkipWS("}");
        }
        return ns;
    }

    private AST compTextConstructor() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("text");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "{");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST doc = new AST(159);
        doc.addChild(this.expr());
        this.consumeSkipWS("}");
        return doc;
    }

    private AST compCommentConstructor() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("comment");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "{");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST doc = new AST(151);
        doc.addChild(this.expr());
        this.consumeSkipWS("}");
        return doc;
    }

    private AST compPIConstructor() throws Tokenizer.TokenizerException {
        AST pi;
        Tokenizer.Token la = this.laSkipWS("processing-instruction");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laNCNameSkipWS(la);
        if (la2 != null) {
            Tokenizer.Token la3 = this.laSkipWS(la2, "{");
            if (la3 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            this.consume(la3);
            pi = new AST(204);
            pi.addChild(new AST(118, la2.string()));
        } else {
            la2 = this.laSkipWS(la, "{");
            if (la2 == null) {
                return null;
            }
            this.consume(la);
            this.consume(la2);
            pi = new AST(204);
            pi.addChild(this.expr());
            this.consumeSkipWS("}");
            this.consumeSkipWS("{");
        }
        if (!this.attemptSkipWS("}")) {
            AST expr = this.expr();
            if (expr != null) {
                pi.addChild(expr);
            }
            this.consumeSkipWS("}");
        }
        return pi;
    }

    private AST functionItemExpr() throws Tokenizer.TokenizerException {
        AST funcItem = this.literalFunctionItem();
        funcItem = funcItem != null ? funcItem : this.inlineFunction();
        return funcItem;
    }

    private AST literalFunctionItem() throws Tokenizer.TokenizerException {
        Tokenizer.EQNameToken la = this.laEQNameSkipWS(true);
        if (la == null) {
            return null;
        }
        String funcName = la.string();
        if (this.isReservedFuncName(funcName)) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS("#");
        if (la2 == null) {
            return null;
        }
        AST eqname = new AST(119, la.qname());
        this.consume(la);
        this.consume(la2);
        AST no = this.integerLiteral(false, true);
        AST litFunc = new AST(146);
        litFunc.addChild(eqname);
        litFunc.addChild(no);
        return litFunc;
    }

    private AST inlineFunction() throws Tokenizer.TokenizerException {
        AST param;
        Tokenizer.Token la = this.laSkipWS("function");
        if (la == null) {
            return null;
        }
        Tokenizer.Token la2 = this.laSkipWS(la, "(");
        if (la2 == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST inlineFunc = new AST(147);
        while ((param = this.param()) != null) {
            inlineFunc.addChild(param);
            if (this.attemptSkipWS(",")) continue;
        }
        this.consumeSkipWS(")");
        if (this.attemptSymSkipWS("as")) {
            inlineFunc.addChild(this.sequenceType());
        } else {
            AST typeDecl = this.defaultFunctionResultType();
            inlineFunc.addChild(typeDecl);
        }
        inlineFunc.addChild(this.enclosedExpr(true));
        return inlineFunc;
    }

    private AST enclosedExpr(boolean skipWS) throws Tokenizer.TokenizerException {
        if (skipWS ? !this.attemptSkipWS("{") : !this.attempt("{")) {
            return null;
        }
        AST expr = new AST(153);
        expr.addChild(this.expr());
        this.consumeSkipWS("}");
        return expr;
    }

    private AST param() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("$")) {
            return null;
        }
        QNm varName = this.eqname(false, true);
        AST decl = new AST(148);
        decl.addChild(new AST(11, varName));
        AST typeDecl = this.typeDeclaration();
        if (typeDecl != null) {
            decl.addChild(typeDecl);
        }
        return decl;
    }

    private AST stringLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        Tokenizer.Token token = la = skipWS ? this.laStringSkipWS(cond) : this.laString(cond);
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected string literal: '%s'", this.paraphrase());
        }
        this.consume(la);
        return new AST(118, new Str(la.string()));
    }

    private AST uriLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        Tokenizer.Token token = la = skipWS ? this.laStringSkipWS(cond) : this.laString(cond);
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected URI literal: '%s'", this.paraphrase());
        }
        this.consume(la);
        try {
            return new AST(122, new AnyURI(la.string()));
        }
        catch (QueryException e) {
            throw new InvalidURIException(la.string());
        }
    }

    private AST numericLiteral() throws Tokenizer.TokenizerException {
        AST lit = this.integerLiteral(true, true);
        lit = lit != null ? lit : this.decimalLiteral(true, true);
        lit = lit != null ? lit : this.doubleLiteral(true, true);
        return lit;
    }

    private AST ncnameLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        Tokenizer.Token token = la = skipWS ? this.laNCNameSkipWS() : this.laNCName();
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected NCName: '%s'", this.paraphrase());
        }
        this.consume(la);
        return new AST(118, la.string());
    }

    private QNm eqname(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.EQNameToken la;
        Tokenizer.EQNameToken eQNameToken = la = skipWS ? this.laEQNameSkipWS(cond) : this.laEQName(cond);
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected QName: '%s'", this.paraphrase());
        }
        this.consume(la);
        return la.qname();
    }

    private AST eqnameLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.EQNameToken la;
        Tokenizer.EQNameToken eQNameToken = la = skipWS ? this.laEQNameSkipWS(cond) : this.laEQName(cond);
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected QName: '%s'", this.paraphrase());
        }
        this.consume(la);
        return new AST(119, la.qname());
    }

    private AST qnameLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.EQNameToken la;
        Tokenizer.EQNameToken eQNameToken = la = skipWS ? this.laQNameSkipWS() : this.laQName();
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected QName: '%s'", this.paraphrase());
        }
        this.consume(la);
        return new AST(119, la.qname());
    }

    private AST doubleLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        Tokenizer.Token token = la = skipWS ? this.laDoubleSkipWS(cond) : this.laDouble(cond);
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected double literal: '%s'", this.paraphrase());
        }
        this.consume(la);
        try {
            return new AST(120, new Dbl(la.string()));
        }
        catch (QueryException e) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, e, "Error parsing double literal: '%s'", this.paraphrase());
        }
    }

    private AST decimalLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        Tokenizer.Token token = la = skipWS ? this.laDecimalSkipWS(cond) : this.laDecimal(cond);
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected decimal literal: '%s'", this.paraphrase());
        }
        this.consume(la);
        try {
            return new AST(121, new Dec(la.string()));
        }
        catch (QueryException e) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, e, "Error parsing decimal literal: '%s'", this.paraphrase());
        }
    }

    private AST integerLiteral(boolean cond, boolean skipWS) throws Tokenizer.TokenizerException {
        Tokenizer.Token la;
        Tokenizer.Token token = la = skipWS ? this.laIntegerSkipWS(cond) : this.laInteger(cond);
        if (la == null) {
            if (cond) {
                return null;
            }
            throw new Tokenizer.TokenizerException((Tokenizer)this, "Expected integer literal: '%s'", this.paraphrase());
        }
        this.consume(la);
        try {
            return new AST(117, Int32.parse(la.string()));
        }
        catch (QueryException e) {
            throw new Tokenizer.TokenizerException((Tokenizer)this, e, "Error parsing integer literal: '%s'", this.paraphrase());
        }
    }

    private AST pragmaContent() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laPragma(false);
        this.consume(la);
        return la == null ? null : new AST(142, la.string());
    }

    private AST index() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("[[")) {
            return null;
        }
        if (this.laSkipWS("]]") != null) {
            AST sequence = new AST(6);
            this.consumeSkipWS("]]");
            return sequence;
        }
        AST index = this.exprSingle();
        this.consumeSkipWS("]]");
        return index;
    }

    private AST arrayConstructor() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("[")) {
            return null;
        }
        AST array = new AST(244);
        Tokenizer.Token emptyArray = this.laSkipWS("]");
        if (emptyArray == null) {
            do {
                AST f = new AST(this.attemptSkipS("=") ? 246 : 245);
                if (this.attemptSymSkipWS("true()")) {
                    f.addChild(new AST(123, Bool.TRUE));
                } else if (this.attemptSymSkipWS("false()")) {
                    f.addChild(new AST(123, Bool.FALSE));
                } else if (this.attemptSymSkipWS("jn:null()")) {
                    f.addChild(new AST(80, new QNm("http://brackit.org/ns/json", "jn", "null")));
                } else {
                    f.addChild(this.exprSingle());
                }
                array.addChild(f);
            } while (this.attemptSkipWS(","));
        }
        this.consumeSkipWS("]");
        return array;
    }

    private AST derefStep() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipS("=>")) {
            return null;
        }
        Tokenizer.Token la = this.laStringSkipWS(true);
        if (la != null) {
            this.consume(la);
            return new AST(119, new QNm(null, null, la.string()));
        }
        Tokenizer.EQNameToken la2 = this.laEQNameSkipWS(true);
        if (la2 != null) {
            this.consume(la2);
            return new AST(119, la2.qname());
        }
        return this.stepExpr();
    }

    private AST recordConstructor() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("{")) {
            return null;
        }
        AST record = new AST(249);
        Tokenizer.Token objectConstructor = this.la("|");
        if (objectConstructor != null) {
            this.consume(objectConstructor);
            AST expr = this.expr();
            if (expr.getType() == 6) {
                int childCount = expr.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    AST field = new AST(250);
                    field.addChild(expr.getChild(i));
                    record.addChild(field);
                }
            } else {
                AST field = new AST(250);
                field.addChild(expr);
                record.addChild(field);
            }
        } else {
            Tokenizer.Token emptyRecord = this.laSkipWS("}");
            if (emptyRecord == null) {
                do {
                    AST field;
                    AST key = this.exprSingle();
                    boolean hasColon = this.attemptSkipWS(":");
                    if (hasColon) {
                        AST value = this.exprSingle();
                        field = new AST(251);
                        field.addChild(key);
                        field.addChild(value);
                    } else {
                        field = new AST(250);
                        field.addChild(key);
                    }
                    record.addChild(field);
                } while (this.attemptSkipWS(","));
            }
        }
        if (objectConstructor != null) {
            this.consumeSkipWS("|");
        }
        this.consumeSkipWS("}");
        return record;
    }

    private AST[] projectionList() throws Tokenizer.TokenizerException {
        if (!this.attemptSkipWS("{")) {
            return null;
        }
        AST[] args = new AST[]{};
        do {
            Tokenizer.Token la;
            if ((la = this.laStringSkipWS(true)) != null) {
                this.consume(la);
                args = this.add(args, new AST(119, new QNm(null, null, la.string())));
                continue;
            }
            Tokenizer.EQNameToken la2 = this.laEQNameSkipWS(true);
            if (la2 != null) {
                this.consume(la2);
                args = this.add(args, new AST(119, la2.qname()));
                continue;
            }
            args = this.add(args, this.exprSingle());
        } while (this.attemptSkipWS(","));
        this.consumeSkipWS("}");
        return args;
    }

    private AST assignmentClause() throws Tokenizer.TokenizerException {
        Tokenizer.Token la = this.laSkipWS("$");
        if (la == null) {
            return null;
        }
        Tokenizer.EQNameToken la2 = this.laEQName(la, true);
        if (la2 == null) {
            return null;
        }
        if (this.laSymSkipWS(la2, "as") == null && this.laSkipWS(la2, ":=") == null) {
            return null;
        }
        this.consume(la);
        this.consume(la2);
        AST ass = new AST(12);
        AST binding = new AST(10);
        binding.addChild(new AST(11, la2.qname()));
        AST typeDecl = this.typeDeclaration();
        if (typeDecl != null) {
            binding.addChild(typeDecl);
        }
        ass.addChild(binding);
        this.consumeSkipWS(":=");
        ass.addChild(this.concatExpr());
        return ass;
    }

    private AST[] add(AST[] asts, AST ast) {
        int len = asts.length;
        asts = Arrays.copyOf(asts, len + 1);
        asts[len] = ast;
        return asts;
    }

    public class InvalidURIException
    extends Tokenizer.TokenizerException {
        private final String uri;

        public InvalidURIException(String uri) {
            super((Tokenizer)XQParser.this, "Invalid uri literal '%s': %s", uri, XQParser.this.paraphrase());
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }
    }

    public class IllegalNestingException
    extends Tokenizer.TokenizerException {
        private final String expected;

        public IllegalNestingException(String expected) {
            super((Tokenizer)XQParser.this, "Expected closing tag <%s/>: '%s'", expected, XQParser.this.paraphrase());
            this.expected = expected;
        }

        public String getExpected() {
            return this.expected;
        }
    }
}

