/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.profiler;

import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.compiler.profiler.ProfilingNode;
import org.brackit.xquery.sequence.AbstractSequence;
import org.brackit.xquery.sequence.BaseIter;
import org.brackit.xquery.util.dot.DotNode;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;

public class ProfileExpr
extends ProfilingNode
implements Expr {
    private Expr e;
    private long itemTotal;
    private int itemCnt;
    private long seqTotal;
    private int seqCnt;
    private int seqIterCnt;
    private long seqIterTotal;
    private int seqDeliverCnt;
    private int seqSkipCnt;
    private long seqSkipTotal;
    private int evalBooleanValue;
    private int evalSize;
    private int evalGet;

    ProfileExpr() {
    }

    void setExpr(Expr e) {
        this.e = e;
    }

    @Override
    protected void addFields(DotNode node) {
        node.addRow("expression", this.e.toString());
        node.addRow("eval (item)", this.itemCnt);
        node.addRow("total / avg. time eval (item) [ms]", this.itemTotal / 1000000L);
        node.addRow("avg. time eval (item) [ms]", this.itemCnt > 0 ? (double)this.itemTotal / (1000000.0 * (double)this.itemCnt) : -1.0);
        node.addRow("eval (seq)", this.seqCnt);
        node.addRow("total time eval (seq) [ms]", this.seqTotal / 1000000L);
        node.addRow("avg. time eval (seq) [ms]", this.seqCnt > 0 ? (double)this.seqTotal / (1000000.0 * (double)this.seqCnt) : -1.0);
        node.addRow("eval bool  (seq)", this.evalBooleanValue);
        node.addRow("eval size (seq)", this.evalSize);
        node.addRow("eval get (seq)", this.evalGet);
        node.addRow("iter (seq)", this.seqIterCnt);
        node.addRow("skip (seq)", this.seqSkipCnt);
        node.addRow("delivered by iter (seq)", this.seqDeliverCnt);
        node.addRow("total time iter (seq) [ms]", this.seqIterTotal / 1000000L);
        node.addRow("avg. time iter (seq) [ms]", this.seqIterCnt > 0 ? (double)this.seqIterTotal / (1000000.0 * (double)this.seqIterCnt) : -1.0);
        node.addRow("total time skip (seq) [ms]", this.seqSkipTotal / 1000000L);
    }

    @Override
    protected String getName() {
        return this.e.getClass().getSimpleName() + "_" + this.id;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        long start = System.nanoTime();
        Sequence s = this.e.evaluate(ctx, tuple);
        long end = System.nanoTime();
        this.seqTotal += end - start;
        ++this.seqCnt;
        return new StatSequence(s);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        long start = System.nanoTime();
        Item i = this.e.evaluateToItem(ctx, tuple);
        long end = System.nanoTime();
        this.itemTotal += end - start;
        ++this.itemCnt;
        return i;
    }

    public String toString() {
        return this.e.getClass().getSimpleName();
    }

    @Override
    public boolean isUpdating() {
        return this.e.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return this.e.isVacuous();
    }

    private class StatSequence
    extends AbstractSequence {
        final Sequence s;

        public StatSequence(Sequence s) {
            this.s = s;
        }

        @Override
        public boolean booleanValue() throws QueryException {
            ++ProfileExpr.this.evalBooleanValue;
            return this.s != null && this.s.booleanValue();
        }

        @Override
        public Iter iterate() {
            ++ProfileExpr.this.seqIterCnt;
            return this.s != null ? new StatIter(this.s.iterate()) : new StatIter(new BaseIter(){

                @Override
                public void close() {
                }

                @Override
                public Item next() throws QueryException {
                    return null;
                }
            });
        }

        @Override
        public IntNumeric size() throws QueryException {
            ++ProfileExpr.this.evalSize;
            return this.s != null ? this.s.size() : Int32.ZERO;
        }

        @Override
        public Item get(IntNumeric pos) throws QueryException {
            ++ProfileExpr.this.evalGet;
            return this.s != null ? this.s.get(pos) : null;
        }
    }

    private class StatIter
    implements Iter {
        final Iter it;
        int delivered;
        int skipCnt;
        long time;
        long skipTime;

        StatIter(Iter it) {
            this.it = it;
        }

        @Override
        public Item next() throws QueryException {
            long start = System.nanoTime();
            Item item = this.it.next();
            long end = System.nanoTime();
            if (item != null) {
                ++this.delivered;
            }
            this.time += end - start;
            return item;
        }

        @Override
        public void skip(IntNumeric i) throws QueryException {
            long start = System.nanoTime();
            this.it.skip(i);
            long end = System.nanoTime();
            this.skipTime += end - start;
            ++this.skipCnt;
        }

        @Override
        public void close() {
            this.it.close();
            ProfileExpr.this.seqIterTotal += this.time;
            ProfileExpr.this.seqDeliverCnt += this.delivered;
            ProfileExpr.this.seqSkipCnt += this.skipCnt;
            ProfileExpr.this.seqSkipTotal += this.skipTime;
        }
    }
}

