/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.profiler;

import java.util.concurrent.atomic.AtomicInteger;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.compiler.profiler.ProfilingNode;
import org.brackit.xquery.operator.Cursor;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.util.dot.DotNode;

public class ProfileOperator
extends ProfilingNode
implements Operator {
    private static final AtomicInteger idSource = new AtomicInteger(1);
    private final int id = idSource.getAndIncrement();
    private Operator op;
    private long total;
    private int openCnt;
    private int closeCnt;
    private int deliverCnt;

    public void setOp(Operator op) {
        this.op = op;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        return new StatOpCursor(this.op.create(ctx, tuple));
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        return new StatOpCursor(this.op.create(ctx, buf, len));
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.op.tupleWidth(initSize);
    }

    public String toString() {
        return this.op.getClass().getSimpleName();
    }

    @Override
    protected void addFields(DotNode node) {
        node.addRow("operator", this.op.getClass().getSimpleName());
        node.addRow("open / close", this.openCnt + " /" + this.closeCnt);
        node.addRow("delivered", this.deliverCnt);
        node.addRow("total time [ms]", this.total / 1000000L);
        node.addRow("avg. time [ms]", this.deliverCnt > 0 ? (double)this.total / (double)(1000000 * this.deliverCnt) : -1.0);
    }

    @Override
    protected String getName() {
        return this.op.getClass().getSimpleName() + "_" + this.id;
    }

    private class StatOpCursor
    implements Cursor {
        final Cursor c;
        long time;

        public StatOpCursor(Cursor c) {
            this.c = c;
        }

        @Override
        public void close(QueryContext ctx) {
            this.c.close(ctx);
            ++ProfileOperator.this.closeCnt;
            ProfileOperator.this.total += this.time;
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            long start = System.nanoTime();
            Tuple next = this.c.next(ctx);
            long end = System.nanoTime();
            this.time += end - start;
            if (next != null) {
                ++ProfileOperator.this.deliverCnt;
            }
            return next;
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            ++ProfileOperator.this.openCnt;
            this.c.open(ctx);
        }
    }
}

