/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.profiler;

import java.io.File;
import java.util.Map;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.XQuery;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.profiler.ProfileExpr;
import org.brackit.xquery.compiler.profiler.ProfileOperator;
import org.brackit.xquery.compiler.profiler.ProfilingNode;
import org.brackit.xquery.compiler.translator.TopDownTranslator;
import org.brackit.xquery.module.MainModule;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.util.dot.DotContext;
import org.brackit.xquery.xdm.Expr;

public class ProfilingCompiler
extends TopDownTranslator {
    public static final String PLOT_TYPE = "svg";
    private ProfilingNode parent;
    private ProfilingNode child;
    private ProfileOperator pending;

    public ProfilingCompiler(Map<QNm, Str> options) {
        super(options);
    }

    @Override
    protected Expr anyExpr(AST node) throws QueryException {
        ProfileExpr profileExpr = new ProfileExpr();
        ProfilingNode savedParent = this.parent;
        this.parent = profileExpr;
        Expr e = super.anyExpr(node);
        profileExpr.setExpr(e);
        this.parent = savedParent;
        if (this.parent != null) {
            this.parent.addChild(profileExpr);
        }
        return profileExpr;
    }

    @Override
    protected Operator anyOp(Operator in, AST node) throws QueryException {
        ProfileOperator profileOp = new ProfileOperator();
        ProfilingNode savedParent = this.parent;
        this.parent = profileOp;
        Operator op = super.anyOp(in, node);
        profileOp.setOp(op);
        this.parent = savedParent;
        if (this.parent != null) {
            this.parent.addChild(profileOp);
        }
        return profileOp;
    }

    public static void visualize(XQuery xq, String outputDir) {
        DotContext dotCtx = new DotContext();
        ((ProfileExpr)((MainModule)xq.getModule()).getBody()).toDot(dotCtx);
        ProfilingCompiler.createDot(outputDir, "expr", dotCtx);
    }

    private static void createDot(String outputDir, String name, DotContext dotCtx) {
        try {
            File f = File.createTempFile(name, "dot");
            dotCtx.write(f);
            f.deleteOnExit();
            String outfile = outputDir + "/" + name + "s.svg";
            String command = "dot -Tsvg -o" + outfile + " " + f;
            Process proc = Runtime.getRuntime().exec(command);
            proc.waitFor();
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

