/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.translator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.Bool;
import org.brackit.xquery.atomic.Int32;
import org.brackit.xquery.atomic.Null;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.Bits;
import org.brackit.xquery.compiler.translator.Binding;
import org.brackit.xquery.compiler.translator.Translator;
import org.brackit.xquery.compiler.translator.VariableTable;
import org.brackit.xquery.expr.Accessor;
import org.brackit.xquery.expr.AndExpr;
import org.brackit.xquery.expr.ArithmeticExpr;
import org.brackit.xquery.expr.ArrayAccessExpr;
import org.brackit.xquery.expr.ArrayExpr;
import org.brackit.xquery.expr.AttributeExpr;
import org.brackit.xquery.expr.Cast;
import org.brackit.xquery.expr.Castable;
import org.brackit.xquery.expr.CommentExpr;
import org.brackit.xquery.expr.DerefExpr;
import org.brackit.xquery.expr.DocumentExpr;
import org.brackit.xquery.expr.ElementExpr;
import org.brackit.xquery.expr.EmptyExpr;
import org.brackit.xquery.expr.ExceptExpr;
import org.brackit.xquery.expr.FilterExpr;
import org.brackit.xquery.expr.GCmpExpr;
import org.brackit.xquery.expr.IfExpr;
import org.brackit.xquery.expr.InstanceOf;
import org.brackit.xquery.expr.IntersectExpr;
import org.brackit.xquery.expr.NodeCmpExpr;
import org.brackit.xquery.expr.OrExpr;
import org.brackit.xquery.expr.PIExpr;
import org.brackit.xquery.expr.PathStepExpr;
import org.brackit.xquery.expr.PipeExpr;
import org.brackit.xquery.expr.ProjectionExpr;
import org.brackit.xquery.expr.RangeExpr;
import org.brackit.xquery.expr.RecordExpr;
import org.brackit.xquery.expr.SequenceExpr;
import org.brackit.xquery.expr.StepExpr;
import org.brackit.xquery.expr.SwitchExpr;
import org.brackit.xquery.expr.TextExpr;
import org.brackit.xquery.expr.Treat;
import org.brackit.xquery.expr.TryCatchExpr;
import org.brackit.xquery.expr.TypeswitchExpr;
import org.brackit.xquery.expr.UnionExpr;
import org.brackit.xquery.expr.VCmpExpr;
import org.brackit.xquery.expr.Variable;
import org.brackit.xquery.function.AbstractFunction;
import org.brackit.xquery.function.FunctionExpr;
import org.brackit.xquery.function.UDF;
import org.brackit.xquery.function.bit.BitFun;
import org.brackit.xquery.module.Module;
import org.brackit.xquery.module.StaticContext;
import org.brackit.xquery.operator.Count;
import org.brackit.xquery.operator.ForBind;
import org.brackit.xquery.operator.GroupBy;
import org.brackit.xquery.operator.LetBind;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.operator.OrderBy;
import org.brackit.xquery.operator.Select;
import org.brackit.xquery.operator.Start;
import org.brackit.xquery.update.Delete;
import org.brackit.xquery.update.Insert;
import org.brackit.xquery.update.Rename;
import org.brackit.xquery.update.ReplaceNode;
import org.brackit.xquery.update.ReplaceValue;
import org.brackit.xquery.update.Transform;
import org.brackit.xquery.update.json.AppendJsonArrayValue;
import org.brackit.xquery.update.json.DeleteJson;
import org.brackit.xquery.update.json.InsertJson;
import org.brackit.xquery.update.json.RenameJsonField;
import org.brackit.xquery.update.json.ReplaceJsonValue;
import org.brackit.xquery.util.Cmp;
import org.brackit.xquery.util.Whitespace;
import org.brackit.xquery.util.aggregator.Aggregate;
import org.brackit.xquery.util.sort.Ordering;
import org.brackit.xquery.xdm.Axis;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Function;
import org.brackit.xquery.xdm.Kind;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.type.AnyItemType;
import org.brackit.xquery.xdm.type.AnyJsonItemType;
import org.brackit.xquery.xdm.type.AnyNodeType;
import org.brackit.xquery.xdm.type.AnyStructuredItemType;
import org.brackit.xquery.xdm.type.ArrayType;
import org.brackit.xquery.xdm.type.AtomicType;
import org.brackit.xquery.xdm.type.AttributeType;
import org.brackit.xquery.xdm.type.Cardinality;
import org.brackit.xquery.xdm.type.CommentType;
import org.brackit.xquery.xdm.type.DocumentType;
import org.brackit.xquery.xdm.type.ElementType;
import org.brackit.xquery.xdm.type.ItemType;
import org.brackit.xquery.xdm.type.NSNameWildcardTest;
import org.brackit.xquery.xdm.type.NSWildcardNameTest;
import org.brackit.xquery.xdm.type.NodeType;
import org.brackit.xquery.xdm.type.NullType;
import org.brackit.xquery.xdm.type.PIType;
import org.brackit.xquery.xdm.type.RecordType;
import org.brackit.xquery.xdm.type.SequenceType;
import org.brackit.xquery.xdm.type.TextType;

public class Compiler
implements Translator {
    protected VariableTable table;
    protected StaticContext ctx;
    protected final Map<QNm, Str> options;

    public Compiler(Map<QNm, Str> options) {
        this.options = options;
    }

    @Override
    public Expr expression(Module module, StaticContext ctx, AST expr, boolean allowUpdate) throws QueryException {
        this.table = new VariableTable(module);
        this.ctx = ctx;
        Expr e = this.expr(expr, !allowUpdate);
        this.table.resolvePositions();
        return e;
    }

    @Override
    public Expr function(Module module, StaticContext ctx, UDF udf, QNm[] params, AST expr, boolean allowUpdate) throws QueryException {
        this.table = new VariableTable(module);
        this.ctx = ctx;
        SequenceType[] types = udf.getSignature().getParams();
        for (int i = 0; i < params.length; ++i) {
            this.table.bind(params[i], types[i]);
        }
        for (QNm param : params) {
            this.table.resolve(param);
        }
        Expr body = this.expr(expr, !allowUpdate);
        for (int i = 0; i < params.length; ++i) {
            this.table.unbind();
        }
        this.table.resolvePositions();
        return body;
    }

    protected Expr expr(AST node, boolean disallowUpdatingExpr) throws QueryException {
        Expr expr = this.anyExpr(node);
        if (disallowUpdatingExpr && expr.isUpdating()) {
            throw new QueryException(ErrorCode.ERR_UPDATE_ILLEGAL_NESTED_UPDATE, "Illegal nested update expression");
        }
        return expr;
    }

    protected Expr anyExpr(AST node) throws QueryException {
        return switch (node.getType()) {
            case 7 -> this.flowrExpr(node);
            case 130 -> this.quantifiedExpr(node);
            case 6, 112, 153 -> this.sequenceExpr(node);
            case 118 -> new Str(Whitespace.normalizeXML11(node.getStringValue()));
            case 265 -> new Null();
            case 117, 119, 120, 121, 122, 123 -> (Atomic)node.getValue();
            case 26 -> this.variableRefExpr(node);
            case 60 -> this.arithmeticExpr(node);
            case 55 -> this.comparisonExpr(node);
            case 57 -> this.rangeExpr(node);
            case 39 -> this.andExpr(node);
            case 38 -> this.orExpr(node);
            case 79 -> this.castExpr(node);
            case 78 -> this.castableExpr(node);
            case 77 -> this.treatExpr(node);
            case 68 -> this.instanceOfExpr(node);
            case 134 -> this.typeswitchExpr(node);
            case 136 -> this.ifExpr(node);
            case 132 -> this.switchExpr(node);
            case 206 -> this.filterExpr(node);
            case 149, 154 -> this.elementExpr(node);
            case 150, 155 -> this.attributeExpr(node);
            case 151, 156 -> this.commentExpr(node);
            case 159 -> this.textExpr(node);
            case 158 -> this.documentExpr(node);
            case 157, 204 -> this.piExpr(node);
            case 80 -> this.functionCall(node);
            case 81 -> this.pathExpr(node);
            case 83 -> this.stepExpr(node);
            case 113 -> this.table.resolve(Bits.FS_DOT);
            case 219 -> this.insertExpr(node);
            case 225 -> this.deleteExpr(node);
            case 226, 227 -> this.replaceExpr(node);
            case 228 -> this.renameExpr(node);
            case 229 -> this.transformExpr(node);
            case 115, 116, 250 -> this.anyExpr(node.getChild(0));
            case 65 -> this.unionExpr(node);
            case 67 -> this.exceptExpr(node);
            case 66 -> this.intersectExpr(node);
            case 137 -> this.tryCatchExpr(node);
            case 140 -> this.extensionExpr(node);
            case 143 -> throw new QueryException(ErrorCode.ERR_SCHEMA_VALIDATION_FEATURE_NOT_SUPPORTED, "Schema validation feature is not supported.");
            case 244 -> this.arrayExpr(node);
            case 243 -> this.arrayAccessExpr(node);
            case 249 -> this.recordExpr(node);
            case 252 -> this.derefExpr(node);
            case 248 -> this.projectionExpr(node);
            case 266 -> this.insertJsonExpr(node);
            case 267 -> this.deleteJsonExpr(node);
            case 269 -> this.replaceJsonExpr(node);
            case 268 -> this.renameJsonExpr(node);
            case 270 -> this.appendJsonExpr(node);
            default -> throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected AST expr node '%s' of type: %s", node, node.getType());
        };
    }

    private Expr deleteJsonExpr(AST node) {
        AST derefOrArrayIndexNode = node.getChild(0);
        Expr targetExpr = this.expr(derefOrArrayIndexNode.getChild(0), true);
        Expr fieldOrIndex = this.expr(derefOrArrayIndexNode.getChild(1), true);
        return new DeleteJson(targetExpr, fieldOrIndex);
    }

    private Expr insertJsonExpr(AST node) {
        Expr sourceExpr = this.expr(node.getChild(0), true);
        Expr targetExpr = this.expr(node.getChild(1), true);
        int position = node.getChildCount() == 3 ? ((Int32)node.getChild(2).getValue()).intValue() : -1;
        return new InsertJson(sourceExpr, targetExpr, position);
    }

    private Expr appendJsonExpr(AST node) {
        Expr sourceExpr = this.expr(node.getChild(0), true);
        Expr targetExpr = this.expr(node.getChild(1), true);
        return new AppendJsonArrayValue(sourceExpr, targetExpr);
    }

    private Expr replaceJsonExpr(AST node) {
        AST derefOrArrayIndexNode = node.getChild(0);
        Expr targetExpr = this.expr(derefOrArrayIndexNode.getChild(0), true);
        Expr fieldOrIndex = this.expr(derefOrArrayIndexNode.getChild(1), true);
        Expr sourceExpr = this.expr(node.getChild(1), true);
        return new ReplaceJsonValue(sourceExpr, targetExpr, fieldOrIndex);
    }

    private Expr renameJsonExpr(AST node) {
        AST derefNode = node.getChild(0);
        Expr targetExpr = this.expr(derefNode.getChild(0), true);
        Expr oldFieldExpr = this.expr(derefNode.getChild(1), true);
        Expr newFieldExpr = this.expr(node.getChild(1), true);
        return new RenameJsonField(targetExpr, oldFieldExpr, newFieldExpr);
    }

    protected Expr tryCatchExpr(AST node) throws QueryException {
        int i;
        Expr expr = this.expr(node.getChild(0), true);
        Binding code = this.table.bind((QNm)node.getChild(1).getChild(0).getValue(), new SequenceType(AtomicType.QNM, Cardinality.One));
        Binding desc = this.table.bind((QNm)node.getChild(2).getChild(0).getValue(), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne));
        Binding value = this.table.bind((QNm)node.getChild(3).getChild(0).getValue(), new SequenceType(AnyItemType.ANY, Cardinality.ZeroOrMany));
        Binding module = this.table.bind((QNm)node.getChild(4).getChild(0).getValue(), new SequenceType(AtomicType.STR, Cardinality.ZeroOrOne));
        Binding lineNo = this.table.bind((QNm)node.getChild(5).getChild(0).getValue(), new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne));
        Binding colNo = this.table.bind((QNm)node.getChild(6).getChild(0).getValue(), new SequenceType(AtomicType.INR, Cardinality.ZeroOrOne));
        int catchCount = node.getChildCount() - 7;
        TryCatchExpr.ErrorCatch[][] catches = new TryCatchExpr.ErrorCatch[catchCount][];
        Expr[] handler = new Expr[catchCount];
        for (i = 0; i < catchCount; ++i) {
            AST clause = node.getChild(i + 7);
            AST catchErrorList = clause.getChild(0);
            int errorCount = catchErrorList.getChildCount();
            catches[i] = new TryCatchExpr.ErrorCatch[errorCount];
            for (int j = 0; j < errorCount; ++j) {
                AST nametest = catchErrorList.getChild(j);
                catches[i][j] = this.tryCatchNameTest(nametest);
            }
            handler[i] = this.expr(clause.getChild(1), true);
        }
        for (i = 0; i < 6; ++i) {
            this.table.unbind();
        }
        return new TryCatchExpr(expr, catches, handler, code.isReferenced(), desc.isReferenced(), value.isReferenced(), module.isReferenced(), lineNo.isReferenced(), colNo.isReferenced());
    }

    protected TryCatchExpr.ErrorCatch tryCatchNameTest(AST child) throws QueryException {
        AST name = child.getChild(0);
        switch (name.getType()) {
            case 100: {
                return new TryCatchExpr.Wildcard();
            }
            case 110: {
                return new TryCatchExpr.NSWildcard(name.getStringValue());
            }
            case 111: {
                return new TryCatchExpr.NameWildcard(name.getStringValue());
            }
        }
        QNm qnm = (QNm)name.getValue();
        return new TryCatchExpr.Name(qnm.getLocalName(), qnm.getNamespaceURI());
    }

    protected Expr extensionExpr(AST node) throws QueryException {
        return node.getChildCount() == 2 ? this.anyExpr(node.getChild(1)) : new EmptyExpr();
    }

    protected Expr unionExpr(AST node) throws QueryException {
        Expr firstExpr = this.expr(node.getChild(0), true);
        Expr secondExpr = this.expr(node.getChild(1), true);
        return new UnionExpr(firstExpr, secondExpr);
    }

    protected Expr exceptExpr(AST node) throws QueryException {
        Expr firstExpr = this.expr(node.getChild(0), true);
        Expr secondExpr = this.expr(node.getChild(1), true);
        return new ExceptExpr(firstExpr, secondExpr);
    }

    protected Expr intersectExpr(AST node) throws QueryException {
        Expr firstExpr = this.expr(node.getChild(0), true);
        Expr secondExpr = this.expr(node.getChild(1), true);
        return new IntersectExpr(firstExpr, secondExpr);
    }

    protected Expr castExpr(AST node) throws QueryException {
        Expr expr = this.expr(node.getChild(0), true);
        AST type = node.getChild(1);
        AST aouType = type.getChild(0);
        Type targetType = this.resolveType((QNm)aouType.getChild(0).getValue(), true);
        boolean allowEmptySequence = type.getChildCount() == 2 && type.getChild(1).getType() == 74;
        StaticContext sctx = node.getStaticContext();
        return new Cast(sctx, expr, targetType, allowEmptySequence);
    }

    protected Expr castableExpr(AST node) throws QueryException {
        Expr expr = this.expr(node.getChild(0), true);
        AST type = node.getChild(1);
        AST aouType = type.getChild(0);
        Type targetType = this.resolveType((QNm)aouType.getChild(0).getValue(), true);
        boolean allowEmptySequence = type.getChildCount() == 2 && type.getChild(1).getType() == 74;
        StaticContext sctx = node.getStaticContext();
        return new Castable(sctx, expr, targetType, allowEmptySequence);
    }

    protected Expr treatExpr(AST node) throws QueryException {
        Expr expr = this.expr(node.getChild(0), true);
        SequenceType sequenceType = this.sequenceType(node.getChild(1));
        return new Treat(expr, sequenceType);
    }

    protected Expr instanceOfExpr(AST node) throws QueryException {
        Expr expr = this.expr(node.getChild(0), true);
        SequenceType sequenceType = this.sequenceType(node.getChild(1));
        return new InstanceOf(expr, sequenceType);
    }

    protected Expr typeswitchExpr(AST node) throws QueryException {
        Expr operandExpr = this.expr(node.getChild(0), false);
        if (operandExpr.isUpdating()) {
            throw new QueryException(ErrorCode.ERR_UPDATE_ILLEGAL_NESTED_UPDATE, "Operand expression of typeswitch expression must not be updating.");
        }
        boolean updating = false;
        int vacOrUpdate = 0;
        int cases = node.getChildCount() - 2;
        Expr[] caseExprs = cases > 0 ? new Expr[cases] : null;
        SequenceType[] caseTypes = cases > 0 ? new SequenceType[cases] : null;
        boolean[] varRefs = new boolean[cases + 1];
        for (int i = 0; i < cases; ++i) {
            AST caseNode = node.getChild(i + 1);
            AST firstChild = caseNode.getChild(0);
            int c = 0;
            QNm varName = null;
            Binding binding = null;
            if (firstChild.getType() == 11) {
                varName = (QNm)firstChild.getValue();
            }
            int n = ++c;
            ++c;
            caseTypes[i] = this.sequenceType(caseNode.getChild(n));
            if (varName != null) {
                binding = this.table.bind(varName, caseTypes[i]);
            }
            caseExprs[i] = this.expr(caseNode.getChild(c), false);
            if (varName != null) {
                if (binding.isReferenced()) {
                    varRefs[i] = true;
                }
                this.table.unbind();
            }
            if (caseExprs[i].isVacuous()) {
                ++vacOrUpdate;
            }
            if (!caseExprs[i].isUpdating()) continue;
            updating = true;
            ++vacOrUpdate;
        }
        AST defaultNode = node.getChild(node.getChildCount() - 1);
        AST firstChild = defaultNode.getChild(0);
        int c = 0;
        QNm varName = null;
        Binding binding = null;
        if (firstChild.getType() == 11) {
            ++c;
            varName = (QNm)firstChild.getValue();
            binding = this.table.bind(varName, SequenceType.ITEM_SEQUENCE);
        }
        Expr defaultExpr = this.expr(defaultNode.getChild(c), false);
        if (varName != null) {
            if (binding.isReferenced()) {
                varRefs[varRefs.length - 1] = true;
            }
            this.table.unbind();
        }
        if (defaultExpr.isVacuous()) {
            ++vacOrUpdate;
        }
        if (defaultExpr.isUpdating()) {
            updating = true;
            ++vacOrUpdate;
        }
        if (updating && vacOrUpdate < cases + 1) {
            throw new QueryException(ErrorCode.ERR_UPDATE_ILLEGAL_NESTED_UPDATE, "One updating expression in a typeswitch case requires all branches to be updating or vacuous expressions.");
        }
        return new TypeswitchExpr(operandExpr, caseExprs, caseTypes, varRefs, defaultExpr, updating, vacOrUpdate == cases + 1);
    }

    protected Expr filterExpr(AST node) throws QueryException {
        Expr expr = this.expr(node.getChild(0), true);
        int noOfPredicates = node.getChildCount() - 1;
        Expr[] predicates = new Expr[noOfPredicates];
        boolean[] bindItem = new boolean[noOfPredicates];
        boolean[] bindPos = new boolean[noOfPredicates];
        boolean[] bindSize = new boolean[noOfPredicates];
        for (int i = 0; i < noOfPredicates; ++i) {
            Binding itemBinding = this.table.bind(Bits.FS_DOT, SequenceType.ITEM);
            Binding posBinding = this.table.bind(Bits.FS_POSITION, SequenceType.INTEGER);
            Binding sizeBinding = this.table.bind(Bits.FS_LAST, SequenceType.INTEGER);
            predicates[i] = this.expr(node.getChild(1 + i).getChild(0), true);
            this.table.unbind();
            this.table.unbind();
            this.table.unbind();
            bindItem[i] = itemBinding.isReferenced();
            bindPos[i] = posBinding.isReferenced();
            bindSize[i] = sizeBinding.isReferenced();
        }
        return new FilterExpr(expr, predicates, bindItem, bindPos, bindSize);
    }

    protected Expr insertExpr(AST node) throws QueryException {
        AST typeNode = node.getChild(0);
        Insert.InsertType insertType = switch (typeNode.getType()) {
            case 224 -> Insert.InsertType.INTO;
            case 223 -> Insert.InsertType.BEFORE;
            case 222 -> Insert.InsertType.AFTER;
            case 220 -> Insert.InsertType.FIRST;
            case 221 -> Insert.InsertType.LAST;
            default -> throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected AST expr node '%s' of type: %s", typeNode, typeNode.getType());
        };
        Expr sourceExpr = this.expr(node.getChild(1), true);
        Expr targetExpr = this.expr(node.getChild(2), true);
        return new Insert(sourceExpr, targetExpr, insertType);
    }

    protected Expr deleteExpr(AST node) throws QueryException {
        Expr targetExpr = this.expr(node.getChild(0), true);
        return new Delete(targetExpr);
    }

    protected Expr replaceExpr(AST node) throws QueryException {
        boolean replaceNode = node.getType() == 227;
        Expr targetExpr = this.expr(node.getChild(0), true);
        Expr sourceExpr = this.expr(node.getChild(1), true);
        return replaceNode ? new ReplaceNode(sourceExpr, targetExpr) : new ReplaceValue(sourceExpr, targetExpr);
    }

    protected Expr renameExpr(AST node) throws QueryException {
        Expr targetExpr = this.expr(node.getChild(0), true);
        Expr sourceExpr = this.expr(node.getChild(1), true);
        return new Rename(node.getStaticContext(), sourceExpr, targetExpr);
    }

    protected Expr transformExpr(AST node) throws QueryException {
        AST current;
        int childCount = node.getChildCount();
        Expr[] sourceExprs = new Expr[childCount - 2];
        Binding[] bindings = new Binding[childCount - 2];
        boolean[] referenced = new boolean[childCount - 2];
        int c = 0;
        while ((current = node.getChild(c)).getType() == 230) {
            QNm varName = (QNm)current.getChild(0).getValue();
            sourceExprs[c] = this.expr(current.getChild(1), true);
            bindings[c++] = this.table.bind(varName, SequenceType.ITEM);
        }
        Expr modifyExpr = this.expr(current, false);
        if (!modifyExpr.isUpdating() && !modifyExpr.isVacuous()) {
            throw new QueryException(ErrorCode.ERR_UPDATING_OR_VACUOUS_EXPR_REQUIRED, "Modify clause must not contain an expression that is non-updating and non-vacuous.");
        }
        Expr returnExpr = this.expr(node.getChild(++c), true);
        for (int i = 0; i < childCount - 2; ++i) {
            if (bindings[i].isReferenced()) {
                referenced[i] = true;
            }
            this.table.unbind();
        }
        return new Transform(sourceExprs, referenced, modifyExpr, returnExpr);
    }

    protected Expr quantifiedExpr(AST node) throws QueryException {
        AST child;
        int pos = 0;
        boolean someQuantified = (child = node.getChild(pos++)).getType() == 128;
        Expr bindingSequenceExpr = this.quantifiedBindings(new Start(), node, pos);
        AbstractFunction function = someQuantified ? BitFun.SOME_FUNC : BitFun.EVERY_FUNC;
        return new IfExpr(new FunctionExpr(node.getStaticContext(), function, bindingSequenceExpr), Bool.TRUE, Bool.FALSE);
    }

    protected Expr quantifiedBindings(Operator in, AST node, int pos) throws QueryException {
        AST child;
        if ((child = node.getChild(pos++)).getType() == 131) {
            AST varBinding = child.getChild(0);
            QNm runVarName = (QNm)varBinding.getChild(0).getValue();
            SequenceType type = SequenceType.ITEM_SEQUENCE;
            if (varBinding.getChildCount() == 2) {
                type = this.sequenceType(varBinding.getChild(1));
            }
            Expr sourceExpr = this.expr(child.getChild(1), true);
            ForBind forBind = new ForBind(in, sourceExpr, false);
            Binding runVarBinding = this.table.bind(runVarName, type);
            Expr returnExpr = this.quantifiedBindings(forBind, node, pos);
            this.table.unbind();
            forBind.bindVariable(runVarBinding.isReferenced());
            forBind.bindPosition(false);
            return returnExpr;
        }
        return new PipeExpr(in, this.expr(child, true));
    }

    protected Expr functionCall(AST node) throws QueryException {
        Expr[] args;
        int childCount = node.getChildCount();
        QNm name = (QNm)node.getValue();
        if ("jn".equals(name.getPrefix()) && "null".equals(name.getLocalName())) {
            return new Null();
        }
        Function function = this.ctx.getFunctions().resolve(name, childCount);
        if (childCount > 0) {
            args = new Expr[childCount];
            for (int i = 0; i < childCount; ++i) {
                AST arg = node.getChild(i);
                if (arg.getType() == 114) {
                    throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Partial function application is not supported yet");
                }
                args[i] = this.expr(arg, true);
            }
        } else if (function.getSignature().defaultCtxItemType() != null) {
            Variable contextItemRef = this.table.resolve(Bits.FS_DOT);
            args = new Expr[]{contextItemRef};
        } else {
            args = new Expr[]{};
        }
        return new FunctionExpr(node.getStaticContext(), function, args);
    }

    protected Expr documentExpr(AST node) throws QueryException {
        Binding binding = this.table.bind(Bits.FS_PARENT, SequenceType.ITEM);
        Expr contentExpr = this.expr(node.getChild(0), false);
        this.table.unbind();
        boolean bind = binding.isReferenced();
        return new DocumentExpr(contentExpr, bind);
    }

    protected Expr elementExpr(AST node) throws QueryException {
        Expr[] contentExpr;
        int pos = 0;
        int nsCnt = 0;
        while (node.getChild(nsCnt).getType() == 4) {
            ++nsCnt;
        }
        ElementExpr.NS[] ns = new ElementExpr.NS[nsCnt];
        for (int i = 0; i < nsCnt; ++i) {
            AST nsDecl;
            if ((nsDecl = node.getChild(pos++)).getChildCount() == 2) {
                String prefix = nsDecl.getChild(0).getStringValue();
                String uri = nsDecl.getChild(1).getStringValue();
                ns[i] = new ElementExpr.NS(prefix, uri);
                continue;
            }
            String uri = nsDecl.getChild(0).getStringValue();
            ns[i] = new ElementExpr.NS(null, uri);
        }
        Expr nameExpr = this.expr(node.getChild(pos++), true);
        boolean appendOnly = this.appendOnly(node);
        boolean bind = false;
        if (node.getChildCount() > 0) {
            Binding binding = this.table.bind(Bits.FS_PARENT, SequenceType.ITEM);
            contentExpr = this.contentSequence(node.getChild(pos));
            this.table.unbind();
            bind = binding.isReferenced();
        } else {
            contentExpr = new Expr[]{};
        }
        StaticContext sctx = node.getStaticContext();
        return new ElementExpr(sctx, nameExpr, ns, contentExpr, bind, appendOnly);
    }

    protected Expr[] contentSequence(AST node) throws QueryException {
        int childCount = node.getChildCount();
        if (childCount == 0) {
            return new Expr[0];
        }
        int size = 0;
        Expr[] subExprs = new Expr[childCount];
        String merged = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            AST child = node.getChild(i);
            if (child.getType() == 118) {
                merged = merged == null ? child.getStringValue() : merged + child.getStringValue();
                continue;
            }
            if (merged != null && !merged.isEmpty()) {
                subExprs[size++] = new Str(merged);
            }
            merged = null;
            subExprs[size++] = this.expr(child, true);
        }
        if (merged != null && !merged.isEmpty()) {
            subExprs[size++] = new Str(merged);
        }
        return Arrays.copyOf(subExprs, size);
    }

    protected Expr attributeExpr(AST node) throws QueryException {
        Expr nameExpr = this.expr(node.getChild(0), true);
        Expr[] contentExpr = node.getChildCount() > 1 ? this.contentSequence(node.getChild(1)) : new Expr[]{};
        StaticContext sctx = node.getStaticContext();
        return new AttributeExpr(sctx, nameExpr, contentExpr, this.appendOnly(node));
    }

    protected Expr commentExpr(AST node) throws QueryException {
        Expr contentExpr = this.expr(node.getChild(0), true);
        return new CommentExpr(contentExpr, this.appendOnly(node));
    }

    protected Expr textExpr(AST node) throws QueryException {
        Expr contentExpr = this.expr(node.getChild(0), true);
        return new TextExpr(contentExpr, this.appendOnly(node));
    }

    protected Expr piExpr(AST node) throws QueryException {
        Expr nameExpr = this.expr(node.getChild(0), true);
        EmptyExpr contentExpr = node.getChildCount() > 1 ? this.expr(node.getChild(1), true) : new EmptyExpr();
        return new PIExpr(nameExpr, contentExpr, this.appendOnly(node));
    }

    private boolean appendOnly(AST node) throws QueryException {
        boolean parentIsConstructor;
        AST parent = node.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getType() == 152) {
            parent = parent.getParent();
        }
        boolean bl = parentIsConstructor = parent.getType() == 149 || parent.getType() == 158;
        if (parentIsConstructor) {
            this.table.resolve(Bits.FS_PARENT);
        }
        return parentIsConstructor;
    }

    protected Expr andExpr(AST node) throws QueryException {
        Expr firstExpr = this.expr(node.getChild(0), true);
        Expr secondExpr = this.expr(node.getChild(1), true);
        return new AndExpr(firstExpr, secondExpr);
    }

    protected Expr orExpr(AST node) throws QueryException {
        Expr firstExpr = this.expr(node.getChild(0), true);
        Expr secondExpr = this.expr(node.getChild(1), true);
        return new OrExpr(firstExpr, secondExpr);
    }

    protected Expr ifExpr(AST node) throws QueryException {
        Expr condExpr = this.expr(node.getChild(0), true);
        Expr ifExpr = this.expr(node.getChild(1), false);
        Expr elseExpr = this.expr(node.getChild(2), false);
        if (ifExpr.isUpdating()) {
            if (!elseExpr.isUpdating() && !elseExpr.isVacuous()) {
                throw new QueryException(ErrorCode.ERR_UPDATE_ILLEGAL_NESTED_UPDATE, "Single updating if branch is not allowed");
            }
        } else if (elseExpr.isUpdating() && !ifExpr.isUpdating() && !ifExpr.isVacuous()) {
            throw new QueryException(ErrorCode.ERR_UPDATE_ILLEGAL_NESTED_UPDATE, "Single updating else branch is not allowed");
        }
        return new IfExpr(condExpr, ifExpr, elseExpr);
    }

    protected Expr switchExpr(AST node) throws QueryException {
        Expr opExpr = this.expr(node.getChild(0), true);
        Expr[][] cases = new Expr[node.getChildCount() - 2][];
        for (int i = 1; i < node.getChildCount() - 1; ++i) {
            AST caseClause = node.getChild(i);
            Expr[] caseOps = new Expr[caseClause.getChildCount()];
            for (int j = 0; j < caseClause.getChildCount(); ++j) {
                caseOps[j] = this.expr(caseClause.getChild(j), false);
            }
            cases[i - 1] = caseOps;
        }
        Expr dftExpr = this.expr(node.getChild(node.getChildCount() - 1), false);
        return new SwitchExpr(opExpr, cases, dftExpr);
    }

    protected Expr variableRefExpr(AST node) throws QueryException {
        return this.table.resolve((QNm)node.getValue());
    }

    protected Expr rangeExpr(AST node) throws QueryException {
        Expr firstArg = this.expr(node.getChild(0), true);
        Expr secondArg = this.expr(node.getChild(1), true);
        return new RangeExpr(firstArg, secondArg);
    }

    protected Expr comparisonExpr(AST node) throws QueryException {
        Expr firstArg = this.expr(node.getChild(1), true);
        Expr secondArg = this.expr(node.getChild(2), true);
        AST cmpNode = node.getChild(0);
        return switch (cmpNode.getType()) {
            case 46 -> new VCmpExpr(Cmp.eq, firstArg, secondArg);
            case 51 -> new VCmpExpr(Cmp.ge, firstArg, secondArg);
            case 49 -> new VCmpExpr(Cmp.le, firstArg, secondArg);
            case 48 -> new VCmpExpr(Cmp.lt, firstArg, secondArg);
            case 50 -> new VCmpExpr(Cmp.gt, firstArg, secondArg);
            case 47 -> new VCmpExpr(Cmp.ne, firstArg, secondArg);
            case 40 -> new GCmpExpr(Cmp.eq, firstArg, secondArg);
            case 45 -> new GCmpExpr(Cmp.ge, firstArg, secondArg);
            case 43 -> new GCmpExpr(Cmp.le, firstArg, secondArg);
            case 42 -> new GCmpExpr(Cmp.lt, firstArg, secondArg);
            case 44 -> new GCmpExpr(Cmp.gt, firstArg, secondArg);
            case 41 -> new GCmpExpr(Cmp.ne, firstArg, secondArg);
            case 52 -> new NodeCmpExpr(NodeCmpExpr.NodeCmp.Is, firstArg, secondArg);
            case 54 -> new NodeCmpExpr(NodeCmpExpr.NodeCmp.Following, firstArg, secondArg);
            case 53 -> new NodeCmpExpr(NodeCmpExpr.NodeCmp.Preceding, firstArg, secondArg);
            default -> throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected comparison: '%s'", cmpNode);
        };
    }

    protected Expr arithmeticExpr(AST node) throws QueryException {
        ArithmeticExpr.ArithmeticOp op = switch (node.getChild(0).getType()) {
            case 58 -> ArithmeticExpr.ArithmeticOp.PLUS;
            case 59 -> ArithmeticExpr.ArithmeticOp.MINUS;
            case 61 -> ArithmeticExpr.ArithmeticOp.MULT;
            case 62 -> ArithmeticExpr.ArithmeticOp.DIV;
            case 63 -> ArithmeticExpr.ArithmeticOp.IDIV;
            case 64 -> ArithmeticExpr.ArithmeticOp.MOD;
            default -> null;
        };
        Expr firstArg = this.expr(node.getChild(1), true);
        Expr secondArg = this.expr(node.getChild(2), true);
        return new ArithmeticExpr(op, firstArg, secondArg);
    }

    protected Expr pathExpr(AST node) throws QueryException {
        Expr e1 = this.expr(node.getChild(0), true);
        for (int i = 1; i < node.getChildCount(); ++i) {
            Binding itemBinding = this.table.bind(Bits.FS_DOT, SequenceType.NODE);
            Binding posBinding = this.table.bind(Bits.FS_POSITION, SequenceType.INTEGER);
            Binding sizeBinding = this.table.bind(Bits.FS_LAST, SequenceType.INTEGER);
            AST step = node.getChild(i);
            Expr e2 = this.expr(step, true);
            this.table.unbind();
            this.table.unbind();
            this.table.unbind();
            boolean bindItem = itemBinding.isReferenced();
            boolean bindPos = posBinding.isReferenced();
            boolean bindSize = sizeBinding.isReferenced();
            boolean lastStep = i + 1 == node.getChildCount();
            boolean skipDDO = step.checkProperty("skipDDO");
            boolean checkInput = step.checkProperty("checkInput");
            e1 = new PathStepExpr(e1, e2, bindItem, bindPos, bindSize, lastStep, skipDDO, checkInput);
        }
        return e1;
    }

    protected Expr stepExpr(AST node) throws QueryException {
        Accessor axis;
        AST child = node.getChild(0);
        if (child.getType() == 84) {
            axis = this.axis(child.getChild(0));
            child = node.getChild(1);
        } else {
            axis = Accessor.CHILD;
        }
        Variable in = this.table.resolve(Bits.FS_DOT);
        NodeType test = this.nodeTest(child, axis.getAxis());
        int noOfPredicates = Math.max(node.getChildCount() - 2, 0);
        Expr[] filter = new Expr[noOfPredicates];
        boolean[] bindItem = new boolean[noOfPredicates];
        boolean[] bindPos = new boolean[noOfPredicates];
        boolean[] bindSize = new boolean[noOfPredicates];
        for (int i = 0; i < noOfPredicates; ++i) {
            Binding itemBinding = this.table.bind(Bits.FS_DOT, SequenceType.ITEM);
            Binding posBinding = this.table.bind(Bits.FS_POSITION, SequenceType.INTEGER);
            Binding sizeBinding = this.table.bind(Bits.FS_LAST, SequenceType.INTEGER);
            filter[i] = this.expr(node.getChild(2 + i).getChild(0), true);
            this.table.unbind();
            this.table.unbind();
            this.table.unbind();
            bindItem[i] = itemBinding.isReferenced();
            bindPos[i] = posBinding.isReferenced();
            bindSize[i] = sizeBinding.isReferenced();
        }
        return new StepExpr(axis, test, in, filter, bindItem, bindPos, bindSize);
    }

    protected Accessor axis(AST node) throws QueryException {
        return switch (node.getType()) {
            case 86 -> Accessor.CHILD;
            case 87 -> Accessor.DESCENDANT;
            case 88 -> Accessor.DESCENDANT_OR_SELF;
            case 89 -> Accessor.ATTRIBUTE;
            case 92 -> Accessor.PARENT;
            case 93 -> Accessor.ANCESTOR;
            case 96 -> Accessor.ANCESTOR_OR_SELF;
            case 90 -> Accessor.FOLLOWING_SIBLING;
            case 91 -> Accessor.FOLLOWING;
            case 95 -> Accessor.PRECEDING;
            case 94 -> Accessor.PRECEDING_SIBLING;
            case 85 -> Accessor.SELF;
            case 253 -> Accessor.NEXT;
            case 254 -> Accessor.PREVIOUS;
            case 255 -> Accessor.FUTURE;
            case 256 -> Accessor.FUTURE_OR_SELF;
            case 257 -> Accessor.PAST;
            case 258 -> Accessor.PAST_OR_SELF;
            case 259 -> Accessor.FIRST;
            case 260 -> Accessor.LAST;
            case 261 -> Accessor.ALL_TIME;
            default -> throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Suport for document axis '%s' not implemented yet", node);
        };
    }

    protected SequenceType sequenceType(AST node) throws QueryException {
        AST child = node.getChild(0);
        if (child.getType() == 70) {
            return SequenceType.EMPTY_SEQUENCE;
        }
        ItemType itemType = this.itemType(child);
        Cardinality cardinality = Cardinality.One;
        if (node.getChildCount() == 2) {
            cardinality = switch (node.getChild(1).getType()) {
                case 76 -> Cardinality.OneOrMany;
                case 75 -> Cardinality.ZeroOrMany;
                case 74 -> Cardinality.ZeroOrOne;
                default -> Cardinality.One;
            };
        }
        return new SequenceType(itemType, cardinality);
    }

    protected ItemType itemType(AST node) throws QueryException {
        return switch (node.getType()) {
            case 71 -> AnyItemType.ANY;
            case 72 -> this.atomicOrUnionType(node);
            case 263 -> new AnyStructuredItemType();
            case 247 -> new RecordType();
            case 242 -> new ArrayType();
            case 264 -> new NullType();
            case 262 -> new AnyJsonItemType();
            default -> this.kindTest(node);
        };
    }

    protected ItemType atomicOrUnionType(AST node) throws QueryException {
        Type type = this.resolveType((QNm)node.getChild(0).getValue(), false);
        return new AtomicType(type);
    }

    protected NodeType nodeTest(AST node, Axis axis) throws QueryException {
        if (node.getType() == 99) {
            return this.nameTest(node, axis);
        }
        return this.kindTest(node);
    }

    protected NodeType kindTest(AST node) throws QueryException {
        switch (node.getType()) {
            case 97: {
                return AnyNodeType.ANY_NODE;
            }
            case 108: {
                return new TextType();
            }
            case 102: {
                return this.elementTest(node);
            }
            case 103: {
                return this.attributeTest(node);
            }
            case 107: {
                return new CommentType();
            }
            case 98: {
                return this.documentTest(node);
            }
            case 106: {
                if (node.getChildCount() == 0) {
                    return new PIType();
                }
                return new PIType(node.getChild(0).getStringValue());
            }
            case 104: {
                return this.schemaElementTest(node);
            }
            case 105: {
                return this.schemaAttributeTest(node);
            }
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "KindTest translation not implemented yet.");
    }

    protected AttributeType schemaAttributeTest(AST child) throws QueryException {
        QNm qname = (QNm)child.getChild(0).getValue();
        return new AttributeType(qname, this.ctx.getTypes().resolveSchemaType(qname));
    }

    protected ElementType schemaElementTest(AST child) throws QueryException {
        QNm qname = (QNm)child.getChild(0).getValue();
        return new ElementType(qname, this.ctx.getTypes().resolveSchemaType(qname));
    }

    protected DocumentType documentTest(AST child) throws QueryException {
        if (child.getChildCount() == 0) {
            return new DocumentType();
        }
        if (child.getChild(0).getType() == 102) {
            return new DocumentType(this.elementTest(child.getChild(0)));
        }
        return new DocumentType(this.schemaElementTest(child.getChild(0)));
    }

    protected AttributeType attributeTest(AST child) throws QueryException {
        if (child.getChildCount() == 0) {
            return new AttributeType();
        }
        if (child.getChildCount() == 1) {
            return new AttributeType(this.qNameOrWildcard(child.getChild(0)));
        }
        return new AttributeType(this.qNameOrWildcard(child.getChild(0)), this.resolveType((QNm)child.getChild(1).getValue(), false));
    }

    protected ElementType elementTest(AST child) throws QueryException {
        if (child.getChildCount() == 0) {
            return new ElementType();
        }
        if (child.getChildCount() == 1) {
            return new ElementType(this.qNameOrWildcard(child.getChild(0)));
        }
        return new ElementType(this.qNameOrWildcard(child.getChild(0)), this.resolveType((QNm)child.getChild(1).getValue(), false));
    }

    protected QNm qNameOrWildcard(AST name) throws QueryException {
        return name.getType() == 100 ? null : (QNm)name.getValue();
    }

    protected NodeType nameTest(AST child, Axis axis) throws QueryException {
        AST name = child.getChild(0);
        switch (name.getType()) {
            case 100: {
                if (axis != Axis.ATTRIBUTE) {
                    return new ElementType(null);
                }
                return new AttributeType(null);
            }
            case 110: {
                return new NSWildcardNameTest(axis == Axis.ATTRIBUTE ? Kind.ATTRIBUTE : Kind.ELEMENT, name.getStringValue());
            }
            case 111: {
                return new NSNameWildcardTest(axis == Axis.ATTRIBUTE ? Kind.ATTRIBUTE : Kind.ELEMENT, this.ctx.getNamespaces().resolve(name.getStringValue()));
            }
        }
        if (axis != Axis.ATTRIBUTE) {
            return new ElementType((QNm)name.getValue());
        }
        return new AttributeType((QNm)name.getValue());
    }

    protected Type resolveType(QNm qname, boolean atomic) throws QueryException {
        if (atomic) {
            return this.ctx.getTypes().resolveAtomicType(qname);
        }
        return this.ctx.getTypes().resolveType(qname);
    }

    protected Expr sequenceExpr(AST node) throws QueryException {
        boolean allVacouousOrUpdating = false;
        Expr[] subExpr = new Expr[node.getChildCount()];
        for (int i = 0; i < node.getChildCount(); ++i) {
            subExpr[i] = this.expr(node.getChild(i), false);
            if (subExpr[i].isUpdating()) {
                if (!allVacouousOrUpdating && i > 0) {
                    for (int j = 0; j < i; ++j) {
                        if (subExpr[j].isVacuous()) continue;
                        throw new QueryException(ErrorCode.ERR_UPDATE_ILLEGAL_NESTED_UPDATE, "Illegal nested updating expression.");
                    }
                }
                allVacouousOrUpdating = true;
                continue;
            }
            if (!allVacouousOrUpdating || subExpr[i].isVacuous()) continue;
            throw new QueryException(ErrorCode.ERR_UPDATE_ILLEGAL_NESTED_UPDATE, "Illegal nested updating expression.");
        }
        return new SequenceExpr(subExpr);
    }

    protected Expr flowrExpr(AST node) throws QueryException {
        int childCount = node.getChildCount();
        ClauseBinding cb = this.flowrClause(new ClauseBinding(null, new Start(), new Binding[0]), node, 0, childCount - 2);
        Expr returnExpr = this.expr(node.getChild(childCount - 1).getChild(0), false);
        cb.unbind();
        PipeExpr pipeExpr = new PipeExpr(cb.operator, returnExpr);
        return pipeExpr;
    }

    private ClauseBinding flowrClause(ClauseBinding in, AST node, int pos, int maxPos) throws QueryException {
        ClauseBinding cb = in;
        while (pos <= maxPos) {
            AST clause = node.getChild(pos++);
            cb = switch (clause.getType()) {
                case 8 -> this.forClause(clause, cb);
                case 12 -> this.letClause(clause, cb);
                case 13 -> this.whereClause(clause, cb);
                case 28 -> this.orderByClause(clause, cb);
                case 36 -> this.countClause(clause, cb);
                case 14 -> this.groupByClause(clause, cb);
                default -> throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unknown flowr clause type: %s", clause);
            };
        }
        return cb;
    }

    protected ClauseBinding countClause(AST node, ClauseBinding in) throws QueryException {
        AST countVarDecl = node.getChild(0);
        QNm posVarName = (QNm)countVarDecl.getChild(0).getValue();
        SequenceType posVarType = SequenceType.ITEM_SEQUENCE;
        if (countVarDecl.getChildCount() == 2) {
            posVarType = this.sequenceType(countVarDecl.getChild(1));
        }
        final Binding binding = this.table.bind(posVarName, posVarType);
        final Count count = new Count(in.operator);
        return new ClauseBinding(in, count, new Binding[]{binding}){

            @Override
            public void unbind() {
                super.unbind();
                count.bind(binding.isReferenced());
                Compiler.this.table.unbind();
            }
        };
    }

    protected ClauseBinding orderByClause(AST node, ClauseBinding in) throws QueryException {
        int orderBySpecCount = node.getChildCount();
        Expr[] orderByExprs = new Expr[orderBySpecCount];
        Ordering.OrderModifier[] orderBySpec = new Ordering.OrderModifier[orderBySpecCount];
        for (int i = 0; i < orderBySpecCount; ++i) {
            AST orderBy = node.getChild(i);
            orderByExprs[i] = this.expr(orderBy.getChild(0), true);
            orderBySpec[i] = this.orderModifier(orderBy);
        }
        OrderBy orderBy = new OrderBy(in.operator, orderByExprs, orderBySpec);
        return new ClauseBinding(in, orderBy, new Binding[0]);
    }

    protected Ordering.OrderModifier orderModifier(AST orderBy) {
        boolean asc = true;
        boolean emptyLeast = true;
        String collation = null;
        for (int i = 1; i < orderBy.getChildCount(); ++i) {
            AST modifier = orderBy.getChild(i);
            if (modifier.getType() == 30) {
                AST direction = modifier.getChild(0);
                asc = direction.getType() == 31;
                continue;
            }
            if (modifier.getType() == 33) {
                AST empty = modifier.getChild(0);
                emptyLeast = empty.getType() == 35;
                continue;
            }
            if (modifier.getType() != 27) continue;
            collation = modifier.getChild(0).getStringValue();
        }
        return new Ordering.OrderModifier(asc, emptyLeast, collation);
    }

    protected ClauseBinding groupByClause(AST node, ClauseBinding in) throws QueryException {
        int i;
        int pos = 0;
        while (node.getChild(pos).getType() == 15) {
            ++pos;
        }
        int grpSpecCnt = pos;
        ArrayList<AggregateBinding> bnds = new ArrayList<AggregateBinding>();
        while (node.getChild(pos).getType() == 16) {
            AST aggSpec = node.getChild(pos);
            QNm var = (QNm)aggSpec.getChild(0).getValue();
            for (int j = 1; j < aggSpec.getChildCount(); ++j) {
                AST aggBinding = aggSpec.getChild(j);
                AST typedVarBnd = aggBinding.getChild(0);
                Aggregate agg = this.aggregate(aggBinding.getChild(1));
                QNm aggVar = (QNm)typedVarBnd.getChild(0).getValue();
                SequenceType aggType = SequenceType.ITEM_SEQUENCE;
                if (typedVarBnd.getChildCount() == 2) {
                    aggType = this.sequenceType(typedVarBnd.getChild(1));
                }
                bnds.add(new AggregateBinding(var, aggVar, aggType, agg));
            }
            ++pos;
        }
        Aggregate dftAgg = this.aggregate(node.getChild(pos).getChild(0));
        Aggregate[] addAggs = new Aggregate[bnds.size()];
        for (int i2 = 0; i2 < bnds.size(); ++i2) {
            AggregateBinding bnd = (AggregateBinding)bnds.get(i2);
            addAggs[i2] = bnd.agg;
        }
        boolean sequential = node.checkProperty("sequential");
        GroupBy groupBy = new GroupBy(in.operator, dftAgg, addAggs, grpSpecCnt, sequential);
        for (i = 0; i < grpSpecCnt; ++i) {
            QNm grpVarName = (QNm)node.getChild(i).getChild(0).getValue();
            this.table.resolve(grpVarName, groupBy.group(i));
        }
        for (i = 0; i < bnds.size(); ++i) {
            AggregateBinding bnd = (AggregateBinding)bnds.get(i);
            this.table.resolve(bnd.srcVar, groupBy.aggregate(i));
        }
        for (AggregateBinding bnd : bnds) {
            this.table.bind(bnd.aggVar, bnd.aggVarType);
            this.table.resolve(bnd.aggVar);
        }
        return new ClauseBinding(in, groupBy, new Binding[0]);
    }

    protected Aggregate aggregate(AST node) throws QueryException {
        return switch (node.getType()) {
            case 19 -> Aggregate.SEQUENCE;
            case 20 -> Aggregate.COUNT;
            case 21 -> Aggregate.SUM;
            case 22 -> Aggregate.AVG;
            case 23 -> Aggregate.MIN;
            case 24 -> Aggregate.MAX;
            case 25 -> Aggregate.SINGLE;
            default -> throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unknown aggregate type: %s", node);
        };
    }

    protected ClauseBinding whereClause(AST node, ClauseBinding in) throws QueryException {
        Expr expr = this.anyExpr(node.getChild(0));
        Select select = new Select(in.operator, expr);
        return new ClauseBinding(in, select, new Binding[0]);
    }

    protected ClauseBinding letClause(AST node, ClauseBinding in) throws QueryException {
        int letClausePos = 0;
        AST letClause = node;
        AST letVarDecl = letClause.getChild(letClausePos++);
        QNm letVarName = (QNm)letVarDecl.getChild(0).getValue();
        SequenceType letVarType = SequenceType.ITEM_SEQUENCE;
        if (letVarDecl.getChildCount() == 2) {
            letVarType = this.sequenceType(letVarDecl.getChild(1));
        }
        Expr sourceExpr = this.expr(letClause.getChild(letClausePos++), true);
        final Binding binding = this.table.bind(letVarName, letVarType);
        final LetBind letBind = new LetBind(in.operator, sourceExpr);
        return new ClauseBinding(in, letBind, new Binding[]{binding}){

            @Override
            public void unbind() {
                super.unbind();
                letBind.bind(binding.isReferenced());
                Compiler.this.table.unbind();
            }
        };
    }

    protected ClauseBinding forClause(AST node, ClauseBinding in) throws QueryException {
        AST posBindingOrSourceExpr;
        QNm posVarName = null;
        int forClausePos = 0;
        AST forClause = node;
        AST runVarDecl = forClause.getChild(forClausePos++);
        QNm runVarName = (QNm)runVarDecl.getChild(0).getValue();
        SequenceType runVarType = SequenceType.ITEM_SEQUENCE;
        if (runVarDecl.getChildCount() == 2) {
            runVarType = this.sequenceType(runVarDecl.getChild(1));
        }
        if ((posBindingOrSourceExpr = forClause.getChild(forClausePos++)).getType() == 10) {
            posVarName = (QNm)posBindingOrSourceExpr.getChild(0).getValue();
            posBindingOrSourceExpr = forClause.getChild(forClausePos);
        }
        Expr sourceExpr = this.expr(posBindingOrSourceExpr, true);
        final Binding runVarBinding = this.table.bind(runVarName, runVarType);
        final Binding posBinding = posVarName != null ? this.table.bind(posVarName, SequenceType.INTEGER) : null;
        final ForBind forBind = new ForBind(in.operator, sourceExpr, false);
        return new ClauseBinding(in, forBind, new Binding[]{runVarBinding, posBinding}){

            @Override
            public void unbind() {
                super.unbind();
                if (posBinding != null) {
                    forBind.bindPosition(posBinding.isReferenced());
                    Compiler.this.table.unbind();
                }
                forBind.bindVariable(runVarBinding.isReferenced());
                Compiler.this.table.unbind();
            }
        };
    }

    protected Expr arrayAccessExpr(AST node) throws QueryException {
        Expr expr = this.expr(node.getChild(0), true);
        Expr index = this.expr(node.getChild(1), true);
        return new ArrayAccessExpr(expr, index);
    }

    protected Expr arrayExpr(AST node) throws QueryException {
        int cnt = node.getChildCount();
        boolean[] flatten = new boolean[cnt];
        Expr[] expr = new Expr[cnt];
        for (int i = 0; i < cnt; ++i) {
            AST field = node.getChild(i);
            flatten[i] = field.getType() == 246;
            expr[i] = this.expr(field.getChild(0), true);
        }
        return new ArrayExpr(expr, flatten);
    }

    protected Expr recordExpr(AST node) throws QueryException {
        int cnt = node.getChildCount();
        RecordExpr.Field[] fields = new RecordExpr.Field[cnt];
        for (int i = 0; i < cnt; ++i) {
            AST field = node.getChild(i);
            fields[i] = field.getType() == 251 ? new RecordExpr.KeyValueField(this.expr(field.getChild(0), true), this.expr(field.getChild(1), true)) : new RecordExpr.RecordField(this.expr(field, true));
        }
        return new RecordExpr(fields);
    }

    protected Expr derefExpr(AST node) throws QueryException {
        Expr record = this.expr(node.getChild(0), true);
        Expr[] fields = new Expr[node.getChildCount() - 1];
        for (int i = 1; i < node.getChildCount(); ++i) {
            fields[i - 1] = this.expr(node.getChild(i), true);
        }
        return new DerefExpr(record, fields);
    }

    protected Expr projectionExpr(AST node) throws QueryException {
        Expr record = this.expr(node.getChild(0), true);
        Expr[] fields = new Expr[node.getChildCount() - 1];
        for (int i = 1; i < node.getChildCount(); ++i) {
            fields[i - 1] = this.expr(node.getChild(i), true);
        }
        return new ProjectionExpr(record, fields);
    }

    protected static class ClauseBinding {
        final ClauseBinding in;
        final Operator operator;
        final Binding[] bindings;

        ClauseBinding(ClauseBinding in, Operator operator, Binding ... bindings) {
            this.in = in;
            this.operator = operator;
            this.bindings = bindings;
        }

        void unbind() {
            if (this.in != null) {
                this.in.unbind();
            }
        }
    }

    protected static class AggregateBinding {
        final QNm srcVar;
        final QNm aggVar;
        final SequenceType aggVarType;
        final Aggregate agg;

        public AggregateBinding(QNm srcVar, QNm aggVar, SequenceType aggVarType, Aggregate agg) {
            this.srcVar = srcVar;
            this.aggVar = aggVar;
            this.aggVarType = aggVarType;
            this.agg = agg;
        }
    }
}

