/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.translator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.atomic.Str;
import org.brackit.xquery.compiler.AST;
import org.brackit.xquery.compiler.translator.Binding;
import org.brackit.xquery.compiler.translator.Compiler;
import org.brackit.xquery.expr.PipeExpr;
import org.brackit.xquery.operator.Check;
import org.brackit.xquery.operator.Count;
import org.brackit.xquery.operator.ForBind;
import org.brackit.xquery.operator.GroupBy;
import org.brackit.xquery.operator.LetBind;
import org.brackit.xquery.operator.NLJoin;
import org.brackit.xquery.operator.Operator;
import org.brackit.xquery.operator.OrderBy;
import org.brackit.xquery.operator.Print;
import org.brackit.xquery.operator.Select;
import org.brackit.xquery.operator.Start;
import org.brackit.xquery.operator.TableJoin;
import org.brackit.xquery.util.Cmp;
import org.brackit.xquery.util.aggregator.Aggregate;
import org.brackit.xquery.util.sort.Ordering;
import org.brackit.xquery.xdm.DocumentException;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.node.Node;
import org.brackit.xquery.xdm.type.SequenceType;

public class TopDownTranslator
extends Compiler {
    public TopDownTranslator(Map<QNm, Str> options) {
        super(options);
    }

    @Override
    protected Expr anyExpr(AST node) throws QueryException {
        if (node.getType() == 231) {
            return this.pipeExpr(node);
        }
        return super.anyExpr(node);
    }

    protected Expr pipeExpr(AST node) throws QueryException {
        int initialBindSize = this.table.bound().length;
        Operator root = this.anyOp(null, node.getChild(0));
        AST returnExpr = node.getChild(0);
        while (returnExpr.getType() != 241) {
            returnExpr = returnExpr.getLastChild();
        }
        Expr expr = this.anyExpr(returnExpr.getChild(0));
        int unbind = this.table.bound().length - initialBindSize;
        for (int i = 0; i < unbind; ++i) {
            this.table.unbind();
        }
        return new PipeExpr(root, expr);
    }

    protected Operator anyOp(Operator in, AST node) throws QueryException {
        return this._anyOp(in, node);
    }

    protected Operator _anyOp(Operator in, AST node) throws QueryException {
        switch (node.getType()) {
            case 237: {
                if (node.getChildCount() == 0) {
                    return new Start();
                }
                return this.anyOp(new Start(), node.getLastChild());
            }
            case 241: {
                return in;
            }
            case 238: {
                return this.forBind(in, node);
            }
            case 239: {
                return this.letBind(in, node);
            }
            case 232: {
                return this.select(in, node);
            }
            case 234: {
                return this.orderBy(in, node);
            }
            case 233: {
                return this.groupBy(in, node);
            }
            case 240: {
                return this.count(in, node);
            }
            case 235: {
                return this.join(in, node);
            }
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Unexpected AST operator node '%s' of type: %s", node, node.getType());
    }

    protected Operator groupBy(Operator in, AST node) throws QueryException {
        int i;
        int pos = 0;
        while (node.getChild(pos).getType() == 15) {
            ++pos;
        }
        int grpSpecCnt = pos;
        ArrayList<Compiler.AggregateBinding> bnds = new ArrayList<Compiler.AggregateBinding>();
        while (node.getChild(pos).getType() == 16) {
            AST aggSpec = node.getChild(pos);
            QNm var = (QNm)aggSpec.getChild(0).getValue();
            for (int j = 1; j < aggSpec.getChildCount(); ++j) {
                AST aggBinding = aggSpec.getChild(j);
                AST typedVarBnd = aggBinding.getChild(0);
                Aggregate agg = this.aggregate(aggBinding.getChild(1));
                QNm aggVar = (QNm)typedVarBnd.getChild(0).getValue();
                SequenceType aggType = SequenceType.ITEM_SEQUENCE;
                if (typedVarBnd.getChildCount() == 2) {
                    aggType = this.sequenceType(typedVarBnd.getChild(1));
                }
                bnds.add(new Compiler.AggregateBinding(var, aggVar, aggType, agg));
            }
            ++pos;
        }
        Aggregate dftAgg = this.aggregate(node.getChild(pos).getChild(0));
        Aggregate[] addAggs = new Aggregate[bnds.size()];
        for (int i2 = 0; i2 < bnds.size(); ++i2) {
            Compiler.AggregateBinding bnd = (Compiler.AggregateBinding)bnds.get(i2);
            addAggs[i2] = bnd.agg;
        }
        boolean sequential = node.checkProperty("sequential");
        GroupBy groupBy = new GroupBy(in, dftAgg, addAggs, grpSpecCnt, sequential);
        for (i = 0; i < grpSpecCnt; ++i) {
            QNm grpVarName = (QNm)node.getChild(i).getChild(0).getValue();
            this.table.resolve(grpVarName, groupBy.group(i));
        }
        for (i = 0; i < bnds.size(); ++i) {
            Compiler.AggregateBinding bnd = (Compiler.AggregateBinding)bnds.get(i);
            this.table.resolve(bnd.srcVar, groupBy.aggregate(i));
        }
        for (Compiler.AggregateBinding bnd : bnds) {
            this.table.bind(bnd.aggVar, bnd.aggVarType);
            this.table.resolve(bnd.aggVar);
        }
        this.addChecks(groupBy, (List)node.getProperty("check"));
        return this.anyOp(groupBy, node.getLastChild());
    }

    protected Operator join(Operator in, AST node) throws QueryException {
        Cmp cmp = (Cmp)((Object)node.getProperty("cmp"));
        boolean isGcmp = node.checkProperty("GCmp");
        Operator leftIn = this.anyOp(in, node.getChild(0).getChild(0));
        AST tmp = node.getChild(0);
        while (tmp.getType() != 241) {
            tmp = tmp.getLastChild();
        }
        Expr leftExpr = this.anyExpr(tmp.getChild(0));
        Operator rightIn = this.anyOp(new Start(), node.getChild(1));
        tmp = node.getChild(1);
        while (tmp.getType() != 241) {
            tmp = tmp.getLastChild();
        }
        Expr rightExpr = this.anyExpr(tmp.getChild(0));
        boolean leftJoin = node.checkProperty("leftJoin");
        boolean skipSort = node.checkProperty("skipSort");
        TableJoin join = new TableJoin(cmp, isGcmp, leftJoin, skipSort, leftIn, leftExpr, rightIn, rightExpr);
        QNm prop = (QNm)node.getProperty("group");
        if (prop != null) {
            this.table.resolve(prop, join.group());
        }
        this.addChecks(join, (List)node.getProperty("check"));
        Operator op = join;
        AST post = node.getChild(2).getChild(0);
        if (post.getType() != 241) {
            op = this.anyOp(join, post);
        }
        return this.anyOp(op, node.getLastChild());
    }

    protected Operator nljoin(Operator in, AST node) throws QueryException {
        NLJoin join;
        Operator leftIn = this.anyOp(in, node.getChild(0).getChild(0));
        Cmp cmp = (Cmp)((Object)node.getProperty("cmp"));
        boolean isGcmp = node.checkProperty("GCmp");
        AST tmp = node.getChild(0);
        while (tmp.getType() != 241) {
            tmp = tmp.getLastChild();
        }
        Expr leftExpr = this.anyExpr(tmp.getChild(0));
        Operator rightIn = this.anyOp(new Start(), node.getChild(1));
        tmp = node.getChild(1);
        while (tmp.getType() != 241) {
            tmp = tmp.getLastChild();
        }
        Expr rightExpr = this.anyExpr(tmp.getChild(0));
        boolean leftJoin = node.checkProperty("leftJoin");
        boolean skipSort = node.checkProperty("skipSort");
        NLJoin op = join = new NLJoin(leftIn, rightIn, leftExpr, rightExpr, cmp, isGcmp, leftJoin);
        return this.anyOp(op, node.getLastChild());
    }

    protected Operator forBind(Operator in, AST node) throws QueryException {
        int pos = 0;
        AST runVarDecl = node.getChild(pos++);
        QNm runVarName = (QNm)runVarDecl.getChild(0).getValue();
        SequenceType runVarType = SequenceType.ITEM_SEQUENCE;
        if (runVarDecl.getChildCount() == 2) {
            runVarType = this.sequenceType(runVarDecl.getChild(1));
        }
        AST posBindingOrSourceExpr = node.getChild(pos++);
        QNm posVarName = null;
        if (posBindingOrSourceExpr.getType() == 10) {
            posVarName = (QNm)posBindingOrSourceExpr.getChild(0).getValue();
            posBindingOrSourceExpr = node.getChild(pos++);
        }
        Expr sourceExpr = this.expr(posBindingOrSourceExpr, true);
        Binding posBinding = null;
        this.table.bind(runVarName, runVarType);
        this.table.resolve(runVarName);
        if (posVarName != null) {
            posBinding = this.table.bind(posVarName, SequenceType.INTEGER);
            this.table.resolve(posVarName);
        }
        ForBind forBind = new ForBind(in, sourceExpr, false);
        if (posBinding != null) {
            forBind.bindPosition(posBinding.isReferenced());
        }
        this.addChecks(forBind, (List)node.getProperty("check"));
        return this.anyOp(forBind, node.getLastChild());
    }

    protected Operator letBind(Operator in, AST node) throws QueryException {
        int pos = 0;
        AST letVarDecl = node.getChild(pos++);
        QNm letVarName = (QNm)letVarDecl.getChild(0).getValue();
        SequenceType letVarType = SequenceType.ITEM_SEQUENCE;
        if (letVarDecl.getChildCount() == 2) {
            letVarType = this.sequenceType(letVarDecl.getChild(1));
        }
        Expr sourceExpr = this.expr(node.getChild(pos++), true);
        this.table.bind(letVarName, letVarType);
        this.table.resolve(letVarName);
        LetBind letBind = new LetBind(in, sourceExpr);
        this.addChecks(letBind, (List)node.getProperty("check"));
        return this.anyOp(letBind, node.getLastChild());
    }

    protected Operator count(Operator in, AST node) throws QueryException {
        int pos = 0;
        AST posVarDecl = node.getChild(pos++);
        QNm posVarName = (QNm)posVarDecl.getChild(0).getValue();
        SequenceType posVarType = SequenceType.ITEM_SEQUENCE;
        if (posVarDecl.getChildCount() == 2) {
            posVarType = this.sequenceType(posVarDecl.getChild(1));
        }
        Binding binding = this.table.bind(posVarName, posVarType);
        this.table.resolve(posVarName);
        Count count = new Count(in);
        this.addChecks(count, (List)node.getProperty("check"));
        return this.anyOp(count, node.getLastChild());
    }

    protected Operator select(Operator in, AST node) throws QueryException {
        int pos = 0;
        Expr expr = this.anyExpr(node.getChild(pos++));
        Select select = new Select(in, expr);
        this.addChecks(select, (List)node.getProperty("check"));
        return this.anyOp(select, node.getLastChild());
    }

    protected Operator orderBy(Operator in, AST node) throws QueryException {
        int orderBySpecCount = node.getChildCount() - 1;
        Expr[] orderByExprs = new Expr[orderBySpecCount];
        Ordering.OrderModifier[] orderBySpec = new Ordering.OrderModifier[orderBySpecCount];
        for (int i = 0; i < orderBySpecCount; ++i) {
            AST orderBy = node.getChild(i);
            orderByExprs[i] = this.expr(orderBy.getChild(0), true);
            orderBySpec[i] = this.orderModifier(orderBy);
        }
        OrderBy orderBy = new OrderBy(in, orderByExprs, orderBySpec);
        this.addChecks(orderBy, (List)node.getProperty("check"));
        return this.anyOp(orderBy, node.getLastChild());
    }

    protected void addChecks(Check op, List<QNm> check) throws QueryException {
        if (check != null) {
            for (QNm checkVar : check) {
                this.table.resolve(checkVar, op.check());
            }
        }
    }

    protected Operator wrapDebugOutput(Operator root) {
        return new Print(root, System.out){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String asString(QueryContext ctx, Sequence sequence) throws QueryException {
                if (sequence == null) {
                    return "";
                }
                if (sequence instanceof Item) {
                    return sequence instanceof Node ? this.nodeAsString(ctx, (Node)sequence) : sequence.toString();
                }
                StringBuilder s = new StringBuilder("(");
                Iter it = sequence.iterate();
                try {
                    Item item = it.next();
                    while (item != null) {
                        s.append(sequence instanceof Node ? this.nodeAsString(ctx, (Node)sequence) : sequence.toString());
                        s.append(", ");
                        item = it.next();
                    }
                }
                finally {
                    s.append(")");
                    it.close();
                }
                return s.toString();
            }

            private String nodeAsString(QueryContext ctx, Node<?> node) {
                try {
                    switch (node.getKind()) {
                        case ELEMENT: {
                            return "<" + node.getName() + ">";
                        }
                        case ATTRIBUTE: {
                            return node.getName() + "='" + node.getValue() + "'";
                        }
                        case DOCUMENT: {
                            return "doc(" + node.getCollection().getName() + ")";
                        }
                    }
                    return node.getValue().stringValue();
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                    return "";
                }
            }
        };
    }
}

