/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.compiler.translator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.compiler.translator.Binding;
import org.brackit.xquery.compiler.translator.Reference;
import org.brackit.xquery.expr.BoundVariable;
import org.brackit.xquery.expr.Variable;
import org.brackit.xquery.module.Module;
import org.brackit.xquery.util.log.Logger;
import org.brackit.xquery.xdm.type.SequenceType;

public class VariableTable {
    private static final Logger log = Logger.getLogger(VariableTable.class);
    Binding[][] bTable = new Binding[1][3];
    int bLength;
    int bTableCounts;
    Module module;

    public VariableTable(Module module) {
        this.module = module;
    }

    public void resolve(QNm name, Reference ref) throws QueryException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Resolving %s", name));
        }
        for (int i = this.bLength - 1; i > -1; --i) {
            if (!this.bTable[this.bTableCounts][i].name.equals(name)) continue;
            this.bTable[this.bTableCounts][i].connect(ref);
            return;
        }
        log.error(this.dumpTable());
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Cannot resolve var %s", name);
    }

    public Variable resolve(QNm name) throws QueryException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Resolving %s", name));
        }
        for (int i = this.bLength - 1; i > -1; --i) {
            if (!this.bTable[this.bTableCounts][i].name.equals(name)) continue;
            BoundVariable variable = new BoundVariable(name, this.bTable[this.bTableCounts][i].type);
            this.bTable[this.bTableCounts][i].connect(variable);
            return variable;
        }
        Variable varRef = this.module.getVariables().resolve(name);
        if (varRef != null) {
            return varRef;
        }
        throw new QueryException(ErrorCode.BIT_DYN_RT_ILLEGAL_STATE_ERROR, "Could not resolve variable %s", name);
    }

    public Binding bind(QNm name, SequenceType type) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Binding %s", name));
        }
        if (this.bLength == this.bTable[this.bTableCounts].length) {
            this.bTable[this.bTableCounts] = Arrays.copyOf(this.bTable[this.bTableCounts], this.bTable[this.bTableCounts].length * 3 / 2 + 1);
        }
        Binding binding = new Binding(name, type, this.bLength > 0 ? this.bTable[this.bTableCounts][this.bLength - 1] : null);
        if (this.bLength > 0) {
            this.bTable[this.bTableCounts][this.bLength - 1].append(binding);
        } else if (this.bTable[this.bTableCounts][0] != null) {
            if (++this.bTableCounts == this.bTable.length) {
                this.bTable = (Binding[][])Arrays.copyOf(this.bTable, this.bTable.length * 3 / 2 + 1);
            }
            this.bTable[this.bTableCounts] = new Binding[3];
        }
        this.bTable[this.bTableCounts][this.bLength++] = binding;
        return binding;
    }

    public void unbind() {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Unbinding %s", this.bTable[this.bTableCounts][this.bLength - 1].name));
        }
        --this.bLength;
        if (this.bLength > 0 && !this.bTable[this.bTableCounts][this.bLength].isReferenced()) {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Unchain unused binding %s", this.bTable[this.bTableCounts][this.bLength].name));
            }
            this.bTable[this.bTableCounts][this.bLength].unchain();
        }
    }

    public void resolvePositions() {
        for (int i = 0; i <= this.bTableCounts && this.bTable[i][0] != null; ++i) {
            if (log.isTraceEnabled()) {
                log.trace(this.dumpTable());
            }
            this.bTable[i][0].resolvePositions(-1);
        }
    }

    public String dumpTable() {
        StringWriter out = new StringWriter();
        PrintWriter printer = new PrintWriter(out);
        for (int i = 0; i <= this.bTableCounts && this.bTable[i][0] != null; ++i) {
            printer.write(10);
            printer.write("Root " + i);
            printer.write(10);
            this.bTable[i][0].dump(printer);
        }
        return out.toString();
    }

    public Binding[] bound() {
        return Arrays.copyOf(this.bTable[this.bTableCounts], this.bLength);
    }
}

