/*
 * Decompiled with CFR 0.152.
 */
package org.brackit.xquery.expr;

import java.util.List;
import org.brackit.xquery.ErrorCode;
import org.brackit.xquery.QueryContext;
import org.brackit.xquery.QueryException;
import org.brackit.xquery.Tuple;
import org.brackit.xquery.array.DArray;
import org.brackit.xquery.atomic.IntNumeric;
import org.brackit.xquery.sequence.ItemSequence;
import org.brackit.xquery.xdm.Expr;
import org.brackit.xquery.xdm.Item;
import org.brackit.xquery.xdm.Iter;
import org.brackit.xquery.xdm.Sequence;
import org.brackit.xquery.xdm.Type;
import org.brackit.xquery.xdm.json.Array;
import org.magicwerk.brownies.collections.GapList;

public final class ArrayAccessExpr
implements Expr {
    private final Expr expr;
    private final Expr index;

    public ArrayAccessExpr(Expr expr, Expr index) {
        this.expr = expr;
        this.index = index;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        Item array = this.expr.evaluateToItem(ctx, tuple);
        if (array == null) {
            return null;
        }
        if (!(array instanceof Array)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", array.itemType(), Type.INR);
        }
        Item i = this.index.evaluateToItem(ctx, tuple);
        if (i == null) {
            Item item;
            Iter it = array.iterate();
            GapList buffer = new GapList(((Array)array).len());
            while ((item = it.next()) != null) {
                buffer.add((Object)item);
            }
            return new ItemSequence((Item[])buffer.toArray((Object[])new Item[0]));
        }
        if (!(i instanceof IntNumeric)) {
            throw new QueryException(ErrorCode.ERR_TYPE_INAPPROPRIATE_TYPE, "Illegal operand type '%s' where '%s' is expected", i.itemType(), Type.INR);
        }
        return ((Array)array).at((IntNumeric)i);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence res = this.evaluate(ctx, tuple);
        if (res == null || res instanceof Item) {
            return (Item)res;
        }
        GapList values = new GapList();
        try (Iter it = res.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                values.add((Object)item);
            }
        }
        return new DArray((List<? extends Sequence>)values);
    }

    @Override
    public boolean isUpdating() {
        return this.expr.isUpdating() || this.index.isUpdating();
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

